/*
 * The MIT License
 *
 * Copyright 2016 nt.gocha@gmail.com.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.cli.fun;


import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Help;
import xyz.cofe.cli.Name;
import xyz.cofe.io.IOFun;

/**
 *
 * @author nt.gocha@gmail.com
 */
public class PrintFn
extends BaseCLIFun
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(PrintFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="print stream">
    @Fun(operator = true) @Name(name = "print")
    @Help( shortDesc = "print stream data to std. i/o" )
    public void print(
        @Name(name = "stream")
        InputStream stream
    ){
        if( stream==null )throw new IllegalArgumentException( "stream==null" );
        try {
            IOFun.copy(stream, System.out);
        } catch (IOException ex) {
            Logger.getLogger(PrintFn.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="print message">
    @Fun @Name(name = "print")
    @Help( shortDesc = "print message to std. i/o" )
    public void print(
        @Name(name = "message")
        String message
    ){
        if( message!=null ){
            getOutput().print(message);
            getOutput().flush();
        }else{
            getOutput().print("null");
            getOutput().flush();
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="println message">
    @Fun @Name(name = "println")
    @Help( shortDesc = "print message with new line to std. i/o" )
    public void println(
        @Name(name = "message")
        String message
    ){
        if( message!=null ){
            getOutput().println(message);
            getOutput().flush();
        }else{
            getOutput().println("null");
            getOutput().flush();
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="print/println Number">
    //<editor-fold defaultstate="collapsed" desc="println number">
    @Fun @Name(name = "println")
    @Help( shortDesc = "print value with new line to std. i/o" )
    public void println(
            @Name(name = "value")
                    Number value
    ){
        if( value!=null ){
            getOutput().println(value);
            getOutput().flush();
        }else{
            getOutput().println("null");
            getOutput().flush();
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="print number">
    @Fun @Name(name = "print")
    @Help( shortDesc = "print value to std. i/o" )
    public void print(
            @Name(name = "value")
                    Number value
    ){
        if( value!=null ){
            getOutput().print(value);
            getOutput().flush();
        }else{
            getOutput().print("null");
            getOutput().flush();
        }
    }
    //</editor-fold>
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="print/println boolean/Boolean">
    //<editor-fold defaultstate="collapsed" desc="println Boolean">
    @Fun @Name(name = "println")
    @Help( shortDesc = "print value with new line to std. i/o" )
    public void println(
            @Name(name = "value")
                    Boolean value
    ){
        if( value!=null ){
            getOutput().println(value);
            getOutput().flush();
        }else{
            getOutput().println("null");
            getOutput().flush();
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="println boolean">
    @Fun @Name(name = "println")
    @Help( shortDesc = "print value with new line to std. i/o" )
    public void println(
            @Name(name = "value")
                    boolean value
    ){
        getOutput().println(value);
        getOutput().flush();
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="print Boolean">
    @Fun @Name(name = "print")
    @Help( shortDesc = "print value to std. i/o" )
    public void print(
            @Name(name = "value")
                    Boolean value
    ){
        if( value!=null ){
            getOutput().print(value);
            getOutput().flush();
        }else{
            getOutput().print("null");
            getOutput().flush();
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="print boolean">
    @Fun @Name(name = "print")
    @Help( shortDesc = "print value to std. i/o" )
    public void print(
            @Name(name = "value")
                    boolean value
    ){
        getOutput().print(value);
        getOutput().flush();
    }
    //</editor-fold>
    //</editor-fold>
}
