/*
 * The MIT License
 *
 * Copyright 2016 user.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.cli.fun;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Name;
import xyz.cofe.text.Text;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class StringFn
extends BaseCLIFun
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(StringFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();

    private static final boolean isLogWarning =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();

    private static final boolean isLogInfo =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();

    private static final boolean isLogFine =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();

    private static final boolean isLogFiner =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();

    private static final boolean isLogFinest =
        logLevel==null
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

//    public final UpMain upmain;
//    public static final WeakHashMap<Repo, String> repoNameMap = new WeakHashMap<Repo, String>();
//
//    public StringFn( UpMain upmain ){
//        if( upmain==null )throw new IllegalArgumentException( "upmain==null" );
//        this.upmain = upmain;
//    }
//
//    public void println(){
//        upmain.getOutput().println();
//    }
//
//    public void println(Object obj){
//        upmain.getOutput().println(obj);
//    }
//
//    public BasicTemplate.EasyTemplate template(String template){
//        return upmain.getOutput().template(template);
//    }

    //<editor-fold defaultstate="collapsed" desc="compare strings">
    //TODO doc it
    @Fun(operator = true) @Name(name = "==")
    public Boolean cmpEquals( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.equals(str2);
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "equ")
    public Boolean cmpEqualsNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.equals(str2);
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "!=")
    public Boolean cmpNotEquals( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return ! str1.equals(str2);
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "nequ")
    public Boolean cmpNotEqualsNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return ! str1.equals(str2);
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "<")
    public Boolean cmpLess( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) < 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "less")
    public Boolean cmpLessNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) < 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "<=")
    public Boolean cmpLessOrEquals( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) <= 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "lessEqu")
    public Boolean cmpLessOrEqualsNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) <= 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = ">")
    public Boolean cmpMore( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) < 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "more")
    public Boolean cmpMoreNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) < 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = ">=")
    public Boolean cmpMoreOrEquals( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) >= 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "moreEqu")
    public Boolean cmpMoreOrEqualsNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;
        return str1.compareTo(str2) >= 0;
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "*")
    public Boolean cmpWildcard( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;

        Pattern ptrn = Text.wildcard(str2, false, true);
        Matcher m = ptrn.matcher(str1);
        return m.matches();
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "wildcard")
    public Boolean cmpWildcardNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;

        Pattern ptrn = Text.wildcard(str2, false, true);
        Matcher m = ptrn.matcher(str1);
        return m.matches();
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "~")
    public Boolean cmpRegex( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;

        return str1.matches(str2);
    }

    //TODO doc it
    @Fun(operator = true) @Name(name = "regex")
    public Boolean cmpRegexNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return false;

        return str1.matches(str2);
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="length of string">
    //TODO doc it
    @Fun(operator = true) @Name(name = "length")
    public Integer length(String str){
        if( str==null )throw new IllegalArgumentException( "str==null" );
        return str.length();
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="concat strings">
    //TODO doc it
    @Fun(operator = true) @Name(name = "+")
    public String concat( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return str1;
        return str1 + str2;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="concatNamed strings">
    //TODO doc it
    @Fun(operator = true) @Name(name = "concat")
    public String concatNamed( String str1, String str2 ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( str2==null )return str1;
        return str1 + str2;
    }
//</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="repeat strings">
    //TODO doc it
    @Fun(operator = true) @Name(name = "repeat")
    public String repeat( String str1, int count ){
        if( str1==null )throw new IllegalArgumentException( "str1==null" );
        if( count<1 )return "";
        return Text.repeat(str1, count);
    }
//</editor-fold>

    //TODO doc it
    @Fun(operator = true) @Name(name = "encode")
    public String encode( String str ){
        if( str==null )throw new IllegalArgumentException( "str==null" );
        return Text.encodeStringConstant(str);
    }
}
