/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.DefineVar;
import xyz.cofe.cli.Memory;
import xyz.cofe.cli.Value;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.tree.AbstractTreeNode;
import xyz.cofe.text.parser.lex.FieldAccess;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

public class AssignVar
extends AbstractTreeNode<Value>
implements Value,
DefineVar {
    private static final Logger logger = Logger.getLogger(AssignVar.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock = new ReentrantLock();
    private Memory memory;
    private Value data;
    private FieldAccess field;
    protected Object assignedValue;
    protected TypeCastGraph typeCastGraph;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Value[] getChildren() {
        if (this.data == null) {
            return new Value[0];
        }
        return new Value[]{this.data};
    }

    public Memory getMemory() {
        return this.memory;
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    public Value getData() {
        return this.data;
    }

    public void setData(Value data) {
        this.data = data;
    }

    public FieldAccess getField() {
        return this.field;
    }

    @Override
    public String getVarName() {
        if (this.field == null) {
            return null;
        }
        return this.field.toString();
    }

    public void setField(FieldAccess field) {
        this.field = field;
    }

    @Override
    public Class getType() {
        if (this.data == null) {
            return Void.class;
        }
        return this.data.getType();
    }

    @Override
    public Class getVarType() {
        if (this.data == null) {
            return Void.class;
        }
        return this.data.getType();
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void setAssignedValue(Object assignedValue) {
        this.assignedValue = assignedValue;
    }

    @Override
    public Object getVarValue() {
        return this.assignedValue;
    }

    public TypeCastGraph getTypeCastGraph() {
        try {
            this.lock.lock();
            if (this.typeCastGraph != null) {
                TypeCastGraph typeCastGraph = this.typeCastGraph;
                return typeCastGraph;
            }
            TypeCastGraph typeCastGraph = this.typeCastGraph = new ExtendedCastGraph();
            return typeCastGraph;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTypeCastGraph(TypeCastGraph typeCastGraph) {
        try {
            this.lock.lock();
            this.typeCastGraph = typeCastGraph;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String getCodePath() {
        String codepath = "";
        for (Value v = this; v != null; v = (Value)v.getParent()) {
            int idx = v.getIndex();
            String cname = v.getClass().getName();
            String nodeText = Integer.toString(idx) + ":" + cname;
            codepath = codepath.length() > 0 ? nodeText + " / " + codepath : nodeText;
        }
        return codepath;
    }

    @Override
    public Object eval() {
        if (this.data == null) {
            return null;
        }
        if (this.memory == null) {
            return null;
        }
        Object v = this.data.eval();
        if (this.field == null) {
            throw new Error("can't assign var value, field not set, code=" + this.getCodePath());
        }
        String[] path = this.field.getAccessPath();
        if (path == null) {
            return null;
        }
        if (path.length == 0) {
            return null;
        }
        if (path.length == 1) {
            if (this.memory.getConsts().contains(path[0])) {
                throw new Error("can't assign var " + path[0] + " - variable is readonly");
            }
            this.memory.put(path[0], v);
            this.assignedValue = v;
            return v;
        }
        String err = this.assignStart(this.memory, path, v, new Func1<Object, Object>(){

            public Object apply(Object arg) {
                AssignVar.this.assignedValue = arg;
                return null;
            }
        });
        if (err == null) {
            return this.assignedValue;
        }
        this.assignedValue = null;
        throw new Error("can't assign var value, field not set, code=" + this.getCodePath() + ", " + err);
    }

    protected String assignStart(Memory mem, String[] path, Object value, Func1<Object, Object> assigned) {
        if (mem == null) {
            return "memory not set";
        }
        if (path == null) {
            return "var name (path) is null";
        }
        if (path.length == 0) {
            return "var name (path) is empty";
        }
        if (path.length == 1) {
            if (mem.getConsts().contains(path[0])) {
                throw new Error("can't assign var " + path[0] + " - variable is readonly");
            }
            mem.put(path[0], value);
            if (assigned != null) {
                assigned.apply(value);
            }
            return null;
        }
        Object root = mem.get(path[0]);
        if (root == null) {
            return "var " + path[0] + " not found";
        }
        String[] newpath = new String[path.length - 1];
        for (int i = 1; i < path.length; ++i) {
            newpath[i - 1] = path[i];
        }
        return this.assign(root, newpath, value, assigned);
    }

    protected String assign(Object root, String[] path, Object value, Func1<Object, Object> assigned) {
        if (root == null) {
            return "null reference";
        }
        if (path == null) {
            return "var name (path) is null";
        }
        if (path.length == 0) {
            return "var name (path) is empty";
        }
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(root.getClass());
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        if (path.length == 1) {
            return this.assign(root, path[0], value, assigned);
        }
        Object newroot = null;
        try {
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(path[0])) continue;
                if (pd.getPropertyType() == null) {
                    return "may be index property";
                }
                Method m = pd.getReadMethod();
                if (m == null) {
                    return "write only property";
                }
                newroot = m.invoke(root, new Object[0]);
                break;
            }
            if (newroot == null) {
                for (Field f : root.getClass().getFields()) {
                    if (!f.getName().equals(path[0])) continue;
                    newroot = f.get(root);
                    break;
                }
            }
            if (root instanceof Map) {
                newroot = ((Map)root).get(path[0]);
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        if (newroot == null) {
            return "property " + path[0] + " not found";
        }
        String[] newpath = new String[path.length - 1];
        for (int i = 1; i < path.length; ++i) {
            newpath[i - 1] = path[i];
        }
        return this.assign(newroot, newpath, value, assigned);
    }

    protected String assign(Object root, String property, Object value, Func1<Object, Object> assigned) {
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(root.getClass());
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        try {
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                if (!pd.getName().equals(property)) continue;
                if (pd.getPropertyType() == null) {
                    return "may be index property";
                }
                Method m = pd.getWriteMethod();
                if (m == null) {
                    return "read only property";
                }
                Class<?> t = pd.getPropertyType();
                if (value == null) {
                    m.invoke(root, value);
                    if (assigned != null) {
                        assigned.apply(value);
                    }
                } else if (t.isAssignableFrom(value.getClass())) {
                    m.invoke(root, value);
                    if (assigned != null) {
                        assigned.apply(value);
                    }
                } else {
                    Object v = this.getTypeCastGraph().cast(value, t);
                    m.invoke(root, v);
                    if (assigned != null) {
                        assigned.apply(v);
                    }
                }
                return null;
            }
            for (Field f : root.getClass().getFields()) {
                if (!f.getName().equals(property)) continue;
                Class<?> t = f.getType();
                if (value == null) {
                    f.set(root, value);
                    if (assigned != null) {
                        assigned.apply(value);
                    }
                } else if (t.isAssignableFrom(value.getClass())) {
                    f.set(root, value);
                    if (assigned != null) {
                        assigned.apply(value);
                    }
                } else {
                    Object v = this.getTypeCastGraph().cast(value, t);
                    f.set(root, v);
                    if (assigned != null) {
                        assigned.apply(v);
                    }
                }
                return null;
            }
            if (root instanceof Map) {
                ((Map)root).put(property, value);
                if (assigned != null) {
                    assigned.apply(value);
                }
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
            return ex.getMessage();
        }
        return "property " + property + " not found";
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

