/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.SetOutput;
import xyz.cofe.cli.spi.CommandsPackage;
import xyz.cofe.text.Output;
import xyz.cofe.text.template.BasicTemplate;

public class BaseCLIFun
implements CommandsPackage,
SetOutput {
    private static final Logger logger = Logger.getLogger(BaseCLIFun.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Output output;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Output getOutput() {
        if (this.output == null) {
            this.output = new Output((OutputStream)System.out, true);
        }
        return this.output;
    }

    @Override
    public void setOutput(Output output) {
        this.output = output;
    }

    public void println() {
        this.getOutput().println();
    }

    public void println(Object obj) {
        this.getOutput().println(obj);
    }

    public BasicTemplate.EasyTemplate template(String template) {
        return this.getOutput().template(template);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

