/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.Console;

public class BaseConsole
implements Console {
    private static final Logger logger = Logger.getLogger(BaseConsole.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Scanner scanner;
    protected PrintWriter writer;
    protected final Lock lock = new ReentrantLock();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public BaseConsole() {
        this.scanner = new Scanner(System.in);
        this.writer = new PrintWriter(System.out);
    }

    public BaseConsole(InputStream instr, Charset cs) {
        if (instr == null) {
            throw new IllegalArgumentException("instr==null");
        }
        if (cs == null) {
            cs = Charset.defaultCharset();
        }
        this.scanner = new Scanner(instr, cs.name());
        this.writer = new PrintWriter(System.out);
    }

    public Scanner getScanner() {
        try {
            this.lock.lock();
            Scanner scanner = this.scanner;
            return scanner;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String readLine() {
        try {
            String line;
            this.lock.lock();
            String string = line = this.scanner.nextLine();
            this.lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void print(String text) {
        if (text == null) {
            return;
        }
        try {
            this.lock.lock();
            this.writer.print(text);
            this.writer.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void println() {
        try {
            this.lock.lock();
            this.writer.println();
            this.writer.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

