/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.Declaration;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.FunctionSetHelper;
import xyz.cofe.cli.GetHelp;
import xyz.cofe.cli.InteractiveShell;
import xyz.cofe.cli.Lexer;
import xyz.cofe.cli.Memory;
import xyz.cofe.cli.Parser;
import xyz.cofe.cli.SetOutput;
import xyz.cofe.cli.SourceDump;
import xyz.cofe.cli.TraceParser;
import xyz.cofe.cli.Value;
import xyz.cofe.cli.spi.CommandsPackage;
import xyz.cofe.collection.Pointer;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystems;
import xyz.cofe.text.Output;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.template.BasicTemplate;

public class CommandLineMachine {
    private final WeakHashMap setOutputCommands = new WeakHashMap();
    protected Output output;
    protected Memory memory;
    private boolean dump = false;
    private Output dumpOutput;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(CommandLineMachine.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(CommandLineMachine.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(CommandLineMachine.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(CommandLineMachine.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(CommandLineMachine.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(CommandLineMachine.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(CommandLineMachine.class.getName()).log(Level.SEVERE, null, ex);
    }

    public CommandLineMachine() {
        String dump_cli_var = System.getenv("DUMP_CLI");
        if (dump_cli_var != null) {
            this.dump = dump_cli_var.equalsIgnoreCase("true");
        }
        this.loadCommands();
    }

    public void loadCommands() {
        CommandLineMachine.registerCommands(this.getMemory(), this.getOutput(), this, this);
        for (CommandsPackage cp : ServiceLoader.load(CommandsPackage.class)) {
            if (cp == null) continue;
            this.loadCommands(cp);
            if (!(cp instanceof SetOutput)) continue;
            this.setOutputCommands.put(cp, true);
        }
    }

    public static void loadCommands(Memory memory, Output output, CommandLineMachine cli) {
        if (memory == null) {
            throw new IllegalArgumentException("memory==null");
        }
        for (CommandsPackage cp : ServiceLoader.load(CommandsPackage.class)) {
            if (cp == null) continue;
            CommandLineMachine.registerCommands(memory, output, cli, cp);
        }
    }

    public static void loadCommands(Memory memory, Output output) {
        if (memory == null) {
            throw new IllegalArgumentException("memory==null");
        }
        for (CommandsPackage cp : ServiceLoader.load(CommandsPackage.class)) {
            if (cp == null) continue;
            CommandLineMachine.registerCommands(memory, output, null, cp);
        }
    }

    public void loadCommands(Object commands) {
        if (commands == null) {
            return;
        }
        CommandLineMachine.registerCommands(this.getMemory(), this.getOutput(), this, commands);
    }

    public static void registerCommands(Memory memory, Output output, CommandLineMachine cli, Object commands) {
        if (memory == null) {
            throw new IllegalArgumentException("memory==null");
        }
        if (commands instanceof SetOutput && output != null) {
            ((SetOutput)commands).setOutput(output);
        }
        if (commands != null) {
            memory.inspect(commands, cli);
        }
    }

    public Output getOutput() {
        if (this.output != null) {
            return this.output;
        }
        this.output = new Output((OutputStream)System.out, true);
        return this.output;
    }

    public Memory getMemory() {
        if (this.memory != null) {
            return this.memory;
        }
        this.memory = new Memory();
        return this.memory;
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    public boolean isDump() {
        return this.dump;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public Output getDumpOutput() {
        if (this.dumpOutput != null) {
            return this.dumpOutput;
        }
        this.dumpOutput = new Output((OutputStream)System.out);
        return this.dumpOutput;
    }

    public void setDumpOutput(Output dumpOutput) {
        this.dumpOutput = dumpOutput;
    }

    public Parser createParser() {
        return this.createParser(null);
    }

    public Parser createParser(Boolean trace) {
        Parser parser = null;
        if (trace == null) {
            String traceEnvVar = System.getenv("TRACE_CLI");
            if (traceEnvVar != null && traceEnvVar.equalsIgnoreCase("true")) {
                trace = true;
            } else {
                String tr = System.getProperty("xyz.cofe.cli.CommandLineMachine.trace");
                if (tr != null && tr.equalsIgnoreCase("true")) {
                    trace = true;
                }
            }
        }
        if (trace != null && trace.booleanValue()) {
            String exclude_methods;
            TraceParser tparser = new TraceParser();
            parser = tparser;
            Output tout = null;
            String traceOut = System.getenv("TRACE_CLI_OUT");
            if (traceOut != null) {
                File traceFile = FileSystems.get((String)traceOut);
                File tdir = traceFile.getParent();
                if (!tdir.isExists()) {
                    tdir.mkdirs();
                }
                BufferedOutputStream outstrm = traceFile.openWrite();
                OutputStreamWriter outw = new OutputStreamWriter(outstrm);
                tout = new Output((Writer)outw, true);
            } else {
                tout = new Output((OutputStream)System.out, true);
            }
            tparser.getTraceOptions().setOutput(tout);
            String methods = System.getenv("TRACE_CLI_METHODS");
            if (methods != null) {
                String[] methods_arr = methods.split(",");
                tparser.getTraceOptions().getMethods().clear();
                tparser.getTraceOptions().getMethods().addAll(Arrays.asList(methods_arr));
            }
            if ((exclude_methods = System.getenv("TRACE_CLI_METHODS_EXCLUDE")) != null) {
                String[] methods_arr;
                for (String m : methods_arr = exclude_methods.split(",")) {
                    tparser.getTraceOptions().getMethods().remove(m);
                }
            }
        }
        if (parser == null) {
            parser = new Parser();
        }
        parser.setMemory(this.getMemory());
        return parser;
    }

    public Lexer createLexer() {
        Lexer lexer = new Lexer();
        if (this.dump) {
            lexer.setDumpOutput(this.getDumpOutput());
        }
        return lexer;
    }

    public Object start(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("args==null");
        }
        return this.start(this.createLexer().parse(args));
    }

    public Object start(String script) {
        if (script == null) {
            throw new IllegalArgumentException("script==null");
        }
        Lexer lexer = this.createLexer();
        lexer.setSkipWhitespace(true);
        Pointer<Token> ptr = lexer.parse(script);
        return this.start(ptr);
    }

    public Object start(Pointer<Token> toks) {
        if (toks == null) {
            throw new IllegalArgumentException("toks==null");
        }
        Parser parser = this.createParser();
        parser.setMemory(this.getMemory());
        Object res = null;
        Value v = parser.parse(toks);
        Throwable evalErr = null;
        if (v != null) {
            try {
                res = v.eval();
            }
            catch (Throwable err) {
                evalErr = err;
            }
            if (this.isDump()) {
                int i = -1;
                StringWriter sw = new StringWriter();
                SourceDump sdump = new SourceDump();
                sdump.setMemory(parser.getMemory());
                sdump.output(sw);
                sdump.dump(v);
                this.getDumpOutput().println(Text.indent((String)sw.toString().trim(), (String)"[dump source tree] "));
                this.getDumpOutput().flush();
                if (res != null) {
                    this.getDumpOutput().println(Text.indent((String)new Declaration().getTypeName(res.getClass()), (String)"[dump result type] "));
                    this.getDumpOutput().println(Text.indent((String)res.toString().trim(), (String)"[dump result     ] "));
                    this.getDumpOutput().flush();
                } else {
                    this.getDumpOutput().println("[dump result     ] null");
                    this.getDumpOutput().flush();
                }
            }
        }
        if (evalErr != null) {
            if (evalErr instanceof Error) {
                throw (Error)evalErr;
            }
            throw new Error(evalErr);
        }
        return res;
    }

    public InteractiveShell shell() {
        InteractiveShell shell = new InteractiveShell(this);
        this.getOutput().reset(shell.getOutputWriter());
        if (this.dump) {
            this.getDumpOutput().reset(shell.createConsoleWriter("   lexer> "));
        }
        return shell;
    }

    public String getHelp() {
        return this.generateHelp();
    }

    private Iterable<Function> getCommands() {
        FunctionSetHelper fshlp = new FunctionSetHelper(this.getMemory());
        fshlp = new FunctionSetHelper(fshlp.filter(fshlp.functions(), fshlp.not(fshlp.in(fshlp.operators().functions()))));
        return fshlp.functions();
    }

    private Map<String, Set<Function>> getCommandsMap() {
        LinkedHashMap<String, Set<Function>> m = new LinkedHashMap<String, Set<Function>>();
        for (Function f : this.getCommands()) {
            String name = this.getMemory().getNameOf(f);
            if (name == null) continue;
            Set<Function> sf = m.get(name);
            if (sf == null) {
                sf = new LinkedHashSet<Function>();
                m.put(name, sf);
            }
            sf.add(f);
        }
        return m;
    }

    private Map<Class, Set<Function>> getOperatorsMap() {
        LinkedHashMap<Class, Set<Function>> m = new LinkedHashMap<Class, Set<Function>>();
        FunctionSetHelper fshlp = new FunctionSetHelper(this.getMemory());
        fshlp = fshlp.operators();
        for (Function fOP : fshlp.functions()) {
            Class[] opParams = fOP.getParameters();
            if (opParams.length <= 0) continue;
            Set<Function> sf = m.get(opParams[0]);
            if (sf == null) {
                sf = new LinkedHashSet<Function>();
                m.put(opParams[0], sf);
            }
            sf.add(fOP);
        }
        return m;
    }

    private String generateHelp() {
        String commands = this.generateHelpOfCommands();
        String operators = this.generateHelpOfOperators();
        String help = BasicTemplate.template((String)"Commands:\n${commands}\n\nOperators:\n${operators}").align().bind("commands", (Object)commands).bind("operators", (Object)operators).eval();
        return help;
    }

    private String generateHelpOfOperators() {
        String fundescjoin = "\n\n";
        StringBuilder sb = new StringBuilder();
        Declaration decl = new Declaration(new Memory());
        for (Map.Entry<Class, Set<Function>> me : this.getOperatorsMap().entrySet()) {
            Class cls = me.getKey();
            sb.append("  ");
            sb.append(decl.getTypeName(cls));
            sb.append("\n");
            int i = -1;
            for (Function op : me.getValue()) {
                if (op == null) continue;
                ++i;
                String help = this.generateHelpOfOperator(op);
                if (help == null) continue;
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(help);
            }
            sb.append(fundescjoin);
        }
        return sb.toString();
    }

    private String generateHelpOfOperator(Function operator) {
        Declaration declr = new Declaration(this.getMemory());
        LinkedHashMap<String, String> help = new LinkedHashMap<String, String>();
        StringBuilder stmpl = new StringBuilder();
        String name = this.getMemory().getNameOf(operator);
        name = Text.trimStart((String)name, (String)this.getMemory().getOperatorPrefix());
        String shortDesc = null;
        String longDesc = null;
        String retHelp = null;
        help.put("name", name);
        help.put("declare", declr.getDeclareOf(operator));
        if (operator instanceof GetHelp) {
            String sample;
            Class[] paramTypes;
            GetHelp gh = (GetHelp)((Object)operator);
            shortDesc = gh.getShortHelp();
            help.put("short", shortDesc);
            stmpl.append("    ${help.declare}").append("\n");
            if (shortDesc != null && shortDesc.length() > 0) {
                stmpl.append("      ${help.short:60}");
                stmpl.append("\n");
            }
            if ((paramTypes = operator.getParameters()) != null && paramTypes.length > 0) {
                StringBuilder sptmpl = new StringBuilder();
                for (int pi = 0; pi < paramTypes.length; ++pi) {
                    String paramHelp = gh.getParameterHelp(pi);
                    if (paramHelp == null || paramHelp.length() <= 0) continue;
                    help.put("param" + pi + "name", declr.getParamNameOf(operator, pi));
                    help.put("param" + pi + "help", paramHelp);
                    help.put("param" + pi + "type", declr.getTypeName(paramTypes[pi]));
                    sptmpl.append("        ${help.param" + pi + "name}");
                    sptmpl.append(" : ${help.param" + pi + "type}");
                    sptmpl.append(" - ${help.param" + pi + "help:60}");
                    sptmpl.append("\n");
                }
                if (sptmpl.length() > 0) {
                    stmpl.append("      parameters:").append("\n");
                    stmpl.append((CharSequence)sptmpl);
                }
            }
            if ((retHelp = gh.getReturnHelp()) != null && retHelp.length() > 0) {
                help.put("return", retHelp);
                stmpl.append("      return:").append("\n");
                stmpl.append("        ${help.return:70}").append("\n");
            }
            if ((longDesc = gh.getLongHelp()) != null && longDesc.length() > 0) {
                help.put("long", longDesc);
                stmpl.append("      ${help.long:70}").append("\n");
            }
            if ((sample = gh.getSampleHelp()) != null && sample.length() > 0) {
                help.put("sample", sample);
                stmpl.append("      sample:").append("\n");
                stmpl.append("        ${help.sample:70}").append("\n");
            }
        }
        BasicTemplate.EasyTemplate templ = BasicTemplate.template((String)stmpl.toString());
        templ.bind("help", help);
        templ.align();
        return templ.eval();
    }

    private String generateHelpOfCommands() {
        String fundescjoin = "\n\n";
        StringBuilder sb = new StringBuilder();
        for (String name : this.getCommandsMap().keySet()) {
            for (Function fun : this.getCommandsMap().get(name)) {
                if (name == null || fun == null) continue;
                String funhelp = this.generateHelpOfCommand(name, fun);
                if (funhelp != null) {
                    funhelp = funhelp.trim();
                }
                if (funhelp == null) continue;
                if (sb.length() > 0) {
                    sb.append(fundescjoin);
                }
                sb.append(funhelp);
            }
        }
        return sb.toString();
    }

    private String generateHelpOfCommand(String name, Function fun) {
        LinkedHashMap<String, String> help = new LinkedHashMap<String, String>();
        StringBuilder stmpl = new StringBuilder();
        Declaration declaration = new Declaration();
        String decl = declaration.getDeclareOf(fun);
        help.put("name", name);
        help.put("declare", decl);
        String shortDesc = null;
        String longDesc = null;
        String retHelp = null;
        if (fun instanceof GetHelp) {
            String sample;
            GetHelp gh = (GetHelp)((Object)fun);
            shortDesc = gh.getShortHelp();
            longDesc = gh.getLongHelp();
            help.put("short", shortDesc);
            stmpl.append("  ${help.name}");
            if (shortDesc != null && shortDesc.length() > 0) {
                stmpl.append(" -  ${help.short:50}");
            }
            stmpl.append("\n");
            stmpl.append("    ${help.name}${help.declare}").append("\n");
            Class[] paramTypes = fun.getParameters();
            if (paramTypes != null && paramTypes.length > 0) {
                StringBuilder sptmpl = new StringBuilder();
                for (int pi = 0; pi < paramTypes.length; ++pi) {
                    String paramHelp = gh.getParameterHelp(pi);
                    if (paramHelp == null || paramHelp.length() <= 0) continue;
                    help.put("param" + pi + "name", declaration.getParamNameOf(fun, pi));
                    help.put("param" + pi + "help", paramHelp);
                    help.put("param" + pi + "type", declaration.getTypeName(paramTypes[pi]));
                    sptmpl.append("      ${help.param" + pi + "name}");
                    sptmpl.append(" : ${help.param" + pi + "type}");
                    sptmpl.append(" - ${help.param" + pi + "help:60}");
                    sptmpl.append("\n");
                }
                if (sptmpl.length() > 0) {
                    stmpl.append("    parameters:").append("\n");
                    stmpl.append((CharSequence)sptmpl);
                }
            }
            if ((retHelp = gh.getReturnHelp()) != null && retHelp.length() > 0) {
                help.put("return", retHelp);
                stmpl.append("    return:").append("\n");
                stmpl.append("      ${help.return:70}").append("\n");
            }
            if (longDesc != null && longDesc.length() > 0) {
                help.put("long", longDesc);
                stmpl.append("    ${help.long:70}").append("\n");
            }
            if ((sample = gh.getSampleHelp()) != null && sample.length() > 0) {
                help.put("sample", sample);
                stmpl.append("    sample:").append("\n");
                stmpl.append("      ${help.sample:70}").append("\n");
            }
        } else {
            stmpl.append("  ${help.name}").append("\n");
            stmpl.append("    ${help.name}${help.declare}").append("\n");
        }
        BasicTemplate.EasyTemplate templ = BasicTemplate.template((String)stmpl.toString());
        templ.bind("help", help);
        templ.align();
        return templ.eval();
    }
}

