/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.FunctionBuilder;
import xyz.cofe.cli.IsOperator;
import xyz.cofe.cli.Memory;
import xyz.cofe.cli.Name;
import xyz.cofe.text.Text;

public class Declaration {
    private static final Logger logger = Logger.getLogger(Declaration.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Memory memory;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Declaration() {
    }

    public Declaration(Memory mem) {
        this.memory = mem;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    public String getTypeName(Class type) {
        if (type == null) {
            return "void";
        }
        String ttname = type.getName();
        if (type == Integer.class) {
            ttname = "Integer";
        } else if (type == Boolean.class) {
            ttname = "Boolean";
        } else if (type == String.class) {
            ttname = "String";
        } else if (type == Integer.TYPE) {
            ttname = "int";
        } else if (type == Boolean.TYPE) {
            ttname = "boolean";
        } else if (type == Double.class) {
            ttname = "Double";
        } else if (type == Double.TYPE) {
            ttname = "double";
        } else if (type == Float.class) {
            ttname = "Float";
        } else if (type == Float.TYPE) {
            ttname = "float";
        } else if (type == Long.class) {
            ttname = "Long";
        } else if (type == Long.TYPE) {
            ttname = "long";
        } else if (type == Short.class) {
            ttname = "Short";
        } else if (type == Short.TYPE) {
            ttname = "short";
        } else if (type == Byte.class) {
            ttname = "Byte";
        } else if (type == Byte.TYPE) {
            ttname = "byte";
        } else if (type == Void.class) {
            ttname = "void";
        }
        return ttname;
    }

    public String getParamNameOf(Function fun, int paramIndex) {
        if (fun == null) {
            throw new IllegalArgumentException("fun==null");
        }
        Class[] paramTypes = fun.getParameters();
        if (paramTypes == null || paramTypes.length == 0) {
            throw new IllegalArgumentException("fun not has parameters");
        }
        if (paramIndex < 0) {
            throw new IllegalArgumentException("paramIndex<0");
        }
        if (paramIndex >= paramTypes.length) {
            throw new IllegalArgumentException("paramIndex>=paramTypes.length(" + paramTypes.length + ")");
        }
        if (fun instanceof FunctionBuilder.MethodCall) {
            String[] namesOfparam = null;
            Method m = ((FunctionBuilder.MethodCall)fun).getMethod();
            Annotation[][] paramsAnn = m.getParameterAnnotations();
            namesOfparam = new String[paramsAnn.length];
            for (int i1 = 0; i1 < paramsAnn.length; ++i1) {
                for (Annotation a : paramsAnn[i1]) {
                    if (!(a instanceof Name)) continue;
                    namesOfparam[i1] = ((Name)a).name();
                }
            }
            if (paramIndex >= 0 && namesOfparam != null && paramIndex < namesOfparam.length && namesOfparam[paramIndex] != null) {
                return namesOfparam[paramIndex];
            }
        }
        return "arg" + paramIndex;
    }

    public String getDeclareOf(Function fun) {
        if (fun == null) {
            return "!null argument";
        }
        if (fun instanceof IsOperator && ((IsOperator)((Object)fun)).isOperator()) {
            return this.getDeclareOfOperator(fun);
        }
        return this.getDeclareOfCommand(fun);
    }

    protected String getDeclareOfOperator(Function fun) {
        String n;
        Class[] paramTypes = fun.getParameters();
        Class retType = fun.getReturn();
        String firstParam = paramTypes.length > 0 ? this.getTypeName(paramTypes[0]) : "";
        String secondParam = paramTypes.length > 1 ? this.getParamNameOf(fun, 1) + " : " + this.getTypeName(paramTypes[1]) : "";
        String retValue = this.getTypeName(retType);
        boolean retIsVoid = retType == null || retType == Void.class || retType.getName().equals("void");
        String funName = fun.toString();
        if (this.memory != null && (n = this.memory.getNameOf(fun)) != null && n.length() > 0) {
            funName = Text.trimStart((String)n, (String)this.memory.getOperatorPrefix());
        }
        if (paramTypes.length == 2) {
            if (retIsVoid) {
                return funName + " (" + secondParam + ")";
            }
            return funName + " (" + secondParam + ") : " + retValue;
        }
        if (paramTypes.length == 1) {
            if (retIsVoid) {
                return funName;
            }
            return funName + " : " + retValue;
        }
        return this.getDeclareOfCommand(fun);
    }

    protected String getDeclareOfCommand(Function fun) {
        StringBuilder fundecl = new StringBuilder();
        if (fun != null) {
            Class retType;
            boolean retIsVoid;
            Class[] paramTypes = fun.getParameters();
            if (paramTypes.length > 0) {
                fundecl.append("(");
                if (paramTypes.length > 0) {
                    fundecl.append(" ");
                    for (int pi = 0; pi < paramTypes.length; ++pi) {
                        if (pi > 0) {
                            fundecl.append(", ");
                        }
                        String argName = this.getParamNameOf(fun, pi);
                        String argTypeName = this.getTypeName(paramTypes[pi]);
                        fundecl.append(argName).append(":").append(argTypeName);
                    }
                    fundecl.append(" ");
                }
                fundecl.append(")");
            }
            boolean bl = retIsVoid = (retType = fun.getReturn()) == null || retType == Void.class || retType.getName().equals("void");
            if (!retIsVoid) {
                fundecl.append(":").append(this.getTypeName(retType));
            }
        } else {
            fundecl.append("!no declare");
        }
        return fundecl.toString();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

