/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.CommandLineMachine;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.GetHelp;
import xyz.cofe.cli.GetMethod;
import xyz.cofe.cli.Help;
import xyz.cofe.cli.IsOperator;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.Predicate;
import xyz.cofe.text.template.BasicTemplate;

public class FunctionBuilder {
    private static final Logger logger = Logger.getLogger(FunctionBuilder.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private CommandLineMachine cmdMachine;
    protected Func3<Function, CommandLineMachine, Object, Method> builder;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public CommandLineMachine getCmdMachine() {
        return this.cmdMachine;
    }

    public void setCmdMachine(CommandLineMachine cmdMachine) {
        this.cmdMachine = cmdMachine;
    }

    public Func3<Function, CommandLineMachine, Object, Method> getBuilder() {
        if (this.builder != null) {
            return this.builder;
        }
        this.builder = new Func3<Function, CommandLineMachine, Object, Method>(){

            public Function apply(CommandLineMachine cli, Object arg1, Method arg2) {
                return new MethodCall(cli, arg1, arg2);
            }
        };
        return this.builder;
    }

    public void setBuilder(Func3<Function, CommandLineMachine, Object, Method> builder) {
        this.builder = builder;
    }

    public Function create(Object owner, Method method) {
        if (owner == null) {
            throw new IllegalArgumentException("owner==null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method==null");
        }
        Function fun = (Function)this.getBuilder().apply((Object)this.getCmdMachine(), owner, (Object)method);
        return fun;
    }

    public Function[] create(Object owner, Predicate<Method> mfilter) {
        Method[] methods;
        if (owner == null) {
            throw new IllegalArgumentException("owner==null");
        }
        if (mfilter == null) {
            throw new IllegalArgumentException("mfilter==null");
        }
        Function[] res = new Function[]{};
        for (Method m : methods = owner.getClass().getMethods()) {
            Function f;
            if (!mfilter.validate((Object)m) || (f = this.create(owner, m)) == null) continue;
            res = Arrays.copyOf(res, res.length + 1);
            res[res.length - 1] = f;
        }
        return res;
    }

    public Function[] create(Object owner, final Class<? extends Annotation> ann) {
        if (owner == null) {
            throw new IllegalArgumentException("owner==null");
        }
        if (ann == null) {
            throw new IllegalArgumentException("ann==null");
        }
        Predicate<Method> p = new Predicate<Method>(){

            public boolean validate(Method t) {
                Object oann = t.getAnnotation(ann);
                return oann != null;
            }
        };
        return this.create(owner, p);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class MethodCall
    implements Function,
    IsOperator,
    GetHelp,
    GetMethod {
        private Object owner;
        private Method method;
        private boolean operator = false;
        private String shortHelp;
        private String longHelp;
        private String[] paramHelp;
        private String returnHelp;
        private String sampleHelp;

        public MethodCall(CommandLineMachine cli, Object owner, Method method) {
            if (owner == null) {
                throw new IllegalArgumentException("owner==null");
            }
            if (method == null) {
                throw new IllegalArgumentException("method==null");
            }
            this.owner = owner;
            this.method = method;
            Help h = method.getAnnotation(Help.class);
            if (h != null) {
                BasicTemplate.EasyTemplate etmpl;
                String string = this.shortHelp = h.shortDesc().length() > 0 ? h.shortDesc() : null;
                if (h.template() && this.shortHelp != null) {
                    etmpl = BasicTemplate.template((String)this.shortHelp);
                    etmpl.bind("owner", owner);
                    etmpl.bind("cli", (Object)cli);
                    etmpl.align();
                    this.shortHelp = etmpl.eval();
                }
                String string2 = this.longHelp = h.longDesc().length() > 0 ? h.longDesc() : null;
                if (h.template() && this.longHelp != null) {
                    etmpl = BasicTemplate.template((String)this.longHelp);
                    etmpl.bind("owner", owner);
                    etmpl.bind("cli", (Object)cli);
                    etmpl.align();
                    this.longHelp = etmpl.eval();
                }
                String string3 = this.sampleHelp = h.sample().length() > 0 ? h.sample() : null;
                if (h.template() && this.sampleHelp != null) {
                    etmpl = BasicTemplate.template((String)this.sampleHelp);
                    etmpl.bind("owner", owner);
                    etmpl.bind("cli", (Object)cli);
                    etmpl.align();
                    this.sampleHelp = etmpl.eval();
                }
                String string4 = this.returnHelp = h.returnDesc().length() > 0 ? h.returnDesc() : null;
                if (h.template() && this.returnHelp != null) {
                    etmpl = BasicTemplate.template((String)this.returnHelp);
                    etmpl.bind("owner", owner);
                    etmpl.bind("cli", (Object)cli);
                    etmpl.align();
                    this.returnHelp = etmpl.eval();
                }
                Annotation[][] anns = method.getParameterAnnotations();
                this.paramHelp = new String[anns.length];
                for (int pi = 0; pi < this.paramHelp.length; ++pi) {
                    for (Annotation ann : anns[pi]) {
                        String t;
                        if (!(ann instanceof Help)) continue;
                        Help ph = (Help)ann;
                        String shorth = ph.shortDesc();
                        String longh = ph.longDesc();
                        String string5 = t = longh != null && longh.length() > 0 ? longh : shorth;
                        if (t == null || t.length() <= 0) continue;
                        if (h.template()) {
                            BasicTemplate.EasyTemplate etmpl2 = BasicTemplate.template((String)t);
                            etmpl2.bind("owner", owner);
                            etmpl2.bind("cli", (Object)cli);
                            etmpl2.align();
                            t = etmpl2.eval();
                        }
                        this.paramHelp[pi] = t;
                    }
                }
            }
        }

        public MethodCall(MethodCall src) {
            if (src == null) {
                throw new IllegalArgumentException("src==null");
            }
            this.owner = src.owner;
            this.method = src.method;
            this.operator = src.operator;
            this.shortHelp = src.shortHelp;
            this.longHelp = src.longHelp;
            this.returnHelp = src.returnHelp;
            this.paramHelp = src.paramHelp;
            this.sampleHelp = src.sampleHelp;
        }

        @Override
        public String getShortHelp() {
            return this.shortHelp;
        }

        public void setShortHelp(String shortHelp) {
            this.shortHelp = shortHelp;
        }

        @Override
        public String getLongHelp() {
            return this.longHelp;
        }

        public void setLongHelp(String longHelp) {
            this.longHelp = longHelp;
        }

        @Override
        public String getSampleHelp() {
            return this.sampleHelp;
        }

        public void setSampleHelp(String sampleHelp) {
            this.sampleHelp = sampleHelp;
        }

        @Override
        public boolean isOperator() {
            return this.operator;
        }

        public void setOperator(boolean operator) {
            this.operator = operator;
        }

        public Object getOwner() {
            return this.owner;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Class[] getParameters() {
            return this.method.getParameterTypes();
        }

        public String[] getParamHelp() {
            return this.paramHelp;
        }

        public void setParamHelp(String[] paramHelp) {
            this.paramHelp = paramHelp;
        }

        @Override
        public String getParameterHelp(int parameterIndex) {
            if (parameterIndex < 0) {
                return null;
            }
            if (this.paramHelp == null) {
                return null;
            }
            if (parameterIndex >= this.paramHelp.length) {
                return null;
            }
            String s = this.paramHelp[parameterIndex];
            return s == null ? null : s;
        }

        @Override
        public Class getReturn() {
            return this.method.getReturnType();
        }

        @Override
        public String getReturnHelp() {
            return this.returnHelp;
        }

        public void setReturnHelp(String returnHelp) {
            this.returnHelp = returnHelp;
        }

        @Override
        public Object apply(Object ... args) {
            try {
                Object res = this.method.invoke(this.owner, args);
                return res;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(FunctionBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(FunctionBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(FunctionBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
            return null;
        }

        public String toString() {
            return "mcall" + (this.method != null ? " " + this.method : "");
        }
    }
}

