/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BasicValue;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.GetType;
import xyz.cofe.cli.TypeCastValue;
import xyz.cofe.cli.Value;
import xyz.cofe.collection.iterators.TreeWalk;

public class FunctionCall
extends BasicValue
implements GetType {
    private static final Logger logger = Logger.getLogger(FunctionCall.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Function function;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    @Override
    public Class getType() {
        if (this.function == null) {
            throw new IllegalStateException("function is not setted");
        }
        return this.function.getReturn();
    }

    @Override
    public Object eval() {
        if (this.function == null) {
            throw new IllegalStateException("function is not setted");
        }
        Value[] vchildren = this.getChildren();
        Class[] cparams = this.function.getParameters();
        if (cparams.length > vchildren.length) {
            throw new IllegalStateException("can't call function, arguments (total " + cparams.length + " count) not setted");
        }
        ArrayList<Object> largs = new ArrayList<Object>();
        for (int i = 0; i < cparams.length; ++i) {
            largs.add(vchildren[i].eval());
        }
        Object res = this.function.apply(largs.toArray());
        return res;
    }

    public int evalImplicitCastCount() {
        int c = 0;
        for (TreeWalk tv : this.tree()) {
            TypeCastValue tc;
            Object n;
            int fc = 0;
            int fci = -1;
            for (Value v : tv.nodePath()) {
                if (!(v instanceof FunctionCall) || ++fci <= 0) continue;
                ++fc;
            }
            if (fc >= true || !((n = tv.currentNode()) instanceof TypeCastValue) || !(tc = (TypeCastValue)n).isImplicit()) continue;
            ++c;
        }
        return c;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

