/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.FunctionSet;
import xyz.cofe.cli.IsOperator;
import xyz.cofe.cli.Memory;
import xyz.cofe.cli.SourceDump;
import xyz.cofe.collection.Iterators;
import xyz.cofe.collection.Predicate;

public class FunctionSetHelper {
    private static final Logger logger = Logger.getLogger(FunctionSetHelper.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Iterable<Function> funitr;
    private FunctionSet fset;
    private Memory mem;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public FunctionSetHelper(final Memory mem) {
        if (mem == null) {
            throw new IllegalArgumentException("mem==null");
        }
        this.mem = mem;
        this.funitr = new Iterable<Function>(){

            @Override
            public Iterator<Function> iterator() {
                ArrayList<Function> l = new ArrayList<Function>();
                for (Object o : mem.values()) {
                    if (o instanceof Function) {
                        l.add((Function)o);
                        continue;
                    }
                    if (!(o instanceof FunctionSet)) continue;
                    for (Function f : ((FunctionSet)o).getFunctions()) {
                        l.add(f);
                    }
                }
                return l.iterator();
            }
        };
    }

    public FunctionSetHelper(Iterable<Function> funitr) {
        if (funitr == null) {
            throw new IllegalArgumentException("funitr==null");
        }
        this.funitr = funitr;
    }

    public FunctionSetHelper(Map<String, Set<Function>> map) {
        if (map == null) {
            throw new IllegalArgumentException("map==null");
        }
        final Map<String, Set<Function>> mp = map;
        this.funitr = new Iterable<Function>(){

            @Override
            public Iterator<Function> iterator() {
                ArrayList lfun = new ArrayList();
                for (Map.Entry en : mp.entrySet()) {
                    lfun.addAll((Collection)en.getValue());
                }
                return lfun.iterator();
            }
        };
    }

    public FunctionSetHelper(FunctionSet fset) {
        this.fset = fset;
    }

    public Function first() {
        Iterator<Function> iterator = this.functions().iterator();
        if (iterator.hasNext()) {
            Function f = iterator.next();
            return f;
        }
        return null;
    }

    public FunctionSetHelper print() {
        OutputStreamWriter w = new OutputStreamWriter(System.out);
        this.print(w);
        try {
            w.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(FunctionSetHelper.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public FunctionSetHelper print(Writer w) {
        if (w == null) {
            throw new IllegalArgumentException("w==null");
        }
        SourceDump sdump = new SourceDump();
        int i = -1;
        for (Function f : this.functions()) {
            try {
                w.write(Integer.toString(++i));
                w.write(". ");
                w.write("\n");
            }
            catch (IOException ex) {
                Logger.getLogger(FunctionSetHelper.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this;
    }

    public Iterable<Function> functions() {
        if (this.fset != null) {
            return this.fset.getFunctions();
        }
        if (this.funitr != null) {
            return this.funitr;
        }
        return Iterators.empty();
    }

    public Iterable<Function> filter(Iterable<Function> src, Predicate<Function> f) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        if (f == null) {
            throw new IllegalArgumentException("f==null");
        }
        return Iterators.predicate(src, f);
    }

    public Predicate<Function> argumentsCountFilter(final Predicate<Integer> countPred) {
        if (countPred == null) {
            throw new IllegalArgumentException("countPred==null");
        }
        return new Predicate<Function>(){

            public boolean validate(Function t) {
                if (t == null) {
                    return false;
                }
                return countPred.validate((Object)t.getParameters().length);
            }
        };
    }

    public Predicate<Function> argumentsCountFilter(final int count) {
        return this.argumentsCountFilter(new Predicate<Integer>(){

            public boolean validate(Integer t) {
                return count == t;
            }
        });
    }

    public FunctionSetHelper argumentsCount(int count) {
        return new FunctionSetHelper(this.filter(this.functions(), this.argumentsCountFilter(count)));
    }

    public Predicate<Class> assignFromFilter(final Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        return new Predicate<Class>(){

            public boolean validate(Class t) {
                if (t == null) {
                    return false;
                }
                return t.isAssignableFrom(type);
            }
        };
    }

    public Predicate<Class> assignFromFilter2(final Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type==null");
        }
        return new Predicate<Class>(){

            public boolean validate(Class t) {
                if (t == null) {
                    return false;
                }
                return type.isAssignableFrom(t);
            }
        };
    }

    public Predicate<Function> functionArgumentsFilter(final Predicate<Class> ... argTypes) {
        if (argTypes == null) {
            throw new IllegalArgumentException("argTypes==null");
        }
        for (int ai = 0; ai < argTypes.length; ++ai) {
            if (argTypes[ai] != null) continue;
            throw new IllegalArgumentException("argTypes[" + ai + "]==null");
        }
        return new Predicate<Function>(){

            public boolean validate(Function f) {
                if (f == null) {
                    return false;
                }
                Class[] params = f.getParameters();
                if (params.length != argTypes.length) {
                    return false;
                }
                for (int i = 0; i < params.length; ++i) {
                    boolean m = argTypes[i].validate((Object)params[i]);
                    if (m) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public FunctionSetHelper functionArguments(Predicate<Class> ... argTypes) {
        return new FunctionSetHelper(this.filter(this.functions(), this.functionArgumentsFilter(argTypes)));
    }

    public Predicate<Function> functionArgumentFilter(final int argumentIndex, final Predicate<Class> argType) {
        if (argType == null) {
            throw new IllegalArgumentException("argType==null");
        }
        return new Predicate<Function>(){

            public boolean validate(Function f) {
                if (f == null) {
                    return false;
                }
                Class[] params = f.getParameters();
                if (argumentIndex >= params.length || argumentIndex < 0) {
                    return false;
                }
                return argType.validate((Object)params[argumentIndex]);
            }
        };
    }

    public FunctionSetHelper functionArgument(int argumentIndex, Predicate<Class> argType) {
        return new FunctionSetHelper(this.filter(this.functions(), this.functionArgumentFilter(argumentIndex, argType)));
    }

    public FunctionSetHelper named(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (this.mem == null) {
            return new FunctionSetHelper(Iterators.empty());
        }
        Object o = this.mem.get(name);
        if (o instanceof Function) {
            FunctionSetHelper fs = new FunctionSetHelper(Iterators.single((Object)((Function)o)));
            fs.mem = this.mem;
            return fs;
        }
        if (o instanceof FunctionSet) {
            FunctionSetHelper fs = new FunctionSetHelper(((FunctionSet)o).getFunctions());
            fs.mem = this.mem;
            return fs;
        }
        return new FunctionSetHelper(Iterators.empty());
    }

    public Predicate<Function> operatorFilter() {
        return new Predicate<Function>(){

            public boolean validate(Function f) {
                if (f == null) {
                    return false;
                }
                if (f instanceof IsOperator) {
                    return ((IsOperator)((Object)f)).isOperator();
                }
                return false;
            }
        };
    }

    public FunctionSetHelper operators() {
        return new FunctionSetHelper(this.filter(this.functions(), this.operatorFilter()));
    }

    public int count() {
        Iterable<Function> itrf = this.functions();
        long c = Iterators.count(itrf);
        return new Long(c).intValue();
    }

    public Predicate<Function> in(final Iterable<Function> src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        return new Predicate<Function>(){

            public boolean validate(Function f) {
                if (f == null) {
                    return false;
                }
                return Iterators.in((Object)f, (Iterable)src);
            }
        };
    }

    public Predicate<Function> not(final Predicate<Function> src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        return new Predicate<Function>(){

            public boolean validate(Function f) {
                if (f == null) {
                    return false;
                }
                return !src.validate((Object)f);
            }
        };
    }

    public Predicate<Function> and(final Predicate<Function> ... src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        return new Predicate<Function>(){

            public boolean validate(Function f) {
                if (src == null) {
                    return false;
                }
                if (src.length == 0) {
                    return false;
                }
                for (Predicate p : src) {
                    if (p.validate((Object)f)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public Predicate<Function> or(final Predicate<Function> ... src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        return new Predicate<Function>(){

            public boolean validate(Function f) {
                if (src == null) {
                    return false;
                }
                if (src.length == 0) {
                    return false;
                }
                for (Predicate p : src) {
                    if (!p.validate((Object)f)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

