/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseConsole;
import xyz.cofe.cli.CommandLineMachine;
import xyz.cofe.cli.Console;
import xyz.cofe.cli.JLineConsole;
import xyz.cofe.cli.Lexer;
import xyz.cofe.cli.Parser;
import xyz.cofe.cli.SourceDump;
import xyz.cofe.cli.Value;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Pointer;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.EndLineReWriter;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.Token;

public class InteractiveShell {
    private static final Logger logger = Logger.getLogger(InteractiveShell.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    protected CommandLineMachine cli;
    protected Func1<Boolean, String> exit;
    protected Lexer lexer;
    protected Parser parser;
    protected Map<String, String> openCloseMap = new LinkedHashMap<String, String>();
    protected Map<String, String> closeOpenMap = new LinkedHashMap<String, String>();
    protected Func1<Boolean, Object> printResult;
    protected boolean running = false;
    protected Console console;
    private Writer output;
    private String lastOutputLine;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public InteractiveShell(CommandLineMachine cli) {
        if (cli == null) {
            throw new IllegalArgumentException("cli==null");
        }
        this.lock = new ReentrantLock();
        this.cli = cli;
    }

    public CommandLineMachine getCli() {
        try {
            this.lock.lock();
            CommandLineMachine commandLineMachine = this.cli;
            return commandLineMachine;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Func1<Boolean, String> getExit() {
        try {
            this.lock.lock();
            if (this.exit != null) {
                Func1<Boolean, String> func1 = this.exit;
                return func1;
            }
            this.exit = new Func1<Boolean, String>(){

                public Boolean apply(String inputLine) {
                    if (inputLine == null) {
                        return true;
                    }
                    if (inputLine.trim().equalsIgnoreCase("exit")) {
                        return true;
                    }
                    return false;
                }
            };
            Func1<Boolean, String> func1 = this.exit;
            return func1;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setExit(Func1<Boolean, String> exit) {
        try {
            this.lock.lock();
            this.exit = exit;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Lexer getLexer() {
        try {
            this.lock.lock();
            if (this.lexer != null) {
                Lexer lexer = this.lexer;
                return lexer;
            }
            Lexer lexer = this.lexer = this.getCli().createLexer();
            return lexer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLexer(Lexer lexer) {
        try {
            this.lock.lock();
            this.lexer = lexer;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Parser getParser() {
        try {
            this.lock.lock();
            if (this.parser != null) {
                Parser parser = this.parser;
                return parser;
            }
            Parser parser = this.parser = this.cli.createParser();
            return parser;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setParser(Parser parser) {
        try {
            this.lock.lock();
            this.parser = parser;
            this.openCloseMap = null;
            this.closeOpenMap = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<String, String> getOpenCloseMap() {
        try {
            this.lock.lock();
            if (this.openCloseMap != null) {
                Map<String, String> map = this.openCloseMap;
                return map;
            }
            this.openCloseMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> en : this.getParser().getBrackets().entrySet()) {
                this.openCloseMap.put(en.getKey(), en.getValue());
            }
            Map<String, String> map = this.openCloseMap;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Map<String, String> getCloseOpenMap() {
        try {
            this.lock.lock();
            if (this.closeOpenMap != null) {
                Map<String, String> map = this.closeOpenMap;
                return map;
            }
            this.closeOpenMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> en : this.getParser().getBrackets().entrySet()) {
                this.closeOpenMap.put(en.getValue(), en.getKey());
            }
            Map<String, String> map = this.closeOpenMap;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Func1<Boolean, Object> getPrintResult() {
        try {
            this.lock.lock();
            if (this.printResult == null) {
                this.printResult = new Func1<Boolean, Object>(){

                    public Boolean apply(Object arg) {
                        return true;
                    }
                };
            }
            Func1<Boolean, Object> func1 = this.printResult;
            return func1;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setPrintResult(Func1<Boolean, Object> printResult) {
        try {
            this.lock.lock();
            this.printResult = printResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        try {
            this.lock.lock();
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setRunning(boolean running) {
        try {
            this.lock.lock();
            this.running = running;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Console getConsole() {
        try {
            this.lock.lock();
            if (this.console != null) {
                Console console = this.console;
                return console;
            }
            if (System.console() != null) {
                try {
                    this.console = new JLineConsole();
                }
                catch (IOException ex) {
                    this.console = new BaseConsole();
                }
            } else {
                this.console = new BaseConsole();
            }
            Console console = this.console;
            return console;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String getPromptInput() {
        return "   input> ";
    }

    protected String getPromptContinue() {
        return "continue> ";
    }

    protected String getPromptResult() {
        return "  result> ";
    }

    protected String getPromptError() {
        return "   error> ";
    }

    protected String getPromptOutput() {
        return "  output> ";
    }

    protected String getPromptDumpTree() {
        return "dumptree> ";
    }

    public Writer getOutputWriter() {
        try {
            this.lock.lock();
            if (this.output != null) {
                Writer writer = this.output;
                return writer;
            }
            Writer writer = this.output = this.createConsoleWriter(this.getPromptOutput());
            return writer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInputLine(String prompt) {
        try {
            String line;
            this.lock.lock();
            if (this.lastOutputLine != null && this.lastOutputLine.length() > 0) {
                this.getConsole().println();
            }
            if (prompt != null) {
                this.getConsole().print(prompt);
            }
            String string = line = this.getConsole().readLine();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void output(String text) {
        try {
            this.lock.lock();
            if (text == null) {
                return;
            }
            String[] lines = Text.splitNewLines((String)text);
            int linei = -1;
            for (String line : lines) {
                if (++linei > 0) {
                    this.getConsole().println();
                }
                this.getConsole().print(line);
                this.lastOutputLine = line;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Writer createConsoleWriter(final String indent) {
        Writer w = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                InteractiveShell.this.output(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
        if (indent == null || indent.length() < 1) {
            return w;
        }
        EndLineReWriter rewr = new EndLineReWriter(w){
            protected boolean indentWrited;
            {
                super(x0);
                this.indentWrited = false;
            }

            protected void writeIndent(boolean checkWrited) throws IOException {
                if (checkWrited && this.indentWrited) {
                    return;
                }
                this.writer.append(indent);
                this.indentWrited = true;
            }

            protected void writeChar(char c0) throws IOException {
                this.writeIndent(true);
                super.writeChar(c0);
            }

            public Writer append(char c) throws IOException {
                this.writeIndent(true);
                return super.append(c);
            }

            public Writer append(CharSequence csq, int start, int end) throws IOException {
                if (end - start > 0) {
                    this.writeIndent(true);
                }
                return super.append(csq, start, end);
            }

            public Writer append(CharSequence csq) throws IOException {
                if (csq.length() > 0) {
                    this.writeIndent(true);
                }
                return super.append(csq);
            }

            public void write(String str, int off, int len) throws IOException {
                if (len > 0) {
                    this.writeIndent(true);
                }
                super.write(str, off, len);
            }

            public void write(String str) throws IOException {
                if (str.length() > 0) {
                    this.writeIndent(true);
                }
                super.write(str);
            }

            public void write(char[] cbuf) throws IOException {
                if (cbuf.length > 0) {
                    this.writeIndent(true);
                }
                super.write(cbuf);
            }

            public void write(int c) throws IOException {
                this.writeIndent(true);
                super.write(c);
            }

            protected void writeEndLine() throws IOException {
                this.writer.append(EndLine.Default.get());
                this.indentWrited = false;
            }
        };
        return rewr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            String line;
            try {
                this.lock.lock();
                boolean runn = this.isRunning();
                if (runn) {
                    throw new IllegalStateException("start() already called and not stopped");
                }
                this.setRunning(true);
            }
            finally {
                this.lock.unlock();
            }
            StringBuilder buff = new StringBuilder();
            String prompt = this.getPromptInput();
            while ((line = this.readInputLine(prompt)) != null) {
                if (((Boolean)this.getExit().apply((Object)line)).booleanValue()) {
                    break;
                }
                if ((line = line.trim()).length() == 0) continue;
                buff.append(line).append(EndLine.Default.get());
                Pointer<Token> toks = this.getLexer().parse(buff.toString());
                Stack<String> waitCloseBR = new Stack<String>();
                int bracketBalance = 0;
                boolean succBracket = true;
                for (Token tok : toks.getList()) {
                    String txt = tok.getMatchedText();
                    if (Text.in((String)txt, this.getOpenCloseMap().keySet())) {
                        waitCloseBR.add(this.getOpenCloseMap().get(txt));
                        ++bracketBalance;
                        continue;
                    }
                    if (!Text.in((String)txt, this.getCloseOpenMap().keySet())) continue;
                    if (waitCloseBR.isEmpty()) {
                        succBracket = false;
                        break;
                    }
                    String wait = (String)waitCloseBR.pop();
                    if (txt.equals(wait)) {
                        --bracketBalance;
                        succBracket = true;
                        continue;
                    }
                    succBracket = false;
                    break;
                }
                if (bracketBalance > 0) {
                    prompt = this.getPromptContinue();
                    continue;
                }
                Value v = null;
                v = this.getParser().parse(toks);
                prompt = this.getPromptInput();
                buff.setLength(0);
                if (v == null) {
                    this.output(this.getPromptError() + "can't parse");
                    continue;
                }
                if (this.cli != null && this.cli.isDump()) {
                    StringWriter sw = new StringWriter();
                    SourceDump sdump = new SourceDump();
                    sdump.setMemory(this.getParser().getMemory());
                    sdump.output(sw);
                    sdump.dump(v);
                    this.output(Text.indent((String)sw.toString(), (String)this.getPromptDumpTree()));
                }
                Object res = null;
                try {
                    res = v.eval();
                }
                catch (Throwable err) {
                    this.output(Text.indent((String)err.getMessage(), (String)this.getPromptError()));
                    continue;
                }
                if (res == null || !((Boolean)this.getPrintResult().apply(res)).booleanValue()) continue;
                this.output(Text.indent((String)res.toString(), (String)this.getPromptResult()));
            }
        }
        finally {
            this.setRunning(false);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

