/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import xyz.cofe.cli.Console;

public class JLineConsole
implements Console {
    private static final Logger logger = Logger.getLogger(JLineConsole.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected ConsoleReader reader = new ConsoleReader();
    protected PrintWriter writer;
    protected final Lock lock = new ReentrantLock();
    public static final String escape = "\u001b[";
    public static final String resetAttrEscape = "escape+\"0m\"";

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Override
    public String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (IOException ex) {
            Logger.getLogger(JLineConsole.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void print(String text) {
        if (text == null) {
            return;
        }
        try {
            this.reader.print((CharSequence)text);
            this.reader.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(JLineConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void println() {
        try {
            this.reader.println();
            this.reader.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(JLineConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ConsoleReader getConsoleReader() {
        return this.reader;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static enum Color {
        Black,
        Red,
        Green,
        Yellow,
        Blue,
        Magenta,
        Cyan,
        White,
        LightBlack,
        LightRed,
        LightGreen,
        LightYellow,
        LightBlue,
        LightMagenta,
        LightCyan,
        LightWhite,
        Default;


        public String getBackgroudEscape() {
            switch (this) {
                case Black: {
                    return "\u001b[40m";
                }
                case Red: {
                    return "\u001b[41m";
                }
                case Green: {
                    return "\u001b[42m";
                }
                case Yellow: {
                    return "\u001b[43m";
                }
                case Blue: {
                    return "\u001b[44m";
                }
                case Magenta: {
                    return "\u001b[45m";
                }
                case Cyan: {
                    return "\u001b[46m";
                }
                case White: {
                    return "\u001b[47m";
                }
                case LightBlack: {
                    return "\u001b[100m";
                }
                case LightRed: {
                    return "\u001b[101m";
                }
                case LightGreen: {
                    return "\u001b[102m";
                }
                case LightYellow: {
                    return "\u001b[103m";
                }
                case LightBlue: {
                    return "\u001b[104m";
                }
                case LightMagenta: {
                    return "\u001b[105m";
                }
                case LightCyan: {
                    return "\u001b[106m";
                }
                case LightWhite: {
                    return "\u001b[107m";
                }
                case Default: {
                    return "\u001b[49m";
                }
            }
            return "\u001b[49m";
        }

        public String getForegroudEscape() {
            switch (this) {
                case Black: {
                    return "\u001b[30m";
                }
                case Red: {
                    return "\u001b[31m";
                }
                case Green: {
                    return "\u001b[32m";
                }
                case Yellow: {
                    return "\u001b[33m";
                }
                case Blue: {
                    return "\u001b[34m";
                }
                case Magenta: {
                    return "\u001b[35m";
                }
                case Cyan: {
                    return "\u001b[36m";
                }
                case White: {
                    return "\u001b[37m";
                }
                case LightBlack: {
                    return "\u001b[90m";
                }
                case LightRed: {
                    return "\u001b[91m";
                }
                case LightGreen: {
                    return "\u001b[92m";
                }
                case LightYellow: {
                    return "\u001b[93m";
                }
                case LightBlue: {
                    return "\u001b[94m";
                }
                case LightMagenta: {
                    return "\u001b[95m";
                }
                case LightCyan: {
                    return "\u001b[96m";
                }
                case LightWhite: {
                    return "\u001b[97m";
                }
            }
            return "\u001b[39m";
        }
    }
}

