/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Pointer;
import xyz.cofe.text.Output;
import xyz.cofe.text.parser.ListLexer;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.lex.AnyCharParser;
import xyz.cofe.text.parser.lex.FieldAccessParser;
import xyz.cofe.text.parser.lex.KeywordsParser;
import xyz.cofe.text.parser.lex.NumberConstParser;
import xyz.cofe.text.parser.lex.TextConstParser;
import xyz.cofe.text.parser.lex.WhiteSpace;
import xyz.cofe.text.parser.lex.WhiteSpaceParser;

public class Lexer {
    private static final Logger logger = Logger.getLogger(Lexer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Output dumpOutput;
    private boolean skipWhitespace = true;
    private boolean keepNewLine = true;
    private static String[] specChars;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    protected void dump(Output out, List<Token> tokens) {
        if (tokens == null) {
            return;
        }
        if (out == null) {
            return;
        }
        int ti = -1;
        for (Token t : tokens) {
            out.print(++ti + 1 + "/" + tokens.size() + ": ");
            if (t == null) {
                out.println("null");
                continue;
            }
            out.println(t.getMatchedText());
        }
    }

    public Output getDumpOutput() {
        return this.dumpOutput;
    }

    public void setDumpOutput(Output dumpOutput) {
        this.dumpOutput = dumpOutput;
    }

    public Pointer<Token> parse(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("args==null");
        }
        ArrayList<Token> ltokens = new ArrayList<Token>();
        for (String a : args) {
            if (a == null) continue;
            Token t = new Token("arg", a, 0, a.length());
            ltokens.add(t);
        }
        if (this.dumpOutput != null) {
            this.dump(this.dumpOutput, ltokens);
        }
        return new Pointer(ltokens);
    }

    public boolean isSkipWhitespace() {
        return this.skipWhitespace;
    }

    public void setSkipWhitespace(boolean skipWhitespace) {
        this.skipWhitespace = skipWhitespace;
    }

    public boolean isKeepNewLine() {
        return this.keepNewLine;
    }

    public void setKeepNewLine(boolean keepNewLine) {
        this.keepNewLine = keepNewLine;
    }

    public Pointer<Token> parse(String source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        ListLexer llex = new ListLexer();
        WhiteSpaceParser ws = new WhiteSpaceParser();
        llex.getParsers().add(ws);
        TextConstParser tconst = new TextConstParser();
        llex.getParsers().add(tconst);
        FieldAccessParser fa = new FieldAccessParser();
        llex.getParsers().add(fa);
        NumberConstParser numconst = new NumberConstParser();
        llex.getParsers().add(numconst);
        KeywordsParser kw = new KeywordsParser(false, specChars);
        llex.getParsers().add(kw);
        AnyCharParser anyc = new AnyCharParser();
        llex.getParsers().add(anyc);
        List ltoks = llex.parse(source);
        if (this.isSkipWhitespace()) {
            for (Object t : ltoks.toArray()) {
                if (!(t instanceof WhiteSpace)) continue;
                WhiteSpace wst = (WhiteSpace)t;
                String mt = wst.getMatchedText();
                boolean isNewLine = mt.equals("\n") | mt.equals("\r") | mt.equals("\n\r") | mt.equals("\r\n");
                if (!this.keepNewLine) {
                    ltoks.remove(t);
                    continue;
                }
                if (isNewLine) continue;
                ltoks.remove(t);
            }
        }
        if (this.dumpOutput != null) {
            this.dump(this.dumpOutput, ltoks);
        }
        return new Pointer(ltoks);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
        specChars = new String[]{"{", "}", "[", "]", "(", ")", "!", "+", "-", "*", "/", ".", ";", ",", "@", "#", "$", "'", "\"", "%", ":", "\\", "|", "^", "&", "=", "_", "<", ">", "<=", ">=", "<>", "!=", "==", "=>", "=<", "->", "`", "~", "--", "true", "false", "null"};
    }
}

