/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.CommandLineMachine;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.FunctionBuilder;
import xyz.cofe.cli.FunctionSet;
import xyz.cofe.cli.FunctionSetImpl;
import xyz.cofe.cli.IsOperator;
import xyz.cofe.cli.Name;
import xyz.cofe.cli.SetMemory;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.map.EventMap;
import xyz.cofe.collection.map.EventMapListener;
import xyz.cofe.collection.map.LockEventMap;
import xyz.cofe.collection.map.SimpleMapAdapter;
import xyz.cofe.collection.set.LockEventSet;
import xyz.cofe.text.Text;

public class Memory
extends LockEventMap<String, Object> {
    private static final Logger logger = Logger.getLogger(Memory.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final WeakHashMap<Object, String> nameMap = new WeakHashMap();
    private final SimpleMapAdapter<String, Object> nameListener = new SimpleMapAdapter<String, Object>(){

        protected void added(Object value, EventMap<String, Object> map, String key) {
            Memory.this.onNameAdded(key, value);
        }
    };
    protected String operatorPrefix = "$operator.";
    protected Set<String> consts;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Memory() {
        super(new LinkedHashMap(), (Lock)new ReentrantLock());
        this.addEventMapListener((EventMapListener)this.nameListener);
    }

    public Memory(Map<String, Object> wrappedMap) {
        super(wrappedMap == null ? new LinkedHashMap() : wrappedMap, (Lock)new ReentrantLock());
        this.addEventMapListener((EventMapListener)this.nameListener);
    }

    public Memory(Map<String, Object> wrappedMap, Lock lock) {
        super(wrappedMap == null ? new LinkedHashMap() : wrappedMap, lock == null ? new ReentrantLock() : lock);
        this.addEventMapListener((EventMapListener)this.nameListener);
    }

    private void onNameAdded(final String key, final Object val) {
        this.lockRun(new Func0(){

            public Object apply() {
                if (key != null && val != null && (val instanceof Function || val instanceof FunctionSet) && key.startsWith(Memory.this.getOperatorPrefix())) {
                    Memory.this.nameMap.put(val, Text.trimStart((String)key, (String)Memory.this.getOperatorPrefix()));
                    return null;
                }
                Memory.this.nameMap.put(val, key);
                return null;
            }
        });
    }

    public String getNameOf(final Object value) {
        return (String)this.lockRun(new Func0(){

            public Object apply() {
                if (value == null) {
                    return null;
                }
                String name = (String)Memory.this.nameMap.get(value);
                if (name != null) {
                    return name;
                }
                for (Map.Entry en : Memory.this.entrySet()) {
                    name = (String)en.getKey();
                    Object obj = en.getValue();
                    if (name == null) continue;
                    if (value == obj) {
                        if (obj instanceof IsOperator && ((IsOperator)obj).isOperator()) {
                            String res = Text.trimStart((String)name, (String)Memory.this.getOperatorPrefix());
                            Memory.this.nameMap.put(obj, res);
                            return res;
                        }
                        Memory.this.nameMap.put(obj, name);
                        return name;
                    }
                    if (!(obj instanceof FunctionSet)) continue;
                    for (Function f : ((FunctionSet)obj).getFunctions()) {
                        if (value != f) continue;
                        if (obj instanceof IsOperator && ((IsOperator)obj).isOperator() && name.startsWith(Memory.this.getOperatorPrefix())) {
                            String res = Text.trimStart((String)name, (String)Memory.this.getOperatorPrefix());
                            Memory.this.nameMap.put(obj, res);
                            return res;
                        }
                        Memory.this.nameMap.put(obj, name);
                        return name;
                    }
                }
                return null;
            }
        });
    }

    public String getOperatorPrefix() {
        return (String)this.lockRun(new Func0(){

            public Object apply() {
                if (Memory.this.operatorPrefix == null) {
                    Memory.this.operatorPrefix = "$operator.";
                }
                return Memory.this.operatorPrefix;
            }
        });
    }

    public void setOperatorPrefix(final String operatorPrefix) {
        this.lockRun(new Func0(){

            public Object apply() {
                Memory.this.operatorPrefix = operatorPrefix;
                return null;
            }
        });
    }

    public FunctionSet getFunctions(final String name) {
        return (FunctionSet)this.lockRun(new Func0(){

            public Object apply() {
                if (name == null) {
                    return null;
                }
                Object r = Memory.this.get(name);
                if (r instanceof Function || r instanceof FunctionSet) {
                    if (r instanceof FunctionSet) {
                        FunctionSetImpl fset = new FunctionSetImpl();
                        int count = 0;
                        for (Function f : ((FunctionSet)r).getFunctions()) {
                            if (f == null || f instanceof IsOperator && ((IsOperator)((Object)f)).isOperator()) continue;
                            fset.add(f);
                            ++count;
                        }
                        return count > 0 ? fset : null;
                    }
                    if (!(!(r instanceof Function) || r instanceof IsOperator && ((IsOperator)r).isOperator())) {
                        FunctionSetImpl fset = new FunctionSetImpl();
                        fset.add((Function)r);
                        return fset;
                    }
                }
                return null;
            }
        });
    }

    public FunctionSet getOperators(final String name) {
        return (FunctionSet)this.lockRun(new Func0(){

            public Object apply() {
                if (name == null) {
                    return null;
                }
                String opname = Memory.this.getOperatorPrefix() + Text.trimStart((String)name, (String)Memory.this.getOperatorPrefix());
                Object r = Memory.this.get(opname);
                if (r instanceof Function || r instanceof FunctionSet) {
                    if (r instanceof FunctionSet) {
                        FunctionSetImpl fset = new FunctionSetImpl();
                        int count = 0;
                        for (Function f : ((FunctionSet)r).getFunctions()) {
                            if (f == null || !(f instanceof IsOperator) || !((IsOperator)((Object)f)).isOperator()) continue;
                            fset.add(f);
                            ++count;
                        }
                        return count > 0 ? fset : null;
                    }
                    if (r instanceof Function && r instanceof IsOperator && ((IsOperator)r).isOperator()) {
                        FunctionSetImpl fset = new FunctionSetImpl();
                        fset.add((Function)r);
                        return fset;
                    }
                }
                return null;
            }
        });
    }

    public Set<String> getConsts() {
        return (Set)this.lockRun(new Func0(){

            public Object apply() {
                if (Memory.this.consts != null) {
                    return Memory.this.consts;
                }
                Memory.this.consts = new LockEventSet(new LinkedHashSet(), Memory.this.getLockWrite());
                return Memory.this.consts;
            }
        });
    }

    protected String getFunTypeDesc(Function fun) {
        if (fun == null) {
            throw new IllegalArgumentException("fun==null");
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add(fun.getReturn().getName());
        for (Class p : fun.getParameters()) {
            types.add(p.getName());
        }
        return "(" + Text.join(types, (String)",") + ")";
    }

    public Object put(String key, Object value) {
        if (key != null && value != null && value instanceof Function) {
            this.add(key, (Function)value);
            return null;
        }
        return super.put((Object)key, value);
    }

    public void add(final String key, final Function fun) {
        this.lockRun(new Func0(){

            public Object apply() {
                if (key == null) {
                    throw new IllegalArgumentException("key==null");
                }
                if (fun == null) {
                    throw new IllegalArgumentException("fun==null");
                }
                boolean isop = fun instanceof IsOperator ? ((IsOperator)((Object)fun)).isOperator() : false;
                String addkey = isop ? Memory.this.getOperatorPrefix() + key : key;
                Object v = Memory.this.get(addkey);
                if (v != null && v instanceof Function) {
                    String decl2;
                    Function fexists = (Function)v;
                    String decl1 = Memory.this.getFunTypeDesc(fun);
                    if (decl1.equals(decl2 = Memory.this.getFunTypeDesc(fexists))) {
                        Memory.super.put(addkey, fun);
                    } else {
                        FunctionSetImpl funs = new FunctionSetImpl();
                        funs.add((Function)v);
                        funs.add(fun);
                        Memory.super.put(addkey, funs);
                    }
                } else if (v != null && v instanceof FunctionSet) {
                    String decl1 = Memory.this.getFunTypeDesc(fun);
                    FunctionSetImpl funs = new FunctionSetImpl();
                    for (Function f : ((FunctionSet)v).getFunctions()) {
                        String decl2 = Memory.this.getFunTypeDesc(f);
                        if (decl1.equals(decl2)) continue;
                        funs.add(f);
                    }
                    funs.add(fun);
                    Memory.super.put(addkey, funs);
                } else {
                    Memory.super.put(addkey, fun);
                }
                return null;
            }
        });
    }

    public void inspect(Object own) {
        this.inspect(own, null);
    }

    public void inspect(Object own, CommandLineMachine cli) {
        Function[] funs;
        if (own == null) {
            throw new IllegalArgumentException("own==null");
        }
        FunctionBuilder fb = new FunctionBuilder();
        fb.setCmdMachine(cli);
        for (Function fun : funs = fb.create(own, Fun.class)) {
            Name nameann;
            if (fun instanceof SetMemory) {
                ((SetMemory)((Object)fun)).setMemory(this);
            }
            if (!(fun instanceof FunctionBuilder.MethodCall)) continue;
            FunctionBuilder.MethodCall mc = (FunctionBuilder.MethodCall)fun;
            Method m = mc.getMethod();
            Fun fn = m.getAnnotation(Fun.class);
            if (fn != null && fn.operator()) {
                mc.setOperator(true);
            }
            String n = (nameann = m.getAnnotation(Name.class)) == null ? m.getName() : nameann.name();
            this.add(n, mc);
            if (fn == null || !fn.readonly()) continue;
            this.getConsts().add(n);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

