/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.AssignVar;
import xyz.cofe.cli.ConstString;
import xyz.cofe.cli.ConstValue;
import xyz.cofe.cli.DefineVar;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.FunctionCall;
import xyz.cofe.cli.FunctionSet;
import xyz.cofe.cli.FunctionSetHelper;
import xyz.cofe.cli.FunctionSetImpl;
import xyz.cofe.cli.GetType;
import xyz.cofe.cli.IsOperator;
import xyz.cofe.cli.LambdaCall;
import xyz.cofe.cli.Memory;
import xyz.cofe.cli.ReadVar;
import xyz.cofe.cli.Sequence;
import xyz.cofe.cli.SourceDump;
import xyz.cofe.cli.TypeCastValue;
import xyz.cofe.cli.Value;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.collection.Func3;
import xyz.cofe.collection.Func4;
import xyz.cofe.collection.Func5;
import xyz.cofe.collection.Func6;
import xyz.cofe.collection.Func7;
import xyz.cofe.collection.Func8;
import xyz.cofe.collection.Func9;
import xyz.cofe.collection.Pointer;
import xyz.cofe.collection.map.LockEventMap;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.lex.FieldAccess;
import xyz.cofe.text.parser.lex.FieldAccessParser;
import xyz.cofe.text.parser.lex.NumberConst;
import xyz.cofe.text.parser.lex.NumberConstParser;
import xyz.cofe.text.parser.lex.TextConst;
import xyz.cofe.text.parser.lex.TextConstParser;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

public class Parser {
    private static final Logger logger = Logger.getLogger(Parser.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;
    protected Memory memory;
    protected TypeCastGraph typeCastGraph;
    protected boolean requireNextStatementDelimiter = true;
    protected String[] nextStatement;
    protected boolean parseNumbers = true;
    protected String assignOpertator = "=";
    protected Map<String, String> brackets;
    protected String lambdaFollowOp = "=>";
    protected Stack<OperatorScope> operatorScope = new Stack();
    protected final List<DefineVarPtr> defineVars = new ArrayList<DefineVarPtr>();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Parser() {
        this.lock = new ReentrantLock();
    }

    protected void trace(String message) {
    }

    public Parser(Parser source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.lock = new ReentrantLock();
        try {
            source.lock.lock();
            this.memory = source.memory;
            this.typeCastGraph = source.typeCastGraph;
            this.assignOpertator = source.assignOpertator;
            this.requireNextStatementDelimiter = source.requireNextStatementDelimiter;
            this.nextStatement = source.nextStatement;
            this.parseNumbers = source.parseNumbers;
            this.brackets = new LockEventMap(new LinkedHashMap(), this.lock);
            if (source.brackets != null) {
                this.brackets.putAll(source.brackets);
            }
            this.lambdaFollowOp = source.lambdaFollowOp;
        }
        finally {
            source.lock.unlock();
        }
    }

    public Parser clone() {
        return new Parser(this);
    }

    public Memory getMemory() {
        try {
            this.lock.lock();
            if (this.memory != null) {
                Memory memory = this.memory;
                return memory;
            }
            Memory memory = this.memory = new Memory(new LinkedHashMap<String, Object>(), this.lock);
            return memory;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMemory(Memory memory) {
        try {
            this.lock.lock();
            this.memory = memory;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TypeCastGraph getTypeCastGraph() {
        try {
            this.lock.lock();
            if (this.typeCastGraph != null) {
                TypeCastGraph typeCastGraph = this.typeCastGraph;
                return typeCastGraph;
            }
            TypeCastGraph typeCastGraph = this.typeCastGraph = new ExtendedCastGraph();
            return typeCastGraph;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setTypeCastGraph(TypeCastGraph typeCastGraph) {
        try {
            this.lock.lock();
            this.typeCastGraph = typeCastGraph;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRequireNextStatementDelimiter() {
        try {
            this.lock.lock();
            boolean bl = this.requireNextStatementDelimiter;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setRequireNextStatementDelimiter(boolean requireNextStatementDelimiter) {
        try {
            this.lock.lock();
            this.requireNextStatementDelimiter = requireNextStatementDelimiter;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNextStatement(String st) {
        try {
            this.lock.lock();
            if (st == null) {
                boolean bl = false;
                return bl;
            }
            for (String s : this.getNextStatement()) {
                if (s == null || !s.equals(st)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String[] getNextStatement() {
        try {
            this.lock.lock();
            if (this.nextStatement == null) {
                this.nextStatement = new String[]{";", ",", "\n\r", "\r\n", "\n", "\r"};
            }
            String[] stringArray = this.nextStatement;
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setNextStatement(String[] nextStatement) {
        try {
            this.lock.lock();
            this.nextStatement = nextStatement;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isParseNumbers() {
        try {
            this.lock.lock();
            boolean bl = this.parseNumbers;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setParseNumbers(boolean parseNumbers) {
        try {
            this.lock.lock();
            this.parseNumbers = parseNumbers;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getAssignOpertator() {
        try {
            this.lock.lock();
            String string = this.assignOpertator;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setAssignOpertator(String assignOpertator) {
        try {
            this.lock.lock();
            this.assignOpertator = assignOpertator;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, String> getBrackets() {
        try {
            this.lock.lock();
            if (this.brackets != null) {
                Map<String, String> map = this.brackets;
                return map;
            }
            this.brackets = new LockEventMap(new LinkedHashMap(), this.lock);
            this.brackets.put("(", ")");
            this.brackets.put("{", "}");
            this.brackets.put("[", "]");
            Map<String, String> map = this.brackets;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Value parse(Pointer<Token> ptr) {
        if (ptr == null) {
            throw new IllegalArgumentException("ptr==null");
        }
        try {
            this.lock.lock();
            this.defineVars.clear();
            Value value = this.statements(ptr);
            return value;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Value statements(Pointer<Token> ptr) {
        Value vOP2;
        String s;
        FunctionSet operators;
        String expandOperatorName;
        Token t;
        Value vOP1 = this.operator(ptr, null);
        if (vOP1 == null) return null;
        while ((t = (Token)ptr.lookup(0)) != null && !this.isBracket(expandOperatorName = t.getMatchedText()) && !this.isNextStatement(expandOperatorName) && (operators = this.getMemory().getOperators(expandOperatorName)) != null) {
            int pbefore = ptr.getIndex();
            ptr.push();
            Value lOP = this.operator(ptr, vOP1);
            if (lOP != null) {
                int pafter = ptr.getIndex();
                if (pafter > pbefore) {
                    vOP1 = lOP;
                    ptr.pop();
                    continue;
                }
                ptr.restore();
                break;
            }
            ptr.restore();
            break;
        }
        String string = s = (t = (Token)ptr.lookup(0)) != null ? t.getMatchedText() : null;
        if (s == null) return vOP1;
        if (this.isRequireNextStatementDelimiter()) {
            if (!this.isNextStatement(s)) return vOP1;
            ptr.push();
            ptr.move(1);
            vOP2 = this.statements(ptr);
            if (vOP2 != null) {
                ptr.pop();
                if (vOP2 instanceof Sequence) {
                    Sequence sv = new Sequence();
                    sv.getChildrenList().add((Object)vOP1);
                    sv.getChildrenList().addAll((Collection)((Sequence)vOP2).getChildrenList());
                    return sv;
                }
                Sequence sv = new Sequence();
                sv.appendChild(vOP1);
                sv.appendChild(vOP2);
                return sv;
            }
            ptr.restore();
            return vOP1;
        } else {
            ptr.push();
            if (this.isNextStatement(s)) {
                ptr.move(1);
            }
            String string2 = s = (t = (Token)ptr.lookup(0)) != null ? t.getMatchedText() : null;
            if (s == null) {
                return vOP1;
            }
            vOP2 = this.statements(ptr);
            if (vOP2 != null) {
                ptr.pop();
                Sequence sv = new Sequence();
                sv.appendChild(vOP1);
                sv.appendChild(vOP2);
                return sv;
            }
            ptr.restore();
        }
        return vOP1;
    }

    public String getLambdaFollowOp() {
        try {
            this.lock.lock();
            if (this.lambdaFollowOp == null) {
                this.lambdaFollowOp = "=>";
            }
            String string = this.lambdaFollowOp;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLambdaFollowOp(String lambdaFollowOp) {
        try {
            this.lock.lock();
            this.lambdaFollowOp = lambdaFollowOp;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected CatchedLambda catchLambda(Pointer<Token> ptr) {
        ArrayList<String> args;
        ArrayList<Token> body;
        block18: {
            String s;
            Token t;
            if (ptr == null) {
                return null;
            }
            ptr.push();
            body = new ArrayList<Token>();
            args = new ArrayList<String>();
            while ((t = (Token)ptr.lookup(0)) != null && (s = t.getMatchedText()).matches("^((_|\\w)(_|\\w|\\d)*)$")) {
                args.add(s);
                ptr.move(1);
            }
            if (args.size() < 1) {
                ptr.restore();
                return null;
            }
            Token toBodyPtr = (Token)ptr.lookup(0);
            if (toBodyPtr == null) {
                ptr.restore();
                return null;
            }
            String sToBody = toBodyPtr.getMatchedText();
            if (!sToBody.equals(this.getLambdaFollowOp())) {
                ptr.restore();
                return null;
            }
            ptr.move(1);
            Token t2 = null;
            t2 = (Token)ptr.lookup(0);
            if (t2 == null) {
                ptr.restore();
                return null;
            }
            String s2 = t2.getMatchedText();
            if (this.isBracket(s2)) {
                if (!this.getBrackets().containsKey(s2)) {
                    ptr.restore();
                    return null;
                }
                Stack<String> bracketStack = new Stack<String>();
                bracketStack.add(this.getBrackets().get(s2));
                body.add(t2);
                ptr.move(1);
                while (true) {
                    if ((t2 = (Token)ptr.lookup(0)) == null) {
                        if (!bracketStack.isEmpty()) {
                            ptr.restore();
                            return null;
                        }
                        break block18;
                    }
                    s2 = t2.getMatchedText();
                    if (this.isBracket(s2)) {
                        boolean openBr = this.getBrackets().containsKey(s2);
                        if (openBr) {
                            bracketStack.add(this.getBrackets().get(s2));
                            body.add(t2);
                            ptr.move(1);
                            continue;
                        }
                        if (bracketStack.isEmpty()) {
                            ptr.restore();
                            return null;
                        }
                        String cbr = (String)bracketStack.pop();
                        if (!cbr.equals(s2)) {
                            ptr.restore();
                            return null;
                        }
                        if (bracketStack.isEmpty()) {
                            body.add(t2);
                            ptr.move(1);
                            break block18;
                        }
                        body.add(t2);
                        ptr.move(1);
                        continue;
                    }
                    body.add(t2);
                    ptr.move(1);
                }
            }
            body.add(t2);
            ptr.move(1);
            while ((t2 = (Token)ptr.lookup(0)) != null) {
                s2 = t2.getMatchedText();
                if (this.isNextStatement(s2)) {
                    ptr.move(1);
                    break;
                }
                body.add(t2);
                ptr.move(1);
            }
        }
        ptr.pop();
        CatchedLambda clambda = new CatchedLambda();
        clambda.args = args;
        clambda.body = body;
        return clambda;
    }

    protected LambdaCall createLambdaCall(CatchedLambda clambda) {
        LambdaCall lcall = new LambdaCall();
        lcall.setParser(this.clone());
        lcall.setLambda(clambda);
        Class c = clambda.getFunType();
        if (c == null) {
            throw new Error("can't get class for CatchedLambda");
        }
        lcall.setType(c);
        return lcall;
    }

    protected LambdaCall createLambdaCall(CatchedLambda clambda, Class lambdaType) {
        LambdaCall lcall = new LambdaCall();
        lcall.setParser(this.clone());
        lcall.setLambda(clambda);
        lcall.setType(lambdaType);
        return lcall;
    }

    protected boolean isFunc(Class c) {
        if (c == null) {
            return false;
        }
        if (c.equals(Func0.class)) {
            return true;
        }
        if (c.equals(Func1.class)) {
            return true;
        }
        if (c.equals(Func2.class)) {
            return true;
        }
        if (c.equals(Func3.class)) {
            return true;
        }
        if (c.equals(Func4.class)) {
            return true;
        }
        if (c.equals(Func5.class)) {
            return true;
        }
        if (c.equals(Func6.class)) {
            return true;
        }
        if (c.equals(Func7.class)) {
            return true;
        }
        if (c.equals(Func8.class)) {
            return true;
        }
        return c.equals(Func9.class);
    }

    protected FunctionCall functionCall(Pointer<Token> ptr, Function fun) {
        Class[] funParamTypes = fun.getParameters();
        FunctionCall fcall = new FunctionCall();
        fcall.setFunction(fun);
        for (int parami = 0; parami < funParamTypes.length; ++parami) {
            Class vt;
            Value v;
            Class funParamType = funParamTypes[parami];
            if (this.isFunc(funParamType)) {
                LambdaCall v2;
                CatchedLambda clambda;
                int lambdaParamCountNeed = 1;
                if (funParamType.equals(Func0.class)) {
                    lambdaParamCountNeed = 0;
                }
                if (funParamType.equals(Func1.class)) {
                    lambdaParamCountNeed = 1;
                }
                if (funParamType.equals(Func2.class)) {
                    lambdaParamCountNeed = 2;
                }
                if (funParamType.equals(Func3.class)) {
                    lambdaParamCountNeed = 3;
                }
                if (funParamType.equals(Func4.class)) {
                    lambdaParamCountNeed = 4;
                }
                if (funParamType.equals(Func5.class)) {
                    lambdaParamCountNeed = 5;
                }
                if (funParamType.equals(Func6.class)) {
                    lambdaParamCountNeed = 6;
                }
                if (funParamType.equals(Func7.class)) {
                    lambdaParamCountNeed = 7;
                }
                if (funParamType.equals(Func8.class)) {
                    lambdaParamCountNeed = 8;
                }
                if (funParamType.equals(Func9.class)) {
                    lambdaParamCountNeed = 9;
                }
                if ((clambda = this.catchLambda(ptr)) != null && clambda.args.size() == lambdaParamCountNeed && (v2 = this.createLambdaCall(clambda, funParamType)) != null) {
                    fcall.appendChild(v2);
                    continue;
                }
            }
            if ((v = this.operator(ptr, null)) == null) {
                Parser.logFine("can't parse argument " + parami + "\nparse return null", new Object[0]);
                return null;
            }
            Class clazz = vt = v instanceof GetType ? v.getType() : null;
            if (vt == null) {
                Parser.logWarning("parsed argument (argument index=" + parami + ") not implement GetType", new Object[0]);
                return null;
            }
            boolean assign = funParamType.isAssignableFrom(vt);
            if (assign) {
                fcall.appendChild(v);
                continue;
            }
            TypeCastGraph tcgraph = this.getTypeCastGraph();
            List starts = tcgraph.findStartNode(vt, false, true, true, false);
            if (starts == null || starts.size() < 1) {
                return null;
            }
            List castPaths = tcgraph.getCastPaths(vt, funParamType);
            if (castPaths == null || castPaths.size() < 1) {
                return null;
            }
            TypeCastValue tcval = new TypeCastValue();
            tcval.setFromType(vt);
            tcval.setType(funParamType);
            tcval.setTypeCastGraph(this.getTypeCastGraph());
            tcval.appendChild(v);
            tcval.setImplicit(true);
            fcall.appendChild(tcval);
        }
        return fcall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Value operator(Pointer<Token> ptr, Value v1) {
        OperatorScope scope = new OperatorScope();
        this.operatorScope.push(scope);
        scope.v1 = v1;
        try {
            CatchedLambda clambda;
            boolean binaryWaitLambda;
            Object params;
            Class v1t;
            String t2s;
            String op;
            Memory mem;
            scope.mem = mem = this.getMemory();
            Token t = (Token)ptr.lookup(0);
            scope.op = op = t != null ? t.getMatchedText() : null;
            if (op == null) {
                Value value = null;
                return value;
            }
            boolean v1evaled = false;
            if (v1 == null) {
                v1 = this.postfixVal(ptr);
                if (v1 == null) {
                    Value value = null;
                    return value;
                }
                v1evaled = true;
                scope.v1 = v1;
                scope.v1evaled = true;
            }
            if (this.isBracket(op)) {
                Value value = v1;
                return value;
            }
            if (this.isNextStatement(op)) {
                Value value = v1;
                return value;
            }
            if (v1evaled) {
                Token t2 = (Token)ptr.lookup(0);
                String string = t2s = t2 == null ? null : t2.getMatchedText();
                if (t2s != null) {
                    if (this.isBracket(t2s)) {
                        Value value = v1;
                        return value;
                    }
                    if (this.isNextStatement(t2s)) {
                        Value value = v1;
                        return value;
                    }
                    op = t2s;
                } else {
                    Value value = v1;
                    return value;
                }
            }
            if ((v1t = v1.getType()) == null) {
                t2s = null;
                return t2s;
            }
            FunctionSet fset = mem.getOperators(op);
            if (fset == null) {
                fset = new FunctionSetImpl();
            }
            ArrayList<Function> unaryFuns = new ArrayList<Function>();
            ArrayList<Function> binaryFuns = new ArrayList<Function>();
            int namedFunIdx = -1;
            for (Function f : fset.getFunctions()) {
                Class param1;
                if (f instanceof IsOperator && !((IsOperator)((Object)f)).isOperator()) continue;
                ++namedFunIdx;
                params = f.getParameters();
                if (((Class[])params).length == 1) {
                    param1 = params[0];
                    if (!param1.isAssignableFrom(v1t)) continue;
                    this.trace("named unary fun " + namedFunIdx + ": " + f);
                    unaryFuns.add(f);
                    continue;
                }
                if (((Class[])params).length != 2 || !(param1 = params[0]).isAssignableFrom(v1t)) continue;
                this.trace("named binay fun " + namedFunIdx + ": " + f);
                binaryFuns.add(f);
            }
            int unaryFunsCount = unaryFuns.size();
            int binaryFunsCount = binaryFuns.size();
            this.trace("unary count =" + unaryFunsCount + " binary count =" + binaryFunsCount);
            if (binaryFunsCount == 0 && unaryFunsCount == 0) {
                params = v1;
                return params;
            }
            if (binaryFunsCount < 1) {
                Value fUnaryCall;
                if (unaryFunsCount == 1) {
                    ptr.move(1);
                    fUnaryCall = new FunctionCall();
                    fUnaryCall.appendChild(v1);
                    Function f = (Function)unaryFuns.get(0);
                    ((FunctionCall)fUnaryCall).setFunction(f);
                    this.trace("return unary " + f);
                    Value value = fUnaryCall;
                    return value;
                }
                fUnaryCall = v1;
                return fUnaryCall;
            }
            ptr.push();
            ptr.move(1);
            Function firstBinary = (Function)binaryFuns.get(0);
            Class[] firstParams = firstBinary.getParameters();
            boolean bl = binaryWaitLambda = binaryFunsCount == 1 && firstBinary != null && firstParams != null && firstParams.length == 2 && this.isFunc(firstParams[1]);
            if (binaryWaitLambda && (clambda = this.catchLambda(ptr)) != null) {
                LambdaCall lc = this.createLambdaCall(clambda);
                FunctionCall fBinaryCall = new FunctionCall();
                fBinaryCall.appendChild(v1);
                fBinaryCall.appendChild(lc);
                fBinaryCall.setFunction(firstBinary);
                ptr.pop();
                this.trace("return binary with lambda " + firstBinary);
                FunctionCall functionCall = fBinaryCall;
                return functionCall;
            }
            Value v2 = this.operator(ptr, null);
            if (v2 != null) {
                Function opfun;
                Class v2t = v2.getType();
                if (v2t == null) {
                    ptr.restore();
                    if (unaryFunsCount == 1) {
                        ptr.move(1);
                        FunctionCall fUnaryCall = new FunctionCall();
                        fUnaryCall.appendChild(v1);
                        Function f = (Function)unaryFuns.get(0);
                        fUnaryCall.setFunction(f);
                        this.trace("return unary " + f);
                        FunctionCall functionCall = fUnaryCall;
                        return functionCall;
                    }
                    Value fUnaryCall = v1;
                    return fUnaryCall;
                }
                ArrayList<Function> explicitFuns = new ArrayList<Function>();
                for (Function f : binaryFuns) {
                    Class[] params2 = f.getParameters();
                    if (params2.length != 2 || !params2[1].isAssignableFrom(v2t)) continue;
                    explicitFuns.add(f);
                }
                int explicitFunsCount = explicitFuns.size();
                if (explicitFunsCount < 1 && binaryFunsCount == 1) {
                    opfun = (Function)binaryFuns.get(0);
                    Class[] paramTypes = opfun.getParameters();
                    TypeCastValue tcval = new TypeCastValue();
                    tcval.setTypeCastGraph(this.getTypeCastGraph());
                    tcval.setFromType(v2.getType());
                    tcval.setType(paramTypes[1]);
                    tcval.setImplicit(true);
                    tcval.appendChild(v2);
                    if (!tcval.canCast()) {
                        ptr.restore();
                        if (unaryFunsCount == 1) {
                            ptr.move(1);
                            FunctionCall fUnaryCall = new FunctionCall();
                            fUnaryCall.appendChild(v1);
                            Function f = (Function)unaryFuns.get(0);
                            fUnaryCall.setFunction(f);
                            this.trace("return unary " + f);
                            FunctionCall functionCall = fUnaryCall;
                            return functionCall;
                        }
                        Value fUnaryCall = v1;
                        return fUnaryCall;
                    }
                    FunctionCall fBinaryCall = new FunctionCall();
                    fBinaryCall.appendChild(v1);
                    fBinaryCall.appendChild(tcval);
                    fBinaryCall.setFunction(opfun);
                    ptr.pop();
                    this.trace("return binary implicit (explicit < 0) " + opfun);
                    FunctionCall functionCall = fBinaryCall;
                    return functionCall;
                }
                if (explicitFunsCount > 1) {
                    Value fUnaryCall;
                    ptr.restore();
                    if (unaryFunsCount == 1) {
                        ptr.move(1);
                        fUnaryCall = new FunctionCall();
                        fUnaryCall.appendChild(v1);
                        Function f = (Function)unaryFuns.get(0);
                        ((FunctionCall)fUnaryCall).setFunction(f);
                        this.trace("return unary (explicit > 0) " + f);
                        Value value = fUnaryCall;
                        return value;
                    }
                    fUnaryCall = v1;
                    return fUnaryCall;
                }
                opfun = (Function)explicitFuns.get(0);
                FunctionCall fBinaryCall = new FunctionCall();
                fBinaryCall.appendChild(v1);
                fBinaryCall.appendChild(v2);
                fBinaryCall.setFunction(opfun);
                this.trace("return binary explicit = 1 " + opfun);
                ptr.pop();
                FunctionCall functionCall = fBinaryCall;
                return functionCall;
            }
            ptr.restore();
            if (unaryFunsCount == 1) {
                ptr.move(1);
                FunctionCall fUnaryCall = new FunctionCall();
                fUnaryCall.appendChild(v1);
                Function f = (Function)unaryFuns.get(0);
                fUnaryCall.setFunction(f);
                this.trace("return unary (v2 not parsed) " + f);
                FunctionCall functionCall = fUnaryCall;
                return functionCall;
            }
            Value value = v1;
            return value;
        }
        finally {
            this.operatorScope.pop();
        }
    }

    protected boolean isBracket(String s) {
        for (Map.Entry<String, String> b : this.getBrackets().entrySet()) {
            String b1 = b.getKey();
            String b2 = b.getValue();
            if (s.equals(b1)) {
                return true;
            }
            if (!s.equals(b2)) continue;
            return true;
        }
        return false;
    }

    protected BracketValue bracket(Pointer<Token> ptr) {
        String bstart;
        String s;
        if (ptr == null) {
            throw new IllegalArgumentException("ptr==null");
        }
        Token t = (Token)ptr.lookup(0);
        String string = s = t != null ? t.getMatchedText() : null;
        if (s == null) {
            return null;
        }
        String bend = this.getBrackets().get(s);
        String string2 = bstart = bend == null ? null : s;
        if (bend == null || bstart == null) {
            return null;
        }
        ptr.push();
        ptr.move(1);
        Value v = this.statements(ptr);
        if (v != null) {
            String s2;
            Token t2 = (Token)ptr.lookup(0);
            String string3 = s2 = t2 != null ? t2.getMatchedText() : null;
            if (s2 != null && s2.equals(bend)) {
                ptr.move(1);
                ptr.pop();
                BracketValue bv = new BracketValue();
                bv.body = v;
                bv.openBracket = s;
                bv.closeBracket = s2;
                return bv;
            }
        }
        ptr.restore();
        return null;
    }

    protected Value postfixVal(Pointer<Token> ptr) {
        Value vo;
        Value v = this.val(ptr);
        Token t = (Token)ptr.lookup(0);
        if (t == null) {
            return v;
        }
        String ts = t.getMatchedText();
        FunctionSet tm = this.getMemory().getOperators(ts);
        if ((tm instanceof Function || tm instanceof FunctionSet) && (vo = this.operator(ptr, v)) != null) {
            return vo;
        }
        return v;
    }

    protected Value val(Pointer<Token> ptr) {
        BracketValue bracketv = this.bracket(ptr);
        if (bracketv != null && bracketv.body != null) {
            return bracketv.body;
        }
        Value assignv = this.writeMemValue(ptr);
        if (assignv != null) {
            return assignv;
        }
        Value callv = this.callValue(ptr);
        if (callv != null) {
            return callv;
        }
        Value readv = this.readMemValue(ptr);
        if (readv != null) {
            return readv;
        }
        Value numv = this.numberConst(ptr);
        if (numv != null) {
            return numv;
        }
        Value strv = this.stringConst(ptr);
        if (strv != null) {
            return strv;
        }
        return null;
    }

    protected Value writeMemValue(Pointer<Token> ptr) {
        String assignTokVal;
        String varn;
        Token t = (Token)ptr.lookup(0);
        String string = varn = t != null ? t.getMatchedText() : null;
        if (varn == null) {
            return null;
        }
        FieldAccessParser faParser = new FieldAccessParser();
        FieldAccess fa = faParser.parse(varn, 0);
        if (fa == null) {
            return null;
        }
        if (!fa.getMatchedText().equals(varn)) {
            return null;
        }
        int indexBegin = ptr.getIndex();
        t = (Token)ptr.lookup(1);
        String string2 = assignTokVal = t != null ? t.getMatchedText() : null;
        if (assignTokVal == null) {
            return null;
        }
        if (this.assignOpertator == null) {
            return null;
        }
        if (!this.assignOpertator.equals(assignTokVal)) {
            return null;
        }
        ptr.push();
        ptr.move(2);
        Value newv = this.operator(ptr, null);
        if (newv == null) {
            ptr.restore();
            return null;
        }
        ptr.pop();
        AssignVar assignv = new AssignVar();
        assignv.setData(newv);
        assignv.setField(fa);
        assignv.setMemory(this.getMemory());
        int indexEnd = ptr.getIndex();
        DefineVarPtr aval = new DefineVarPtr();
        aval.defVar = assignv;
        aval.fieldAccess = fa;
        aval.indexBegin = indexBegin;
        aval.indexEnd = indexEnd;
        this.defineVars.add(aval);
        return assignv;
    }

    protected Value readMemValue(Pointer<Token> ptr) {
        Object v;
        String varname;
        Token t = (Token)ptr.lookup(0);
        String string = varname = t != null ? t.getMatchedText() : null;
        if (varname == null) {
            return null;
        }
        FieldAccessParser faParser = new FieldAccessParser();
        FieldAccess fa = faParser.parse(varname, 0);
        if (fa == null) {
            return null;
        }
        for (int ai = this.defineVars.size() - 1; ai >= 0; --ai) {
            DefineVarPtr defvarptr = this.defineVars.get(ai);
            if (defvarptr.fieldAccess == null || !defvarptr.fieldAccess.toString().equals(fa.toString()) || defvarptr.defVar == null) continue;
            ReadVar rval = new ReadVar();
            rval.setData(defvarptr.defVar);
            ptr.move(1);
            return rval;
        }
        boolean matchtxt = fa.getMatchedText().equals(varname);
        if (!matchtxt) {
            return null;
        }
        final ArrayList resolved = new ArrayList();
        this.resolveFieldAccess(this.getMemory(), fa, new Func1<Object, Object>(){

            public Object apply(Object arg) {
                resolved.add(arg);
                return null;
            }
        });
        Object v1 = v = resolved.isEmpty() ? null : resolved.get(0);
        if (v == null) {
            return null;
        }
        ConstValue cv = new ConstValue(v);
        ptr.move(1);
        return cv;
    }

    protected boolean resolveFieldAccess(Memory mem, FieldAccess fa, Func1<Object, Object> readedValue) {
        if (fa == null) {
            return false;
        }
        if (mem == null) {
            return false;
        }
        if (readedValue == null) {
            return false;
        }
        String[] path = fa.getAccessPath();
        if (path == null || path.length == 0) {
            return false;
        }
        Object root = mem.get(path[0]);
        if (path.length == 1) {
            readedValue.apply(root);
            return true;
        }
        String[] newpath = new String[path.length - 1];
        for (int i = 1; i < path.length; ++i) {
            newpath[i - 1] = path[i];
        }
        return this.resolveFieldAccess(root, newpath, readedValue);
    }

    protected boolean resolveFieldAccess(Object root, String[] path, Func1<Object, Object> readedValue) {
        Map m;
        boolean readed;
        Object newroot;
        block17: {
            if (root == null) {
                return false;
            }
            if (path == null) {
                return false;
            }
            if (path.length == 0) {
                return false;
            }
            BeanInfo bi = null;
            try {
                bi = Introspector.getBeanInfo(root.getClass());
            }
            catch (IntrospectionException ex) {
                Logger.getLogger(Parser.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            newroot = null;
            readed = false;
            try {
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    if (!pd.getName().equals(path[0])) continue;
                    if (pd.getPropertyType() == null) {
                        return false;
                    }
                    Method m2 = pd.getReadMethod();
                    if (m2 == null) {
                        return false;
                    }
                    newroot = m2.invoke(root, new Object[0]);
                    readed = true;
                    break;
                }
                if (readed) break block17;
                for (Field f : root.getClass().getFields()) {
                    if (!f.getName().equals(path[0])) continue;
                    newroot = f.get(root);
                    readed = true;
                    break;
                }
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(AssignVar.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        if (!readed && root instanceof Map && (m = (Map)root).containsKey(path[0])) {
            newroot = m.get(path[0]);
            readed = true;
        }
        if (path.length == 1 && readed) {
            readedValue.apply(newroot);
            return true;
        }
        if (!readed) {
            return false;
        }
        String[] newpath = new String[path.length - 1];
        for (int i = 1; i < path.length; ++i) {
            newpath[i - 1] = path[i];
        }
        return this.resolveFieldAccess(newroot, newpath, readedValue);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Value callValue(Pointer<Token> ptr) {
        Token t = (Token)ptr.lookup(0);
        if (t == null) return null;
        String string = t.getMatchedText();
        String s = string;
        if (s == null) {
            return null;
        }
        if (s.startsWith("\"")) {
            return null;
        }
        if (s.startsWith("'")) {
            return null;
        }
        if (s.matches("(?is)\\d+[\\d\\.]*")) {
            return null;
        }
        if (this.isBracket(s)) {
            return null;
        }
        Memory mem = this.getMemory();
        FunctionSet fset = mem.getFunctions(s);
        if (fset == null) {
            if (!s.contains(".")) return null;
            FieldAccessParser faParser = new FieldAccessParser();
            FieldAccess fa = faParser.parse(s, 0);
            if (fa == null) return null;
            if (!fa.getMatchedText().equals(s)) return null;
            final ArrayList resolved = new ArrayList();
            Boolean readed = this.resolveFieldAccess(mem, fa, new Func1<Object, Object>(){

                public Object apply(Object arg) {
                    resolved.add(arg);
                    return null;
                }
            });
            if (readed.booleanValue() && resolved != null && resolved.size() > 0) {
                Object e = resolved.get(0);
                if (e instanceof FunctionSet) {
                    fset = (FunctionSet)e;
                } else if (e instanceof Function) {
                    FunctionSetImpl functionSetImpl = new FunctionSetImpl();
                    functionSetImpl.add((Function)e);
                    fset = functionSetImpl;
                }
            }
            if (fset == null) {
                return null;
            }
        }
        if (fset instanceof Function) {
            ptr.push();
            ptr.move(1);
            FunctionCall v = this.functionCall(ptr, (Function)((Object)fset));
            if (v != null) {
                ptr.pop();
                return v;
            }
            ptr.restore();
            return null;
        } else {
            if (!(fset instanceof FunctionSet)) return null;
            ptr.push();
            ptr.move(1);
            Comparator<FunctionCall> cfcall = new Comparator<FunctionCall>(){

                @Override
                public int compare(FunctionCall fc1, FunctionCall fc2) {
                    int countImpl_2;
                    int countImpl_1 = fc1.evalImplicitCastCount();
                    int cmpImpl = countImpl_1 < (countImpl_2 = fc2.evalImplicitCastCount()) ? -1 : (countImpl_1 == countImpl_2 ? 0 : 1);
                    int callArgCnt_1 = fc1.getChildren().length;
                    int callArgCnt_2 = fc2.getChildren().length;
                    int cmpArgCnt = callArgCnt_1 == callArgCnt_2 ? 0 : (callArgCnt_1 < callArgCnt_2 ? -1 : 1);
                    cmpArgCnt = -cmpArgCnt;
                    if (cmpImpl != 0) {
                        return cmpImpl;
                    }
                    return cmpArgCnt;
                }
            };
            ArrayList<FunctionCall> tfcall = new ArrayList<FunctionCall>();
            LinkedHashMap<FunctionCall, Integer> nextPtr = new LinkedHashMap<FunctionCall, Integer>();
            FunctionCall fcall = null;
            for (Function function : fset.getFunctions()) {
                ptr.push();
                fcall = this.functionCall(ptr, function);
                if (fcall != null) {
                    tfcall.add(fcall);
                    nextPtr.put(fcall, ptr.getIndex());
                    ptr.restore();
                    continue;
                }
                ptr.restore();
            }
            if (tfcall.size() > 1) {
                Collections.sort(tfcall, cfcall);
            }
            int n = -1;
            for (FunctionCall fcall2 : tfcall) {
                void var10_13;
                SourceDump sdump = new SourceDump();
                StringWriter sw = new StringWriter();
                sdump.output(sw);
                sdump.dump(fcall2);
                this.trace("call variant " + (int)(++var10_13) + ": \n" + Text.indent((String)sw.toString(), (String)"  "));
            }
            Object var11_18 = null;
            if (!tfcall.isEmpty()) {
                fcall = (FunctionCall)tfcall.get(0);
                Integer n2 = (Integer)nextPtr.get(fcall);
            }
            if (fcall != null) {
                void var11_20;
                ptr.pop();
                if (var11_20 == null) return fcall;
                ptr.setIndex((Integer)var11_20);
                return fcall;
            }
            ptr.restore();
        }
        return null;
    }

    protected Value numberConst(Pointer<Token> ptr) {
        String s;
        Token t = (Token)ptr.lookup(0);
        String string = s = t != null ? t.getMatchedText() : null;
        if (s == null) {
            return null;
        }
        if (this.isBracket(s)) {
            return null;
        }
        if (!s.matches("(?is)^-?\\d+(\\.\\d+)?$")) {
            return null;
        }
        NumberConstParser numConstPrs = new NumberConstParser(10, s.contains("."));
        NumberConst nconst = numConstPrs.parse(s, 0);
        if (nconst == null) {
            return null;
        }
        ptr.move(1);
        Number num = nconst.getNumber();
        if (num instanceof Long) {
            num = ((Long)num).intValue();
        }
        ConstValue cval = new ConstValue(num);
        return cval;
    }

    protected Value stringConst(Pointer<Token> ptr) {
        TextConstParser parser;
        TextConst tconst;
        String s;
        Token t = (Token)ptr.lookup(0);
        String string = s = t != null ? t.getMatchedText() : null;
        if (s == null) {
            return null;
        }
        if (this.isBracket(s)) {
            return null;
        }
        boolean decoded = false;
        if ((s.startsWith("\"") || s.startsWith("'")) && (tconst = (parser = new TextConstParser()).parse(s, 0)) != null) {
            s = tconst.getDecodedText();
            decoded = true;
        }
        ConstString cval = new ConstString(s, ptr.getIndex(), decoded);
        ptr.move(1);
        return cval;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    protected static class DefineVarPtr {
        public int indexBegin;
        public int indexEnd;
        public FieldAccess fieldAccess;
        public DefineVar defVar;

        protected DefineVarPtr() {
        }
    }

    protected static class BracketValue {
        public String openBracket;
        public String closeBracket;
        public Value body;

        protected BracketValue() {
        }
    }

    protected class OperatorScope {
        public Value v1;
        public boolean v1evaled;
        public Memory mem;
        public String op;
        public FunctionSetHelper unaryOp;
        public FunctionSetHelper binaryOp;
        public Value v2;

        protected OperatorScope() {
        }
    }

    public static class CatchedLambda {
        public List<String> args = new ArrayList<String>();
        public List<Token> body = new ArrayList<Token>();

        public Class getFunType() {
            if (this.args == null) {
                return null;
            }
            if (this.args.size() == 0) {
                return Func0.class;
            }
            if (this.args.size() == 1) {
                return Func1.class;
            }
            if (this.args.size() == 2) {
                return Func2.class;
            }
            if (this.args.size() == 3) {
                return Func3.class;
            }
            if (this.args.size() == 4) {
                return Func4.class;
            }
            if (this.args.size() == 5) {
                return Func5.class;
            }
            if (this.args.size() == 6) {
                return Func6.class;
            }
            if (this.args.size() == 7) {
                return Func7.class;
            }
            if (this.args.size() == 8) {
                return Func8.class;
            }
            if (this.args.size() == 9) {
                return Func9.class;
            }
            return null;
        }
    }
}

