/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.AssignVar;
import xyz.cofe.cli.Block;
import xyz.cofe.cli.ConstString;
import xyz.cofe.cli.ConstValue;
import xyz.cofe.cli.Declaration;
import xyz.cofe.cli.DefineVar;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.FunctionCall;
import xyz.cofe.cli.LambdaCall;
import xyz.cofe.cli.Memory;
import xyz.cofe.cli.ReadVar;
import xyz.cofe.cli.Sequence;
import xyz.cofe.cli.TypeCastValue;
import xyz.cofe.cli.Value;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.EndLineReWriter;
import xyz.cofe.text.Output;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.lex.FieldAccess;

public class SourceDump {
    private static final Logger logger = Logger.getLogger(SourceDump.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private final Output out;
    private final EndLineReWriter endlReWriter;
    private final Output outDest = new Output((Writer)new OutputStreamWriter(System.out));
    private int level = 0;
    private Memory memory;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public SourceDump() {
        this.endlReWriter = new EndLineReWriter((Writer)this.outDest){
            protected boolean indentWrited;
            {
                this.indentWrited = false;
            }

            protected void writeIndent(boolean checkWrited) throws IOException {
                if (checkWrited) {
                    if (this.indentWrited) {
                        return;
                    }
                    this.writer.append(SourceDump.this.getIndent());
                    this.indentWrited = true;
                } else {
                    this.writer.append(SourceDump.this.getIndent());
                    this.indentWrited = true;
                }
            }

            protected void writeEndLine() throws IOException {
                if (this.writer != null) {
                    this.writer.append(EndLine.Default.get());
                    this.indentWrited = false;
                }
            }

            protected void writeChar(char c0) throws IOException {
                this.writeIndent(true);
                super.writeChar(c0);
            }

            public Writer append(char c) throws IOException {
                this.writeIndent(true);
                return super.append(c);
            }

            public Writer append(CharSequence csq, int start, int end) throws IOException {
                this.writeIndent(true);
                return super.append(csq, start, end);
            }

            public Writer append(CharSequence csq) throws IOException {
                this.writeIndent(true);
                return super.append(csq);
            }

            public void write(String str, int off, int len) throws IOException {
                this.writeIndent(true);
                super.write(str, off, len);
            }

            public void write(String str) throws IOException {
                this.writeIndent(true);
                super.write(str);
            }

            public void write(char[] cbuf) throws IOException {
                this.writeIndent(true);
                super.write(cbuf);
            }

            public void write(int c) throws IOException {
                this.writeIndent(true);
                super.write(c);
            }
        };
        this.out = new Output((Writer)this.endlReWriter);
    }

    protected synchronized String getIndent() {
        if (this.level <= 0) {
            return "";
        }
        return Text.repeat((String)"|---", (int)this.level);
    }

    public synchronized void output(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        this.outDest.reset(writer);
    }

    public synchronized void dump(Value val) {
        if (val instanceof AssignVar) {
            this.dump((AssignVar)val);
        } else if (val instanceof LambdaCall) {
            this.dump((LambdaCall)val);
        } else if (val instanceof Block) {
            this.dump((Block)val);
        } else if (val instanceof ReadVar) {
            this.dump((ReadVar)val);
        } else if (val instanceof ConstString) {
            this.dump((ConstString)val);
        } else if (val instanceof ConstValue) {
            this.dump((ConstValue)val);
        } else if (val instanceof Sequence) {
            this.dump((Sequence)val);
        } else if (val instanceof TypeCastValue) {
            this.dump((TypeCastValue)val);
        } else if (val instanceof FunctionCall) {
            this.dump((FunctionCall)val);
        } else if (val != null) {
            Value[] childrn = (Value[])val.getChildren();
            this.out.println(val.toString());
            for (Value vc : childrn) {
                ++this.level;
                this.dump(vc);
                --this.level;
            }
        } else {
            this.out.println("null");
        }
        this.out.flush();
    }

    public Memory getMemory() {
        if (this.memory != null) {
            return this.memory;
        }
        this.memory = new Memory();
        return this.memory;
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    protected synchronized void dump(LambdaCall lc) {
        if (lc == null) {
            throw new IllegalArgumentException("lc==null");
        }
        this.out.println("lambda call:");
        if (lc.lambda != null) {
            if (lc.lambda.args != null) {
                int argi = -1;
                this.out.println("arguments:");
                for (String arg : lc.lambda.args) {
                    this.out.print("  ");
                    this.out.print(++argi);
                    this.out.print(". ");
                    this.out.println(arg);
                }
            }
            this.out.println("body:");
            if (lc.lambda.body != null) {
                ArrayList<String> toks = new ArrayList<String>();
                for (Token t : lc.lambda.body) {
                    if (t == null) continue;
                    toks.add(t.getMatchedText());
                }
                this.out.println("  " + Text.join(toks, (String)" "));
            }
        }
    }

    protected synchronized void dump(ReadVar rval) {
        if (rval == null) {
            throw new IllegalArgumentException("rval==null");
        }
        DefineVar defvar = rval.getData();
        if (defvar == null) {
            this.out.println("read variable ...");
            return;
        }
        String varn = defvar.getVarName();
        Class vart = defvar.getVarType();
        this.out.println("read variable " + varn + (vart == null ? "" : " : " + vart.getName()));
    }

    protected synchronized void dump(Block bval) {
        Value[] childrn;
        if (bval == null) {
            throw new IllegalArgumentException("bval==null");
        }
        this.out.println("block");
        for (Value vc : childrn = bval.getChildren()) {
            ++this.level;
            this.dump(vc);
            --this.level;
        }
    }

    protected synchronized void dump(AssignVar avar) {
        Value[] childrn;
        if (avar == null) {
            throw new IllegalArgumentException("avar==null");
        }
        FieldAccess fa = avar == null ? null : avar.getField();
        String varn = fa == null ? null : fa.toString();
        this.out.println("assign " + varn);
        for (Value vc : childrn = avar.getChildren()) {
            ++this.level;
            this.dump(vc);
            --this.level;
        }
    }

    protected synchronized void dump(Sequence sval) {
        Value[] childrn;
        if (sval == null) {
            throw new IllegalArgumentException("sval==null");
        }
        this.out.println("sequence");
        for (Value vc : childrn = sval.getChildren()) {
            ++this.level;
            this.dump(vc);
            --this.level;
        }
    }

    protected synchronized void dump(ConstString constval) {
        if (constval == null) {
            throw new IllegalArgumentException("cval==null");
        }
        String cval = constval.getConst();
        if (cval == null) {
            this.out.println("null");
            return;
        }
        if (cval instanceof String) {
            this.out.println(Text.encodeStringConstant((String)cval) + " : String");
            return;
        }
        this.out.println((Object)cval);
    }

    protected synchronized void dump(ConstValue constval) {
        if (constval == null) {
            throw new IllegalArgumentException("cval==null");
        }
        Object cval = constval.getConst();
        if (cval == null) {
            this.out.println("null");
            return;
        }
        if (cval instanceof String) {
            this.out.println(Text.encodeStringConstant((String)((String)cval)) + " : String");
            return;
        }
        if (cval instanceof Boolean) {
            if (((Boolean)cval).booleanValue()) {
                this.out.println("true : Boolean");
            } else {
                this.out.println("false : Boolean");
            }
            return;
        }
        this.out.println(cval);
    }

    protected synchronized void dump(TypeCastValue tc) {
        Class ttype;
        if (tc == null) {
            throw new IllegalArgumentException("tc==null");
        }
        Value val = tc.getValue();
        if (val == null) {
            this.out.println("!cast(null)");
            return;
        }
        Class ftype = tc.getFromType();
        if (ftype == null && val instanceof ConstValue) {
            ftype = ((ConstValue)val).getType();
        }
        if ((ttype = tc.getType()) == null) {
            this.out.println("!cast(target=null)");
            return;
        }
        if (ttype == Void.class) {
            this.out.println("cast as void");
            ++this.level;
            this.dump(val);
            --this.level;
            return;
        }
        String ttname = new Declaration().getTypeName(ttype);
        this.out.println("cast as " + ttname + (tc.isImplicit() ? " implicit" : ""));
        ++this.level;
        this.dump(val);
        --this.level;
    }

    protected synchronized void dump(FunctionCall fcall) {
        if (fcall == null) {
            throw new IllegalArgumentException("fcall==null");
        }
        Function fun = fcall.getFunction();
        String funNameR = this.getMemory().getNameOf(fun);
        String funName = funNameR != null ? funNameR : "undefined";
        StringBuilder fundecl = new StringBuilder();
        if (fun != null) {
            fundecl.append("(");
            Class[] paramTypes = fun.getParameters();
            if (paramTypes.length > 0) {
                fundecl.append(" ");
                for (int pi = 0; pi < paramTypes.length; ++pi) {
                    if (pi > 0) {
                        fundecl.append(", ");
                    }
                    String argName = "arg" + pi;
                    String argTypeName = new Declaration().getTypeName(paramTypes[pi]);
                    fundecl.append(argName).append(":").append(argTypeName);
                }
                fundecl.append(" ");
            }
            fundecl.append(")");
            Class retType = fun.getReturn();
            fundecl.append(":").append(new Declaration().getTypeName(retType));
        }
        this.out.println("call function " + funName + fundecl.toString());
        ++this.level;
        int c = fcall.evalImplicitCastCount();
        if (c > 0) {
            this.out.println("implicit cast count = " + c);
        }
        --this.level;
        int pi = -1;
        for (Value cval : fcall.getChildren()) {
            ++this.level;
            this.out.print("arg ");
            this.out.print(++pi);
            this.out.print(": ");
            this.dump(cval);
            --this.level;
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

