/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.ConstValue;
import xyz.cofe.cli.Function;
import xyz.cofe.cli.FunctionCall;
import xyz.cofe.cli.Parser;
import xyz.cofe.cli.Value;
import xyz.cofe.collection.Pointer;
import xyz.cofe.text.Output;
import xyz.cofe.text.Text;
import xyz.cofe.text.parser.Token;

public class TraceParser
extends Parser {
    private static final Logger logger = Logger.getLogger(TraceParser.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Options options;
    protected Stack<String> callStack = new Stack();

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public TraceParser() {
    }

    public TraceParser(TraceParser source) {
        super(source);
        if (source != null) {
            this.options = source.getTraceOptions().clone();
        }
    }

    @Override
    public TraceParser clone() {
        return new TraceParser(this);
    }

    public Options getTraceOptions() {
        try {
            this.lock.lock();
            if (this.options == null) {
                this.options = new Options();
            }
            Options options = this.options;
            return options;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void traceCallStack(Output out) {
        if (out == null) {
            return;
        }
        if (this.callStack == null) {
            return;
        }
        if (this.callStack.isEmpty()) {
            return;
        }
        if (this.callStack.size() == 1) {
            out.print((String)this.callStack.get(0));
            return;
        }
        out.print(Text.repeat((String)"|---", (int)(this.callStack.size() - 1)));
        out.print((String)this.callStack.get(this.callStack.size() - 1));
    }

    protected void tracePointer(Output out, Pointer<Token> ptr) {
        Token t;
        if (out == null) {
            return;
        }
        if (ptr == null) {
            return;
        }
        Options opts = this.getTraceOptions();
        if (opts == null) {
            return;
        }
        int count = opts.getPtrLookupCount();
        if (count < 1) {
            return;
        }
        for (int c = 0; c < count && (t = (Token)ptr.lookup(c)) != null; ++c) {
            out.print("[");
            out.print(ptr.getIndex() + c);
            out.print(":");
            if (t != null) {
                String s = t.getMatchedText();
                if (s.length() > 30) {
                    out.print(Text.encodeStringConstant((String)s.substring(0, 30)) + "...");
                } else {
                    out.print(Text.encodeStringConstant((String)s));
                }
            }
            out.print("]");
        }
    }

    protected void traceMethodEnter(String method) {
        Options opts;
        Output out;
        if (method != null) {
            this.callStack.push(method);
        }
        Output output = out = (opts = this.getTraceOptions()) != null ? opts.getOutput() : null;
        if (out == null) {
            return;
        }
        if (method != null && opts.getMethods().contains(method)) {
            this.traceCallStack(out);
            out.println();
        }
        out.flush();
    }

    protected void traceMethodEnter(String method, Pointer<Token> ptr) {
        Options opts;
        Output out;
        if (method != null) {
            this.callStack.push(method);
        }
        Output output = out = (opts = this.getTraceOptions()) != null ? opts.getOutput() : null;
        if (out == null) {
            return;
        }
        if (method != null && opts.getMethods().contains(method)) {
            this.traceCallStack(out);
            out.print(": ");
            this.tracePointer(out, ptr);
            out.println();
        }
        out.flush();
    }

    protected void traceMethodEnter(String method, Pointer<Token> ptr, Function fun) {
        Options opts;
        Output out;
        if (method != null) {
            this.callStack.push(method);
        }
        Output output = out = (opts = this.getTraceOptions()) != null ? opts.getOutput() : null;
        if (out == null) {
            return;
        }
        if (method != null && opts.getMethods().contains(method)) {
            this.traceCallStack(out);
            out.print(": ");
            this.tracePointer(out, ptr);
            out.print(" fun=");
            out.print((Object)fun);
            out.println();
        }
        out.flush();
    }

    protected void traceMethodEnter(String method, Pointer<Token> ptr, Value v) {
        Options opts;
        Output out;
        if (method != null) {
            this.callStack.push(method);
        }
        Output output = out = (opts = this.getTraceOptions()) != null ? opts.getOutput() : null;
        if (out == null) {
            return;
        }
        if (method != null && opts.getMethods().contains(method)) {
            this.traceCallStack(out);
            out.print(">> ");
            this.tracePointer(out, ptr);
            out.println();
        }
        out.flush();
    }

    protected void traceMethodExit(Object result) {
        Options opts;
        Output out;
        String method = null;
        if (!this.callStack.isEmpty()) {
            method = this.callStack.pop();
        }
        Output output = out = (opts = this.getTraceOptions()) != null ? opts.getOutput() : null;
        if (out == null) {
            return;
        }
        if (method != null && opts.getMethods().contains(method)) {
            this.traceCallStack(out);
            if (result != null) {
                out.print("= ");
                if (result instanceof Value) {
                    Value v = (Value)result;
                    Class<?> type = v.getClass();
                    String typeName = type.getName();
                    if (typeName.startsWith("xyz.cofe.cli.")) {
                        typeName = typeName.substring("xyz.cofe.cli.".length());
                    }
                    Class valResType = v.getType();
                    out.print(typeName + ":" + valResType.getSimpleName());
                    if (v instanceof ConstValue) {
                        Object constval = ((ConstValue)v).getConst();
                        if (constval == null) {
                            out.print(" (null)");
                        } else if (constval instanceof String) {
                            String strConstVal = (String)constval;
                            if (strConstVal.length() > 30) {
                                out.print(" (" + Text.encodeStringConstant((String)strConstVal.substring(0, 30)) + "...)");
                            } else {
                                out.print(" (" + Text.encodeStringConstant((String)strConstVal) + ")");
                            }
                        } else {
                            String str = constval.toString();
                            str.replaceAll("\\r\\n|\\n\\r|\\r|\\n|\\t", " ");
                            if (str.length() > 30) {
                                str = str.substring(0, 30) + "...";
                            }
                            out.print(" (" + str + ")");
                        }
                    }
                } else {
                    out.print(result.toString());
                }
            } else {
                out.print("= null");
            }
            out.println();
        }
        out.flush();
    }

    @Override
    protected void trace(String message) {
        if (message != null) {
            Output out;
            Options opts = this.getTraceOptions();
            Output output = out = opts != null ? opts.getOutput() : null;
            if (out == null) {
                return;
            }
            StringWriter sw = new StringWriter();
            Output o = new Output((Writer)sw);
            this.traceCallStack(o);
            o.flush();
            String l = Text.indent((String)message, (String)(sw.toString() + " "));
            out.println(l);
        }
        super.trace(message);
    }

    @Override
    public Value parse(Pointer<Token> ptr) {
        Output out;
        this.traceMethodEnter("parse", ptr);
        this.trace("tokens count=" + ptr.getList().size());
        int ti = -1;
        for (Token t : ptr.getList()) {
            this.trace("" + (++ti + 1) + ": " + Text.encodeStringConstant((String)t.getMatchedText()));
        }
        Value val = super.parse(ptr);
        this.traceMethodExit(val);
        Options opts = this.getTraceOptions();
        Output output = out = opts != null ? opts.getOutput() : null;
        if (out != null) {
            out.flush();
        }
        return val;
    }

    @Override
    protected Parser.BracketValue bracket(Pointer<Token> ptr) {
        this.traceMethodEnter("bracket", ptr);
        Parser.BracketValue val = super.bracket(ptr);
        this.traceMethodExit(val);
        return val;
    }

    @Override
    protected Value callValue(Pointer<Token> ptr) {
        this.traceMethodEnter("call", ptr);
        Value val = super.callValue(ptr);
        this.traceMethodExit(val);
        return val;
    }

    @Override
    protected FunctionCall functionCall(Pointer<Token> ptr, Function fun) {
        this.traceMethodEnter("functionCall", ptr, fun);
        FunctionCall res = super.functionCall(ptr, fun);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value stringConst(Pointer<Token> ptr) {
        this.traceMethodEnter("stringConst", ptr);
        Value res = super.stringConst(ptr);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value numberConst(Pointer<Token> ptr) {
        this.traceMethodEnter("numberConst", ptr);
        Value res = super.numberConst(ptr);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value readMemValue(Pointer<Token> ptr) {
        this.traceMethodEnter("readMemValue", ptr);
        Value res = super.readMemValue(ptr);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value writeMemValue(Pointer<Token> ptr) {
        this.traceMethodEnter("writeMemValue", ptr);
        Value res = super.writeMemValue(ptr);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value val(Pointer<Token> ptr) {
        this.traceMethodEnter("val", ptr);
        Value res = super.val(ptr);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value postfixVal(Pointer<Token> ptr) {
        this.traceMethodEnter("postfixVal", ptr);
        Value res = super.postfixVal(ptr);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value operator(Pointer<Token> ptr, Value v1) {
        this.traceMethodEnter("operator", ptr, v1);
        Value res = super.operator(ptr, v1);
        this.traceMethodExit(res);
        return res;
    }

    @Override
    protected Value statements(Pointer<Token> ptr) {
        this.traceMethodEnter("statements", ptr);
        Value res = super.statements(ptr);
        this.traceMethodExit(res);
        return res;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public class Options {
        protected Output output = null;
        private boolean closeOutput = false;
        protected int ptrLookupCount = 3;
        protected Set<String> methods;

        public Options() {
        }

        public Options(Options source) {
            if (source == null) {
                throw new IllegalArgumentException("source==null");
            }
            this.output = source.output;
            this.closeOutput = source.closeOutput;
            this.ptrLookupCount = source.ptrLookupCount;
            if (source.methods != null) {
                this.methods = new LinkedHashSet<String>();
                this.methods.addAll(source.methods);
            }
        }

        public Options clone() {
            return new Options(this);
        }

        public Output getOutput() {
            try {
                TraceParser.this.lock.lock();
                Output output = this.output;
                return output;
            }
            finally {
                TraceParser.this.lock.unlock();
            }
        }

        public void setOutput(Output output) {
            try {
                TraceParser.this.lock.lock();
                this.output = output;
            }
            finally {
                TraceParser.this.lock.unlock();
            }
        }

        public boolean isCloseOutput() {
            return this.closeOutput;
        }

        public void setCloseOutput(boolean closeOutput) {
            this.closeOutput = closeOutput;
        }

        public int getPtrLookupCount() {
            try {
                TraceParser.this.lock.lock();
                int n = this.ptrLookupCount;
                return n;
            }
            finally {
                TraceParser.this.lock.unlock();
            }
        }

        public void setPtrLookupCount(int ptrLookupCount) {
            try {
                TraceParser.this.lock.lock();
                this.ptrLookupCount = ptrLookupCount;
            }
            finally {
                TraceParser.this.lock.unlock();
            }
        }

        public Set<String> getMethods() {
            if (this.methods == null) {
                this.methods = new LinkedHashSet<String>();
                this.methods.add("parse");
                this.methods.add("bracket");
                this.methods.add("callValue");
                this.methods.add("functionCall");
                this.methods.add("stringConst");
                this.methods.add("numberConst");
                this.methods.add("readMemValue");
                this.methods.add("writeMemValue");
                this.methods.add("val");
                this.methods.add("postfixVal");
                this.methods.add("operator");
                this.methods.add("statements");
            }
            return this.methods;
        }
    }
}

