/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BasicValue;
import xyz.cofe.cli.ConstValue;
import xyz.cofe.cli.GetType;
import xyz.cofe.cli.Value;
import xyz.cofe.collection.graph.Path;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;

public class TypeCastValue
extends BasicValue
implements GetType {
    private static final Logger logger = Logger.getLogger(TypeCastValue.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private Class fromType;
    private Class type;
    private TypeCastGraph typeCastGraph;
    private boolean implicit = false;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Class getFromType() {
        return this.fromType;
    }

    public void setFromType(Class fromType) {
        this.fromType = fromType;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Value getValue() {
        Value[] children = this.getChildren();
        Value value = children != null && children.length > 0 ? children[0] : null;
        return value;
    }

    public TypeCastGraph getTypeCastGraph() {
        if (this.typeCastGraph != null) {
            return this.typeCastGraph;
        }
        this.typeCastGraph = new ExtendedCastGraph();
        return this.typeCastGraph;
    }

    public void setTypeCastGraph(TypeCastGraph typeCastGraph) {
        this.typeCastGraph = typeCastGraph;
    }

    public boolean canCast() {
        TypeCastGraph tcg = this.getTypeCastGraph();
        if (tcg == null) {
            return false;
        }
        if (this.fromType == null) {
            return false;
        }
        if (this.type == null) {
            return false;
        }
        Path p = tcg.findPath(this.fromType, this.type);
        return p != null;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    @Override
    public Object eval() {
        Class ttype;
        Value value;
        Class ftype = this.fromType;
        Value[] children = this.getChildren();
        Value value2 = value = children != null && children.length > 0 ? children[0] : null;
        if (ftype == null && value instanceof ConstValue) {
            ftype = ((ConstValue)value).getType();
        }
        if ((ttype = this.type) == Void.class) {
            return null;
        }
        if (ttype == null) {
            throw new IllegalStateException("target type not setted");
        }
        if (ftype == null) {
            throw new IllegalStateException("source type not setted");
        }
        Value val = value;
        if (val == null) {
            throw new IllegalStateException("source value not setted");
        }
        if (ttype.equals(ftype)) {
            return val.eval();
        }
        Object srcv = val.eval();
        if (srcv == null) {
            throw new IllegalStateException("source evaled value is null");
        }
        TypeCastGraph tc = this.getTypeCastGraph();
        Object retval = tc.cast(srcv, ttype);
        if (retval == null) {
            throw new IllegalStateException("can't cast " + (srcv == null ? "null" : srcv.getClass().getName()) + " to " + ttype + " (null)");
        }
        return retval;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

