/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli.fun;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Help;
import xyz.cofe.cli.Name;
import xyz.cofe.fs.ByteSize;
import xyz.cofe.fs.File;
import xyz.cofe.fs.FileSystems;

public class FileFn
extends BaseCLIFun {
    private static final Logger logger = Logger.getLogger(FileFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Fun
    @Help(shortDesc="create file object")
    public File file(@Help(shortDesc="path to file/dir") @Name(name="path") String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        return FileSystems.get((String)path);
    }

    @Fun(operator=true)
    @Help(shortDesc="return file name")
    public String name(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.getName();
    }

    @Fun(operator=true)
    @Help(shortDesc="return file path")
    public String path(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.getPath();
    }

    @Fun(operator=true)
    @Help(shortDesc="return file modify time")
    public Date modifyDate(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.getModifyDate();
    }

    @Fun(operator=true)
    @Help(shortDesc="return true is file is directory")
    public Boolean isDirectory(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.isDirectory();
    }

    @Fun(operator=true)
    @Help(shortDesc="return true is file is regular file")
    public Boolean isFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.isFile();
    }

    @Fun(operator=true)
    @Help(shortDesc="return true is file has parent directory")
    public Boolean hasParent(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.getParent() != null;
    }

    @Fun(operator=true)
    @Help(shortDesc="return parent directory of file")
    public File parent(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.getParent();
    }

    @Fun(operator=true)
    @Help(shortDesc="return file length")
    public long length(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return file.getLength();
    }

    @Fun(operator=true)
    @Help(shortDesc="return file length as string")
    public String lengthString(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        return new ByteSize(file.getLength()).toStringRoundMin(2);
    }

    @Fun(operator=true)
    @Help(shortDesc="output file content")
    public void print(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        try {
            int readed;
            BufferedInputStream fin = file.openRead();
            InputStreamReader rd = new InputStreamReader((InputStream)fin, Charset.defaultCharset());
            char[] cbuf = new char[8192];
            while ((readed = rd.read(cbuf)) > 0) {
                this.getOutput().print(new String(cbuf, 0, readed));
            }
            ((InputStream)fin).close();
        }
        catch (Throwable err) {
            err.toString();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

