/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli.fun;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Name;

public class NumberFn
extends BaseCLIFun {
    private static final Logger logger = Logger.getLogger(NumberFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Fun(operator=true)
    @Name(name="==")
    public Boolean cmpEquals(Number num1, Number num2) {
        if (num1 == null) {
            throw new IllegalArgumentException("num1==null");
        }
        if (num2 == null) {
            throw new IllegalArgumentException("num2==null");
        }
        if (num1 instanceof Long) {
            return num1.longValue() == num2.longValue();
        }
        if (num1 instanceof Integer) {
            if (num2 instanceof Long) {
                return num1.longValue() == num2.longValue();
            }
            return num1.intValue() == num2.intValue();
        }
        if (num1 instanceof Short) {
            if (num2 instanceof Long) {
                return num1.longValue() == num2.longValue();
            }
            if (num2 instanceof Integer) {
                return num1.intValue() == num2.intValue();
            }
            return num1.shortValue() == num2.shortValue();
        }
        if (num1 instanceof Byte) {
            if (num2 instanceof Long) {
                return num1.longValue() == num2.longValue();
            }
            if (num2 instanceof Integer) {
                return num1.intValue() == num2.intValue();
            }
            if (num2 instanceof Short) {
                return num1.shortValue() == num2.shortValue();
            }
            return num1.byteValue() == num2.byteValue();
        }
        if (num1 instanceof Double) {
            return num1.doubleValue() == num2.doubleValue();
        }
        if (num1 instanceof Float) {
            if (num2 instanceof Double) {
                return num1.doubleValue() == num2.doubleValue();
            }
            return num1.floatValue() == num2.floatValue();
        }
        return num1.equals(num2);
    }

    @Fun(operator=true)
    @Name(name="equ")
    public Boolean cmpEqualsNamed(Number num1, Number num2) {
        return this.cmpEquals(num1, num2);
    }

    @Fun(operator=true)
    @Name(name="!=")
    public Boolean cmpNotEquals(Number num1, Number num2) {
        boolean r = this.cmpEquals(num1, num2);
        return !r;
    }

    @Fun(operator=true)
    @Name(name="nequ")
    public Boolean cmpNotEqualsNamed(Number num1, Number num2) {
        boolean r = this.cmpEquals(num1, num2);
        return !r;
    }

    @Fun(operator=true)
    @Name(name="more")
    public Boolean cmpMoreNamed(Number num1, Number num2) {
        return this.cmpMore(num1, num2);
    }

    @Fun(operator=true)
    @Name(name=">")
    public Boolean cmpMore(Number num1, Number num2) {
        if (num1 == null) {
            throw new IllegalArgumentException("num1==null");
        }
        if (num2 == null) {
            throw new IllegalArgumentException("num2==null");
        }
        if (num1 instanceof Long) {
            return num1.longValue() > num2.longValue();
        }
        if (num1 instanceof Integer) {
            if (num2 instanceof Long) {
                return num1.longValue() > num2.longValue();
            }
            return num1.intValue() > num2.intValue();
        }
        if (num1 instanceof Short) {
            if (num2 instanceof Long) {
                return num1.longValue() > num2.longValue();
            }
            if (num2 instanceof Integer) {
                return num1.intValue() > num2.intValue();
            }
            return num1.shortValue() > num2.shortValue();
        }
        if (num1 instanceof Byte) {
            if (num2 instanceof Long) {
                return num1.longValue() > num2.longValue();
            }
            if (num2 instanceof Integer) {
                return num1.intValue() > num2.intValue();
            }
            if (num2 instanceof Short) {
                return num1.shortValue() > num2.shortValue();
            }
            return num1.byteValue() > num2.byteValue();
        }
        if (num1 instanceof Double) {
            return num1.doubleValue() > num2.doubleValue();
        }
        if (num1 instanceof Float) {
            if (num2 instanceof Double) {
                return num1.doubleValue() > num2.doubleValue();
            }
            return num1.floatValue() > num2.floatValue();
        }
        if (num1 instanceof Comparable) {
            int r = ((Comparable)((Object)num1)).compareTo(num2);
            if (r > 0) {
                return true;
            }
            return false;
        }
        throw new Error("can't compare " + num1 + " and " + num2);
    }

    @Fun(operator=true)
    @Name(name="less")
    public Boolean cmpLessNamed(Number num1, Number num2) {
        return this.cmpLess(num1, num2);
    }

    @Fun(operator=true)
    @Name(name="<")
    public Boolean cmpLess(Number num1, Number num2) {
        if (num1 == null) {
            throw new IllegalArgumentException("num1==null");
        }
        if (num2 == null) {
            throw new IllegalArgumentException("num2==null");
        }
        if (num1 instanceof Long) {
            return num1.longValue() < num2.longValue();
        }
        if (num1 instanceof Integer) {
            if (num2 instanceof Long) {
                return num1.longValue() < num2.longValue();
            }
            return num1.intValue() < num2.intValue();
        }
        if (num1 instanceof Short) {
            if (num2 instanceof Long) {
                return num1.longValue() < num2.longValue();
            }
            if (num2 instanceof Integer) {
                return num1.intValue() < num2.intValue();
            }
            return num1.shortValue() < num2.shortValue();
        }
        if (num1 instanceof Byte) {
            if (num2 instanceof Long) {
                return num1.longValue() < num2.longValue();
            }
            if (num2 instanceof Integer) {
                return num1.intValue() < num2.intValue();
            }
            if (num2 instanceof Short) {
                return num1.shortValue() < num2.shortValue();
            }
            return num1.byteValue() > num2.byteValue();
        }
        if (num1 instanceof Double) {
            return num1.doubleValue() < num2.doubleValue();
        }
        if (num1 instanceof Float) {
            if (num2 instanceof Double) {
                return num1.doubleValue() < num2.doubleValue();
            }
            return num1.floatValue() < num2.floatValue();
        }
        if (num1 instanceof Comparable) {
            int r = ((Comparable)((Object)num1)).compareTo(num2);
            if (r < 0) {
                return true;
            }
            return false;
        }
        throw new Error("can't compare " + num1 + " and " + num2);
    }

    @Fun(operator=true)
    @Name(name="moreEqu")
    public Boolean cmpMoreOrEqualsNamed(Number num1, Number num2) {
        return this.cmpMoreOrEquals(num1, num2);
    }

    @Fun(operator=true)
    @Name(name="<=")
    public Boolean cmpMoreOrEquals(Number num1, Number num2) {
        boolean r = this.cmpLess(num1, num2);
        return !r;
    }

    @Fun(operator=true)
    @Name(name="lessEqu")
    public Boolean cmpLessOrEqualsNamed(Number num1, Number num2) {
        return this.cmpLessOrEquals(num1, num2);
    }

    @Fun(operator=true)
    @Name(name=">=")
    public Boolean cmpLessOrEquals(Number num1, Number num2) {
        boolean r = this.cmpMore(num1, num2);
        return !r;
    }

    @Fun(operator=true)
    @Name(name="+")
    public Integer add(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a + b;
    }

    @Fun(operator=true)
    @Name(name="add")
    public Integer addNamed(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a + b;
    }

    @Fun(operator=true)
    @Name(name="+")
    public Long add(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a + b;
    }

    @Fun(operator=true)
    @Name(name="add")
    public Long addNamed(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a + b;
    }

    @Fun(operator=true)
    @Name(name="-")
    public Integer sub(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a - b;
    }

    @Fun(operator=true)
    @Name(name="sub")
    public Integer subNamed(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a - b;
    }

    @Fun(operator=true)
    @Name(name="-")
    public Long sub(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a - b;
    }

    @Fun(operator=true)
    @Name(name="sub")
    public Long subNamed(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a - b;
    }

    @Fun(operator=true)
    @Name(name="*")
    public Integer mul(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a * b;
    }

    @Fun(operator=true)
    @Name(name="mul")
    public Integer mulNamed(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a * b;
    }

    @Fun(operator=true)
    @Name(name="*")
    public Long mul(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a * b;
    }

    @Fun(operator=true)
    @Name(name="mul")
    public Long mulNamed(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a * b;
    }

    @Fun(operator=true)
    @Name(name="/")
    public Integer div(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a / b;
    }

    @Fun(operator=true)
    @Name(name="div")
    public Integer divNamed(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a / b;
    }

    @Fun(operator=true)
    @Name(name="/")
    public Long div(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a / b;
    }

    @Fun(operator=true)
    @Name(name="div")
    public Long divNamed(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a / b;
    }

    @Fun(operator=true)
    @Name(name="/")
    public Integer mod(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a % b;
    }

    @Fun(operator=true)
    @Name(name="mod")
    public Integer modNamed(Integer a, Integer b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a % b;
    }

    @Fun(operator=true)
    @Name(name="/")
    public Long mod(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a % b;
    }

    @Fun(operator=true)
    @Name(name="mod")
    public Long modNamed(Long a, Long b) {
        if (a == null) {
            throw new IllegalArgumentException("a==null");
        }
        if (b == null) {
            throw new IllegalArgumentException("b==null");
        }
        return a % b;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

