/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli.fun;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Help;
import xyz.cofe.cli.Name;
import xyz.cofe.io.IOFun;

public class PrintFn
extends BaseCLIFun {
    private static final Logger logger = Logger.getLogger(PrintFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Fun(operator=true)
    @Name(name="print")
    @Help(shortDesc="print stream data to std. i/o")
    public void print(@Name(name="stream") InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream==null");
        }
        try {
            IOFun.copy((InputStream)stream, (OutputStream)System.out);
        }
        catch (IOException ex) {
            Logger.getLogger(PrintFn.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Fun
    @Name(name="print")
    @Help(shortDesc="print message to std. i/o")
    public void print(@Name(name="message") String message) {
        if (message != null) {
            this.getOutput().print(message);
            this.getOutput().flush();
        } else {
            this.getOutput().print("null");
            this.getOutput().flush();
        }
    }

    @Fun
    @Name(name="println")
    @Help(shortDesc="print message with new line to std. i/o")
    public void println(@Name(name="message") String message) {
        if (message != null) {
            this.getOutput().println(message);
            this.getOutput().flush();
        } else {
            this.getOutput().println("null");
            this.getOutput().flush();
        }
    }

    @Fun
    @Name(name="println")
    @Help(shortDesc="print value with new line to std. i/o")
    public void println(@Name(name="value") Number value) {
        if (value != null) {
            this.getOutput().println((Object)value);
            this.getOutput().flush();
        } else {
            this.getOutput().println("null");
            this.getOutput().flush();
        }
    }

    @Fun
    @Name(name="print")
    @Help(shortDesc="print value to std. i/o")
    public void print(@Name(name="value") Number value) {
        if (value != null) {
            this.getOutput().print((Object)value);
            this.getOutput().flush();
        } else {
            this.getOutput().print("null");
            this.getOutput().flush();
        }
    }

    @Fun
    @Name(name="println")
    @Help(shortDesc="print value with new line to std. i/o")
    public void println(@Name(name="value") Boolean value) {
        if (value != null) {
            this.getOutput().println((Object)value);
            this.getOutput().flush();
        } else {
            this.getOutput().println("null");
            this.getOutput().flush();
        }
    }

    @Fun
    @Name(name="println")
    @Help(shortDesc="print value with new line to std. i/o")
    public void println(@Name(name="value") boolean value) {
        this.getOutput().println(value);
        this.getOutput().flush();
    }

    @Fun
    @Name(name="print")
    @Help(shortDesc="print value to std. i/o")
    public void print(@Name(name="value") Boolean value) {
        if (value != null) {
            this.getOutput().print((Object)value);
            this.getOutput().flush();
        } else {
            this.getOutput().print("null");
            this.getOutput().flush();
        }
    }

    @Fun
    @Name(name="print")
    @Help(shortDesc="print value to std. i/o")
    public void print(@Name(name="value") boolean value) {
        this.getOutput().print(value);
        this.getOutput().flush();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

