/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.cli.fun;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.cli.BaseCLIFun;
import xyz.cofe.cli.Fun;
import xyz.cofe.cli.Name;
import xyz.cofe.text.Text;

public class StringFn
extends BaseCLIFun {
    private static final Logger logger = Logger.getLogger(StringFn.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    @Fun(operator=true)
    @Name(name="==")
    public Boolean cmpEquals(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    @Fun(operator=true)
    @Name(name="equ")
    public Boolean cmpEqualsNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    @Fun(operator=true)
    @Name(name="!=")
    public Boolean cmpNotEquals(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return !str1.equals(str2);
    }

    @Fun(operator=true)
    @Name(name="nequ")
    public Boolean cmpNotEqualsNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return !str1.equals(str2);
    }

    @Fun(operator=true)
    @Name(name="<")
    public Boolean cmpLess(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) < 0;
    }

    @Fun(operator=true)
    @Name(name="less")
    public Boolean cmpLessNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) < 0;
    }

    @Fun(operator=true)
    @Name(name="<=")
    public Boolean cmpLessOrEquals(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) <= 0;
    }

    @Fun(operator=true)
    @Name(name="lessEqu")
    public Boolean cmpLessOrEqualsNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) <= 0;
    }

    @Fun(operator=true)
    @Name(name=">")
    public Boolean cmpMore(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) < 0;
    }

    @Fun(operator=true)
    @Name(name="more")
    public Boolean cmpMoreNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) < 0;
    }

    @Fun(operator=true)
    @Name(name=">=")
    public Boolean cmpMoreOrEquals(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) >= 0;
    }

    @Fun(operator=true)
    @Name(name="moreEqu")
    public Boolean cmpMoreOrEqualsNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.compareTo(str2) >= 0;
    }

    @Fun(operator=true)
    @Name(name="*")
    public Boolean cmpWildcard(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        Pattern ptrn = Text.wildcard((String)str2, (boolean)false, (boolean)true);
        Matcher m = ptrn.matcher(str1);
        return m.matches();
    }

    @Fun(operator=true)
    @Name(name="wildcard")
    public Boolean cmpWildcardNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        Pattern ptrn = Text.wildcard((String)str2, (boolean)false, (boolean)true);
        Matcher m = ptrn.matcher(str1);
        return m.matches();
    }

    @Fun(operator=true)
    @Name(name="~")
    public Boolean cmpRegex(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.matches(str2);
    }

    @Fun(operator=true)
    @Name(name="regex")
    public Boolean cmpRegexNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return false;
        }
        return str1.matches(str2);
    }

    @Fun(operator=true)
    @Name(name="length")
    public Integer length(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str==null");
        }
        return str.length();
    }

    @Fun(operator=true)
    @Name(name="+")
    public String concat(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return str1;
        }
        return str1 + str2;
    }

    @Fun(operator=true)
    @Name(name="concat")
    public String concatNamed(String str1, String str2) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (str2 == null) {
            return str1;
        }
        return str1 + str2;
    }

    @Fun(operator=true)
    @Name(name="repeat")
    public String repeat(String str1, int count) {
        if (str1 == null) {
            throw new IllegalArgumentException("str1==null");
        }
        if (count < 1) {
            return "";
        }
        return Text.repeat((String)str1, (int)count);
    }

    @Fun(operator=true)
    @Name(name="encode")
    public String encode(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str==null");
        }
        return Text.encodeStringConstant((String)str);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

