/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

/**
 * Итератор возвращающий максимальные/минимальные значения из указаного множества
 * @author gocha
 */
public class MinMaxIterator<T> implements Iterator<T>
{
    private ArrayList<T> res = null;
    private Iterator<T> itr = null;
    
    /**
     * Конструктор мин/макс итератора
     * @param iterator Исходное множество
     * @param comparator Интерфес сравнения
     * @param findMax true - возвращать максимльные / false - возвращать минимальные объекты
     */
    public MinMaxIterator(Iterator<T> iterator, Comparator<T> comparator, boolean findMax)
    {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator == null");
        }
        
        T item = null;
        res = new ArrayList<T>();
        
        while(iterator.hasNext())
        {
            T i = iterator.next();
            if( i==null )continue;
            if( item==null )
            {
                item = i;
                res.add(item);
                continue;
            }
            int cres = comparator.compare(item, i);
            if( cres==0 )
            {
                res.add(i);
            }else{
                if( findMax && cres<0 )
                {
                    item = i;
                    res.clear();
                    res.add(item);
                }
                else if( !findMax && cres>0 )
                {
                    item = i;
                    res.clear();
                    res.add(item);
                }
            }
        }
        
        itr = res.iterator();
    }

    public boolean hasNext()
    {
        return itr.hasNext();
    }

    public T next()
    {
        return itr.next();
    }

    public void remove()
    {
        itr.remove();
    }
}
