/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Создает последовательность неповторяющихся объектов
 * @author gocha
 * @param <T> Тип объектов
 */
public class SetIterable<T> implements Iterable<T>
{
    private Iterable<T> src;
    private CompareEqu<T> cmp;

    /**
     * Конструктор последовательности неповторяющихся объектов
     * @param src Исходная последовательность
     */
	public SetIterable(Iterable<T> src)
	{
		if (src == null)
		{
			throw new IllegalArgumentException("src == null");
		}
        
        this.src = src;

		CompareEqu<T> defCmp = new CompareEqu<T>()
		{
			@Override
			public boolean isEqu(T a, T b)
			{
				if( a==null && b==null )return true;
				if( a!=null && b==null )return false;
				if( a==null && b!=null )return false;

				return a.equals(b);
			}
		};
        
        this.cmp = defCmp;
	}

    /**
     * Конструктор последовательности неповторяющихся объектов
     * @param src Исходная последовательность
     * @param comparer Сравнение объектов на равенство
     */
	public SetIterable(Iterable<T> src, CompareEqu<T> comparer)
	{
		if (src == null)
		{
			throw new IllegalArgumentException("src == null");
		}
		if (comparer == null)
		{
			throw new IllegalArgumentException("comparer == null");
		}
        
        this.cmp = comparer;
        this.src = src;
	}

	@Override
	public Iterator<T> iterator()
	{
		List<T> buffer = new ArrayList<T>();
        return new SetIterator<T>(src.iterator(), cmp, buffer);
	}
}
