/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * Обвертка над список
 * @author Камнев Георгий Павлович
 * @param <E> Тип элемента списка
 */
public class ListWrapper<E> implements List<E>
{
	/**
	 * Конструктор
	 * 
	 * @param wraplist
	 *            обварачиваемый экзмепляр
	 * @throws NullPointerException
	 *             если wraplist==null
	 */
	public ListWrapper(List<E> wraplist)
	{
		if(wraplist == null)
			throw new java.lang.NullPointerException();

		this.list = wraplist;
	}

	private List<E> list;

    /**
     * Возвращает обвернутый список
     * @return Исходный список
     */
	public synchronized List<E> getWrappedList()
	{
		return list;
	}
    
    /**
     * Устанавливает обвернутый список
     * @param list список
     */
    protected synchronized void setWrappedList(List<E> list){
        if( list==null )throw new IllegalArgumentException( "list==null" );
        this.list = list;
    }

    /* (non-javadoc)
     * @see java.util.List#add
     */
    @Override
	public boolean add(E e)
	{
		return list.add(e);
	}

    /* (non-javadoc)
     * @see java.util.List#add
     */
    @Override
	public void add(int index, E element)
	{
		list.add(index, element);
	}

    /* (non-javadoc)
     * @see java.util.List#addAll
     */
    @Override
	public boolean addAll(Collection<? extends E> c)
	{
		return list.addAll(c);
	}

    /* (non-javadoc)
     * @see java.util.List#addAll
     */
    @Override
	public boolean addAll(int index, Collection<? extends E> c)
	{
		return list.addAll(index, c);
	}

    /* (non-javadoc)
     * @see java.util.List#clear
     */
    @Override
	public void clear()
	{
		list.clear();
	}

    /* (non-javadoc)
     * @see java.util.List#contains
     */
    @Override
	public boolean contains(Object o)
	{
		return list.contains(o);
	}

    /* (non-javadoc)
     * @see java.util.List#containsAll
     */
    @Override
	public boolean containsAll(Collection<?> c)
	{
		return list.containsAll(c);
	}

    /* (non-javadoc)
     * @see java.util.List#get
     */
    @Override
	public E get(int index)
	{
		return list.get(index);
	}

    /**
     * Возвращает индекс объекта в коллекции или -1 если не найден
     * @param o Объект
     * @return Индекс объекта в коллекции или -1 если не найден
     */
    @Override
	public int indexOf(Object o)
	{
		return list.indexOf(o);
	}

    /* (non-javadoc)
     * @see java.util.List#isEmpty
     */
    @Override
	public boolean isEmpty()
	{
		return list.isEmpty();
	}

    /* (non-javadoc)
     * @see java.util.List#iterator
     */
    @Override
	public Iterator<E> iterator()
	{
		return list.iterator();
	}

    /* (non-javadoc)
     * @see java.util.List#lastIndexOf
     */
    @Override
	public int lastIndexOf(Object o)
	{
		return list.lastIndexOf(o);
	}

    /* (non-javadoc)
     * @see java.util.List#listIterator
     */
    @Override
	public ListIterator<E> listIterator()
	{
		return list.listIterator();
	}

    /* (non-javadoc)
     * @see java.util.List#listIterator
     */
    @Override
	public ListIterator<E> listIterator(int index)
	{
		return list.listIterator(index);
	}

    /* (non-javadoc)
     * @see java.util.List#remove
     */
    @Override
	public boolean remove(Object o)
	{
		return list.remove(o);
	}

    /* (non-javadoc)
     * @see java.util.List#remove
     */
    @Override
	public E remove(int index)
	{
		return list.remove(index);
	}

    /* (non-javadoc)
     * @see java.util.List#removeAll
     */
    @Override
	public boolean removeAll(Collection<?> c)
	{
		return list.removeAll(c);
	}

    /* (non-javadoc)
     * @see java.util.List#retainAll
     */
    @Override
	public boolean retainAll(Collection<?> c)
	{
		return list.retainAll(c);
	}

    /* (non-javadoc)
     * @see java.util.List#set
     */
    @Override
	public E set(int index, E element)
	{
		return list.set(index, element);
	}

    /* (non-javadoc)
     * @see java.util.List#size
     */
    @Override
	public int size()
	{
		return list.size();
	}

    /* (non-javadoc)
     * @see java.util.List#subList
     */
    @Override
	public List<E> subList(int fromIndex, int toIndex)
	{
		return list.subList(fromIndex, toIndex);
	}

    /* (non-javadoc)
     * @see java.util.List#toArray
     */
    @Override
	public Object[] toArray()
	{
		return list.toArray();
	}

    /* (non-javadoc)
     * @see java.util.List#toArray
     */
    @Override
	public <T> T[] toArray(T[] a)
	{
		return list.toArray(a);
	}

    @Override
    public String toString() {
        return list.toString(); //To change body of generated methods, choose Tools | Templates.
    }
}
