/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy <nt.gocha@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package xyz.cofe.collection.list;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.LockMethod;

/**
 *
 * @author nt.gocha@gmail.com
 */
public class LockEventList<E>
extends BasicEventList<E>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(LockEventList.class.getName());
    
    private static Level logLevel(){ return logger.getLevel(); }
    private static boolean isLogSevere(){
        Level ll = logLevel();
        return ll == null
            ? true
            : ll.intValue() <= Level.SEVERE.intValue();
    }
    private static boolean isLogWarning(){
        Level ll = logLevel();
        return ll == null
            ? true
            : ll.intValue() <= Level.WARNING.intValue();
    }
    private static boolean isLogInfo(){
        Level ll = logLevel();
        return ll == null
            ? true
            : ll.intValue() <= Level.INFO.intValue();
    }
    private static boolean isLogFine(){
        Level ll = logLevel();
        return ll == null
            ? true
            : ll.intValue() <= Level.FINE.intValue();
    }
    private static boolean isLogFiner(){
        Level ll = logLevel();
        return ll == null
            ? false
            : ll.intValue() <= Level.FINER.intValue();
    }
    private static boolean isLogFinest(){
        Level ll = logLevel();
        return ll == null
            ? false
            : ll.intValue() <= Level.FINEST.intValue();
    }
    
    private static void logEntering(String method,Object ... args){
        logger.entering(LockEventList.class.getName(), method, args);
    }
    private static void logExiting(String method,Object result){
        logger.exiting(LockEventList.class.getName(), method, result);
    }
    
    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }
    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }
    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }    
    //</editor-fold>

    protected final Lock lockWrite;
    protected final Lock lockRead;

    public LockEventList(List<E> wraplist) {
        super(wraplist);
        this.lockWrite = new ReentrantLock();
        this.lockRead = this.lockWrite;
    }

    public LockEventList(List<E> wraplist, Lock lock) {
        super(wraplist);
        this.lockWrite = lock!=null ? lock : new ReentrantLock();
        this.lockRead = this.lockWrite;
    }

    public LockEventList(List<E> wraplist, Lock lockRead, Lock lockWrite) {
        super(wraplist);
        this.lockWrite = lockWrite!=null ? lockWrite : new ReentrantLock();
        this.lockRead = lockRead!=null ? lockRead : this.lockWrite;
    }
    
    @Override
    protected Object lockRun(Func0 run, LockMethod method) {
        if( lockWrite==lockRead ){
            return lockRun(run);
        }else{
            if( method!=null ){
                boolean isRead = method.getWrite()==null || !method.getWrite();
                boolean isWrite = !isRead;
                if( isWrite ){
                    // write Lock
                    return lockRun(run);
                }else{
                    // read Lock
                    try{
                        lockRead.lock();
                        return run.apply();
                    }finally{
                        lockRead.unlock();
                    }
                }
            }else{
                return lockRun(run);
            }
        }
    }

    @Override
    protected Object lockRun(Func0 run) {
        try{
            lockWrite.lock();
            return run.apply();
        }finally{
            lockWrite.unlock();
        }
    }
}
