/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.list;


import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.AddedPositionalItemEvent;
import xyz.cofe.collection.AddedItemEvent;
import xyz.cofe.collection.AddingItemEvent;
import xyz.cofe.collection.AddingPositionalItemEvent;
import xyz.cofe.collection.RemovedPositionalItemEvent;
import xyz.cofe.collection.RemovedItemEvent;
import xyz.cofe.collection.RemovingItemEvent;
import xyz.cofe.collection.RemovingPositionalItemEvent;

/**
 * Адаптер события добавления / удаления объекта коллекции<br>
 * Существует несколько типов событий с коллекциями:<br>
 * <b>Added</b> - элемент добавлен в коллекцию, возможно он раньше уже находился в ней<br>
 * <b>Removed</b> - элемент удален из коллекции<br>
 * <b>Updated</b> - это частный случай когда, старый удален, а на его место установлен новый.
 * Данный адаптер рассматривает этот случай как два последовательных случая: Removed, Added
 * <br><br>
 * При приеме сообщения:<br>
 * <b>Added</b> - Будет вызван метод added<br>
 * <b>Removed</b> - Будет вызван метод removed<br>
 * <b>Updated</b> - Сначала будет вызван метод removed с удаленным элементов, затем added с добавленым элементом<br>
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 * @param <Element> Элемент списка
 */
public class SimpleListAdapter<Element> 
implements EventListListener<Element>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(SimpleListAdapter.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(SimpleListAdapter.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(SimpleListAdapter.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(SimpleListAdapter.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(SimpleListAdapter.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(SimpleListAdapter.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(SimpleListAdapter.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    /**
     * Обрабатывает сообщения от списка
     * @param evnt Сообщение
     */
    @Override
    public void listItemsChanged(Object evnt) {
        if( evnt instanceof RemovingItemEvent ){
            Element elem = (Element)((RemovingItemEvent)evnt).getRemovingItem();            
            Integer pos = null;
            if( evnt instanceof RemovingPositionalItemEvent ){
                pos = (Integer)((RemovingPositionalItemEvent)evnt).getRemovingItemPosition();
            }
            EventList elist = (EventList)((RemovingItemEvent)evnt).getCollection();
            removing(elem,elist,pos);
        }
        if( evnt instanceof AddingItemEvent ){
            Element elem = (Element)((AddingItemEvent)evnt).getAddingItem();            
            Integer pos = null;
            if( evnt instanceof AddingPositionalItemEvent ){
                pos = (Integer)((AddingPositionalItemEvent)evnt).getAddingItemPosition();
            }
            EventList elist = (EventList)((AddingItemEvent)evnt).getCollection();
            adding(elem,elist,pos);
        }
        if( evnt instanceof RemovedItemEvent ){
            Element elem = (Element)((RemovedItemEvent)evnt).getRemovedItem();            
            Integer pos = null;
            if( evnt instanceof RemovedPositionalItemEvent ){
                pos = (Integer)((RemovedPositionalItemEvent)evnt).getRemovedItemPosition();
            }
            EventList elist = (EventList)((RemovedItemEvent)evnt).getCollection();
            removed(elem,elist,pos);
        }
        if( evnt instanceof AddedItemEvent ){
            Element elem = (Element)((AddedItemEvent)evnt).getAddedItem();            
            Integer pos = null;
            if( evnt instanceof AddedPositionalItemEvent ){
                pos = (Integer)((AddedPositionalItemEvent)evnt).getAddedItemPosition();
            }
            EventList elist = (EventList)((AddedItemEvent)evnt).getCollection();
            added(elem,elist,pos);
        }
    }
    
    /**
     * Вызывается после добавлением/заменой элемента коллекции
     * @param e Добавленный элемент
     * @param list Коллекция список
     * @param position Позиция элемента, возможно null
     */
    protected void adding(Element e,EventList<Element> list,Integer position){
    }    
    
    /**
     * Вызывается после добавления/замены элемента коллекции
     * @param e Добавленный элемент
     * @param list Коллекция список
     * @param position Позиция элемента, возможно null
     */
    protected void added(Element e,EventList<Element> list,Integer position){
    }

    /**
     * Вызывается перед удалением/заменой элемента коллеции
     * @param e Удалленый/замененный элемент
     * @param list Коллеция список
     * @param position Позиция элемента, возможно null
     */
    protected void removing(Element e,EventList<Element> list,Integer position){
    }

    /**
     * Вызывается после удаления/замены элемента коллеции
     * @param e Удалленый/замененный элемент
     * @param list Коллеция список
     * @param position Позиция элемента, возможно null
     */
    protected void removed(Element e,EventList<Element> list,Integer position){
    }
}
