/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.list;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Список - на ограниченом списке элементов
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class SubList<E> 
extends AbstractList<E>
implements List<E>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(SubList.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(SubList.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(SubList.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(SubList.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(SubList.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(SubList.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(SubList.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    protected BasicEventList<E> list = null;
    protected int size = 0;
    protected int offset = 0;
    
    public SubList(BasicEventList<E> list,int beginIndex,int endIndexExclusive){
        if( list==null )throw new IllegalArgumentException( "list==null" );
        if( beginIndex<0 )throw new IllegalArgumentException( "beginIndex<0" );
        if( endIndexExclusive>list.size() )throw new IllegalArgumentException( "endIndexExclusive>list.size()" );
        if( beginIndex>endIndexExclusive )throw new IllegalArgumentException( "beginIndex>endIndexExclusive" );
        this.list = list;
        offset = beginIndex;
        size = endIndexExclusive - beginIndex;
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public boolean isEmpty() {
        return size==0;
    }

    @Override
    public boolean contains(Object o) {
        for( int i=0; i<size; i++ ){
            int ti = i+offset;
            int ss = list.size();
            if( ti>=ss )break;
            Object srcO = list.get(ti);
            if( o==null && srcO==null )return true;
            if( o!=null && srcO!=null ){
                if( o.equals(srcO) )return true;
            }
        }
        return false;
    }

//    @Override
//    public Iterator<E> iterator() {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[]{};
        for( int i=0; i<size; i++ ){
            int ti = i+offset;
            int ss = list.size();
            if( ti>=ss )break;
            Object srcO = list.get(ti);
            a = Arrays.copyOf(a, a.length+1);
            a[a.length-1] = srcO;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for( int i=0; i<size; i++ ){
            int ti = i+offset;
            int ss = list.size();
            if( ti>=ss )break;
            Object srcO = list.get(ti);
            a = Arrays.copyOf(a, a.length+1);
            a[a.length-1] = (T)srcO;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        int pos = offset+size;
        int ss = list.size();
        if( pos>=ss ){
            boolean succ = list.add(e);
            if( succ ){
                size++;
            }
            return succ;
        }else{
            list.add(pos, e);
            size++;
            return true;
        }
    }

//    @Override
//    public boolean remove(Object o) {
//        ArrayList<Integer> srcIdx = new ArrayList<Integer>();
//        for( int i=0; i<size; i++ ){
//            int ti = i+offset;
//            int ss = list.size();
//            if( ti>=ss )break;
//            Object srcO = list.get(ti);
//            if( o==null && srcO==null ){
//                if( srcIdx.isEmpty() ){
//                    srcIdx.add(ti);
//                }else{
//                    srcIdx.add(0,ti);
//                }
//            }else if( o!=null && srcO!=null ){
//                if( o.equals(srcO) ){
//                    if( srcIdx.isEmpty() ){
//                        srcIdx.add(ti);
//                    }else{
//                        srcIdx.add(0,ti);
//                    }
//                }
//            }
//        }
//        int co = 0;
//        for( Integer sidx : srcIdx ){
//            list.remove(sidx);
//            co++;
//        }
//        return co>0;
//    }

    @Override
    public boolean containsAll(Collection<?> c) {        
        for( Object o : c ){
            if( !contains(o) )return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = false;
        for( E e : c ){
            boolean r = add(e);
            added = r ? r : added;
        }
        return added;
    }

//    @Override
//    public boolean addAll(int index, Collection<? extends E> c) {
//        boolean res = false;
//        int ei = -1;
//        for( E e : c ){
//            ei++;
//            int ti = offset + index + ei;
//            int s = list.size();
//            
//        }
//        return res;
//    }

//    @Override
//    public boolean removeAll(Collection<?> c) {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    @Override
//    public boolean retainAll(Collection<?> c) {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }

    @Override
    public void clear() {
        if( size<=0 )return;
        for( int i=size-1; i>=0; i-- ){
            int ti = i + offset;
            int s = list.size();
            if( ti<0 || ti>=s )continue;
            list.remove(ti);
        }
    }

    @Override
    public E get(int index) {
        if( index<0 )return null;
        if( index>=size )return null;
        int ti = offset+index;
        int s = list.size();
        if( ti<0 || ti>=s )return null;
        return list.get(ti);
    }

    @Override
    public E set(int index, E e) {
        if( index<0 )return null;
        if( index>=size )return null;
        int ti = offset+index;
        int s = list.size();
        if( ti<0 || ti>=s )return null;
        return list.set(ti,e);
    }

    @Override
    public void add(int index, E e) {
        if( index<0 )index = 0;
        if( index>size )index = size;
        int pos = offset+size+index;
        int ss = list.size();
        if( pos>=ss ){
            boolean succ = list.add(e);
            if( succ ){
                size++;
            }
        }else{
            list.add(pos, e);
            size++;
        }
    }

    @Override
    public E remove(int index) {
        if( index<0 )return null;
        if( index>=size )return null;
        if( size<=0 )return null;
        int ti = offset+index;
        int s = list.size();
        if( ti<0 || ti>=s )return null;
        E r = list.remove(ti);
        size--;
        return r;
    }

    @Override
    public int indexOf(Object o) {
        for( int i=0; i<size; i++ ){
            int ti = i+offset;
            int ss = list.size();
            if( ti>=ss )break;
            Object srcO = list.get(ti);
            if( o==null && srcO==null )return i;
            if( o!=null && srcO!=null ){
                if( o.equals(srcO) )return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for( int i=size-1; i>=0; i-- ){
            int ti = i+offset;
            int ss = list.size();
            if( ti>=ss )continue;
            Object srcO = list.get(ti);
            if( o==null && srcO==null )return i;
            if( o!=null && srcO!=null ){
                if( o.equals(srcO) )return i;
            }
        }
        return -1;
    }

//    @Override
//    public ListIterator<E> listIterator() {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    @Override
//    public ListIterator<E> listIterator(int index) {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }
//
//    @Override
//    public List<E> subList(int fromIndex, int toIndex) {
//        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
//    }
}
