/*
 * The MIT License
 *
 * Copyright 2016 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.list;


import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Список с поддержкой блокировки через операцию synchronized
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class SyncList<E>
extends ListWrapper<E>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(SyncList.class.getName());
    private static final Level logLevel = logger.getLevel();
    
    private static final boolean isLogSevere = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.SEVERE.intValue();
    
    private static final boolean isLogWarning = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.WARNING.intValue();
    
    private static final boolean isLogInfo = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.INFO.intValue();
    
    private static final boolean isLogFine = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINE.intValue();
    
    private static final boolean isLogFiner = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINER.intValue();
    
    private static final boolean isLogFinest = 
        logLevel==null 
        ? true
        : logLevel.intValue() <= Level.FINEST.intValue();

    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    
    private static void logEntering(String method,Object ... params){
        logger.entering(SyncList.class.getName(),method,params);
    }

    private static void logExiting(String method,Object result){
        logger.exiting(SyncList.class.getName(),method,result);
    }

    private static void logExiting(String method){
        logger.exiting(SyncList.class.getName(),method);
    }
    //</editor-fold>
    
    protected final Object sync;

    public SyncList(List<E> wraplist, Object sync)
    {
        super(wraplist);
        this.sync = sync==null ? this : sync;
    }

    @Override
    public String toString()
    {
        synchronized(sync){
            return super.toString();
        }
    }

    @Override
    public <T> T[] toArray(T[] a)
    {
        synchronized(sync){
            return super.toArray(a);
        }
    }

    @Override
    public Object[] toArray()
    {
        synchronized(sync){
            return super.toArray();
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex)
    {
        synchronized(sync){
            return super.subList(fromIndex, toIndex); 
        }
    }

    @Override
    public int size()
    {
        synchronized(sync){
            return super.size();
        }
    }

    @Override
    public E set(int index, E element)
    {
        synchronized(sync){
            return super.set(index, element);
        }
    }

    @Override
    public boolean retainAll(Collection<?> c)
    {
        synchronized(sync){
            return super.retainAll(c);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c)
    {
        synchronized(sync){
            return super.removeAll(c);
        }
    }

    @Override
    public E remove(int index)
    {
        synchronized(sync){
            return super.remove(index);
        }
    }

    @Override
    public boolean remove(Object o)
    {
        synchronized(sync){
            return super.remove(o);
        }
    }

    @Override
    public ListIterator<E> listIterator(int index)
    {
        synchronized(sync){
           return super.listIterator(index);
        }
    }

    @Override
    public ListIterator<E> listIterator()
    {
        synchronized(sync){
            return super.listIterator();
        }
    }

    @Override
    public int lastIndexOf(Object o)
    {
        synchronized(sync){
            return super.lastIndexOf(o);
        }
    }

    @Override
    public Iterator<E> iterator()
    {
        synchronized(sync){
            return super.iterator();
        }
    }

    @Override
    public boolean isEmpty()
    {
        synchronized(sync){
            return super.isEmpty();
        }
    }

    @Override
    public int indexOf(Object o)
    {
        synchronized(sync){
            return super.indexOf(o);
        }
    }

    @Override
    public E get(int index)
    {
        synchronized(sync){
            return super.get(index);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c)
    {
        synchronized(sync){
            return super.containsAll(c);
        }
    }

    @Override
    public boolean contains(Object o)
    {
        synchronized(sync){
            return super.contains(o);
        }
    }

    @Override
    public void clear()
    {
        synchronized(sync){
            super.clear();
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c)
    {
        synchronized(sync){
            return super.addAll(index, c);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c)
    {
        synchronized(sync){
            return super.addAll(c);
        }
    }

    @Override
    public void add(int index, E element)
    {
        synchronized(sync){
            super.add(index, element);
        }
    }

    @Override
    public boolean add(E e)
    {
        synchronized(sync){
            return super.add(e);
        }
    }

    @Override
    protected synchronized void setWrappedList(List<E> list)
    {
        synchronized(sync){
            super.setWrappedList(list);
        }
    }

    @Override
    public synchronized List<E> getWrappedList()
    {
        synchronized(sync){
            return super.getWrappedList();
        }
    }
}
