/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.list;


import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.UpdatedPositionalItemEvent;

/**
 * Событие о измении эемента списка - старый удален, новый добавлен, указывает на позиции в которой происходит изменение
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 * @param <E> Тип элемента в списке
 */
public class UpdatedPositionalEvent<E>
implements UpdatedPositionalItemEvent<E, EventList<E>,Integer>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(UpdatedPositionalEvent.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(UpdatedPositionalEvent.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(UpdatedPositionalEvent.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(UpdatedPositionalEvent.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(UpdatedPositionalEvent.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(UpdatedPositionalEvent.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(UpdatedPositionalEvent.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>
    
    protected E elementRemoved;
    protected E elementAdded;
    protected EventList<E> collection;
    protected Integer position;

    public UpdatedPositionalEvent(E elemRemoved, E elemAdded, EventList<E> coll,Integer pos){
        this.elementRemoved = elemRemoved;
        this.elementAdded = elemAdded;
        this.collection = coll;
        this.position = pos;
    }

    @Override
    public EventList<E> getCollection() {
        return collection;
    }

    @Override
    public E getRemovedItem() {
        return elementRemoved;
    }

    @Override
    public Integer getRemovedItemPosition() {
        return position;
    }

    @Override
    public Integer getAddedItemPosition() {
        return position;
    }

    @Override
    public E getAddedItem() {
        return elementAdded;
    }

    @Override
    public String toString() {
        return "UpdatedPositionalEvent{" + "elementRemoved=" + elementRemoved + ", elementAdded=" + elementAdded + ", position=" + position + '}';
    }
}