/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.map;

/**
 * Адаптер подписчика события карты
 * @author gocha
 * @param <Key> Тип ключа
 * @param <Value> Тип значения
 */
public class EventMapAdapter<Key,Value> implements EventMapListener<Key,Value>
{
    @Override
    public void eventMap(MapEvent<Key, Value> event)
    {
        if( event==null )return;
        if( event instanceof InsertedMapEvent )
        {
            EventMap<Key,Value> map = event.sourceMap();
            Key k = ((InsertedMapEvent<Key,Value>)event).getKey();
            Value v = ((InsertedMapEvent<Key,Value>)event).getValue();

            if( !callOnNullMap() && map==null )return;
            inserted(map, k, v);
        }
        if( event instanceof DeletedMapEvent )
        {
            EventMap<Key,Value> map = event.sourceMap();
            Key k = ((DeletedMapEvent<Key,Value>)event).getKey();
            Value v = ((DeletedMapEvent<Key,Value>)event).getValue();

            if( !callOnNullMap() && map==null )return;
            deleted(map, k, v);
        }
        if( event instanceof UpdatedMapEvent )
        {
            EventMap<Key,Value> map = event.sourceMap();
            Key k = ((UpdatedMapEvent<Key,Value>)event).getKey();
            Value v = ((UpdatedMapEvent<Key,Value>)event).getValue();
            Value vo = ((UpdatedMapEvent<Key,Value>)event).getOldValue();

            if( !callOnNullMap() && map==null )return;
            updated(map, vo, k, v);
        }
//        if( event instanceof ValueStateChangedMapEvent )
//        {
//            EventMap<Key,Value> map = event.sourceMap();
//            Value v = ((ValueStateChangedMapEvent<Key,Value>)event).getValue();
////            Key k = ((UpdatedMapEvent<Key,Value>)event).get();
//
//            if( !callOnNullMap() && map==null )return;
//            valueStateChanged(map, v);
//        }
    }

    protected boolean callOnNullMap(){ return false; }

    /**
     * Вызывается при добавлении нового ключа
     * @param map Карта
     * @param key Ключ
     * @param value Значение
     */
    protected void inserted(EventMap<Key,Value> map,Key key,Value value)
    {
    }

    /**
     * Вызывается при удалении существующего ключа
     * @param map Карта
     * @param key Ключ
     * @param value Значение
     */
    protected void deleted(EventMap<Key,Value> map,Key key,Value value)
    {
    }

//    protected void valueStateChanged(EventMap<Key,Value> map,Value value)
//    {
//    }

    /**
     * Вызывается при обновлении ключа
     * @param map Карта
     * @param old Старое значение
     * @param key Ключ
     * @param value Новое значение
     */
    protected void updated(EventMap<Key,Value> map,Value old,Key key,Value value)
    {
    }
}
