/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.map;

/**
 * Событие карты с элементами - ключ + значение
 * @author gocha
 * @param <Key> Тип ключа
 * @param <Value> Тип значения
 */
public class KeyValueMapEvent<Key,Value> extends MapEvent<Key,Value>
{
    private Key key = null;
    private Value value = null;

    /**
     * Конструктор
     * @param source Источник сообщений
     * @param key Ключ
     * @param value Значение
     */
    public KeyValueMapEvent(EventMap<Key,Value> source, Key key,Value value)
    {
        super(source);
        this.key = key;
        this.value = value;
    }
    
    /**
     * Конструктор копирования
     * @param source образец
     */
    public KeyValueMapEvent(KeyValueMapEvent<Key,Value> source){
        super(source);
        this.key = source!=null ? source.key : null;
        this.value = source!=null ? source.value : null;
    }

    /**
     * Возвращает Ключ
     * @return Ключ
     */
    public Key getKey() {
        return key;
    }
    
    public void setKey(Key k){ this.key = k; }

    /**
     * Возвращает Значение
     * @return Значение
     */
    public Value getValue() {
        return value;
    }
    
    public void setValue(Value v){ this.value = v; }

    @Override
    public KeyValueMapEvent<Key,Value> clone() {
        return new KeyValueMapEvent<Key, Value>(this);
    }
}
