/* 
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */
package xyz.cofe.collection.map;

import java.util.Collection;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Делегат к карте
 * @author gocha
 */
public class MapWrapper<Key,Value> implements Map<Key,Value>
{
    private Map<Key,Value> wrappedMap = null;

    /**
     * Конструктор
     * @param wrappedMap Исходная карта
     */
    public MapWrapper(Map<Key,Value> wrappedMap)
    {
        if (wrappedMap == null) {
            throw new IllegalArgumentException("wrappedMap == null");
        }
        this.wrappedMap = wrappedMap;
    }

    /**
     * Возвращает исходную карту
     * @return Исходная карта
     */
    public Map<Key, Value> getWrappedMap() {
        return wrappedMap;
    }

    /**
     * Устанавливает исходную картуы
     * @param wrappedMap Исходная карта
     */
    public void setWrappedMap(Map<Key, Value> wrappedMap) {
        if (wrappedMap == null) {
            throw new IllegalArgumentException("wrappedMap == null");
        }
        this.wrappedMap = wrappedMap;
    }

    // TODO v1 Протестировать как удаляются/вставляются значения
    public Collection<Value> values() {
        return wrappedMap.values();
    }

    public int size() {
        return wrappedMap.size();
    }

    public Value remove(Object key) {
        return wrappedMap.remove(key);
    }

    public void putAll(Map<? extends Key, ? extends Value> m) {
        wrappedMap.putAll(m);
    }

    public Value put(Key key, Value value) {
        return wrappedMap.put(key, value);
    }

    // TODO v1 Протестировать как удаляются/вставляются ключи
    public Set<Key> keySet() {
        return wrappedMap.keySet();
    }

    public boolean isEmpty() {
        return wrappedMap.isEmpty();
    }

//    public int hashCode() {
//        return wrappedMap.hashCode();
//    }

    public Value get(Object key) {
        return wrappedMap.get(key);
    }

    @Override
    public boolean equals(Object o) {
        return wrappedMap.equals(o);
    }

    // TODO v1 Протестировать как удаляются/вставляются ключи/значения
    public Set<Entry<Key, Value>> entrySet() {
        return wrappedMap.entrySet();
    }

    public boolean containsValue(Object value) {
        return wrappedMap.containsValue(value);
    }

    public boolean containsKey(Object key) {
        return wrappedMap.containsKey(key);
    }

    // TODO v1 Протестировать как удаляются/вставляются значения
    // TODO v1 Протестировать что передается уведомление
    public void clear() {
        wrappedMap.clear();
    }
}
