/*
 * The MIT License
 *
 * Copyright 2014 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.map;


import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.AddedPositionalItemEvent;
import xyz.cofe.collection.RemovedPositionalItemEvent;

/**
 * Адаптер события добавления / удаления объекта коллекции<br>
 * Существует несколько типов событий с коллекциями:<br>
 * <b>Added</b> - элемент добавлен в коллекцию, возможно он раньше уже находился в ней<br>
 * <b>Removed</b> - элемент удален из коллекции<br>
 * <b>Updated</b> - это частный случай когда, старый удален, а на его место установлен новый.
 * Данный адаптер рассматривает этот случай как два последовательных случая: Removed, Added
 * <br><br>
 * При приеме сообщения:<br>
 * <b>Added</b> - Будет вызван метод added<br>
 * <b>Removed</b> - Будет вызван метод removed<br>
 * <b>Updated</b> - Сначала будет вызван метод removed с удаленным элементов, затем added с добавленым элементом<br>
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
* @param <Key> Тип ключа
 * @param <Value> Тип значения
  */
public class SimpleMapAdapter<Key,Value> 
implements EventMapListener<Key,Value>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static void logFine(String message,Object ... args){
        Logger.getLogger(SimpleMapAdapter.class.getName()).log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        Logger.getLogger(SimpleMapAdapter.class.getName()).log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        Logger.getLogger(SimpleMapAdapter.class.getName()).log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        Logger.getLogger(SimpleMapAdapter.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        Logger.getLogger(SimpleMapAdapter.class.getName()).log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        Logger.getLogger(SimpleMapAdapter.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        Logger.getLogger(SimpleMapAdapter.class.getName()).log(Level.SEVERE, null, ex);
    }
    //</editor-fold>

    /**
     * Вызывается при добавлении/замене элемента коллекции
     * @param value Добавленный элемент
     * @param map Карта в которую добавлен элемент
     * @param key Добавленый ключ
     */
    protected void added(Value value,EventMap<Key,Value> map,Key key){
    }

    /**
     * Вызывается при удалении/замене элемента коллеции
     * @param value Удалленый/замененный элемент
     * @param map Карта
     * @param key Удаленный ключ
     */
    protected void removed(Value value,EventMap<Key,Value> map,Key key){
    }

    @Override
    public void eventMap(MapEvent<Key, Value> event) {
        if( event instanceof RemovedPositionalItemEvent ){
            Value elem = (Value)((RemovedPositionalItemEvent)event).getRemovedItem();            
            Key pos = (Key)((RemovedPositionalItemEvent)event).getRemovedItemPosition();
            EventMap coll = (EventMap)((RemovedPositionalItemEvent)event).getCollection();
            removed(elem,coll,pos);
        }
        if( event instanceof AddedPositionalItemEvent ){
            Value elem = (Value)((AddedPositionalItemEvent)event).getAddedItem();            
            Key pos = (Key)((AddedPositionalItemEvent)event).getAddedItemPosition();
            EventMap coll = (EventMap)((AddedPositionalItemEvent)event).getCollection();
            added(elem,coll,pos);
        }
    }
}
