/*
 * The MIT License
 *
 * Copyright 2017 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.tree;


import java.io.Closeable;
import java.util.LinkedList;
import java.util.Set;
//import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.list.EventList;
import xyz.cofe.collection.list.SyncEventList;
import xyz.cofe.common.ListenersHelper;
import xyz.cofe.common.Reciver;

/**
 * Синхронизированый узел древа
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public abstract class SyncTreeNode<Node extends TreeNode>
    extends IndexTreeNode<Node>
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(SyncTreeNode.class.getName());

    private static Level logLevel(){ 
        return logger.getLevel() ;
    }
    
    private static boolean isLogSevere(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.SEVERE.intValue();
    }
    
    private static boolean isLogWarning(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.WARNING.intValue();
    }
    
    private static boolean isLogInfo(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.INFO.intValue();
    }
    
    private static boolean isLogFine(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.FINE.intValue();
    }
    
    private static boolean isLogFiner(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINER.intValue();
    }    
    
    private static boolean isLogFinest(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINEST.intValue();
    }    
    
    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    
    private static void logEntering(String method,Object ... params){
        logger.entering(SyncTreeNode.class.getName(),method,params);
    }

    private static void logExiting(String method,Object result){
        logger.exiting(SyncTreeNode.class.getName(),method,result);
    }

    private static void logExiting(String method){
        logger.exiting(SyncTreeNode.class.getName(),method);
    }
    //</editor-fold>
    
    /**
     * Объект синхронизации, синхронизироваться будет по this
     */
    protected final Object sync;
    
    /**
     * Конструктор по умолчанию, 
     */
    @SuppressWarnings( "LeakingThisInConstructor" )
    public SyncTreeNode(){
        sync = this;
    }
    
    /**
     * Конструктор
     * @param sync Объект синхронизации или null, тогда синхронизироваться будет по this
     */
    public SyncTreeNode( Object sync ){
        this.sync = sync==null ? this : sync;
    }

    @Override
    protected EventList<Node> createEventList() {
        return (EventList)syncrun( new Func0() {
            @Override
            public Object apply() {         
            return new SyncEventList<Node>( new LinkedList<Node>(), sync );
            }}, "createEventList" );
    }
    
    //protected final LinkedList eventQueue

    @Override
    protected Object syncrun(Func0 run, String method, Object... args)
    {
        //return super.syncrun(run, method, args);
        synchronized( sync ){
            return run.apply();
        }
    }

    @Override
    public int getRootOffset()
    {
        //SyncTreeNode.super.getRootOffset();
        return (Integer)syncrun( new Func0() {
            @Override
            public Object apply() {         
            return SyncTreeNode.super.getRootOffset(); 
            }}, "getRootOffset" );
    }

    @Override
    public Node deepOffset(final int offset)
    {
        return (Node)syncrun( new Func0() {
            @Override
            public Object apply() { 
            return SyncTreeNode.super.deepOffset(offset); 
        }}, "deepOffset", offset );
    }

    @Override
    public int getNodesCount()
    {
        return (Integer)
            syncrun( new Func0() {
            @Override
            public Object apply() { 
                return SyncTreeNode.super.getNodesCount(); 
            }},
                     "getNodesCount"
            );
    }

    @Override
    public void popup(final TreeNodeEvent<Node> ev)
    {
        syncrun( new Func0() {
            @Override
            public Object apply() { 
            SyncTreeNode.super.popup(ev);
            return null;
        }}, "popup", ev );
    }

    @Override
    public void assignParentTo(final Object inserted)
    {
        syncrun( new Func0() {
            @Override
            public Object apply() { 
            SyncTreeNode.super.assignParentTo(inserted);
            return null;
        }}, "assignParentTo", inserted );
    }

    @Override
    public Set<TreeNodeListener> getTreeNodeListeners()
    {
        return (Set)syncrun( new Func0() {
            @Override
            public Object apply() { 
            return SyncTreeNode.super.getTreeNodeListeners();
        }}, "getTreeNodeListeners" );
    }

    @Override
    public void removeTreeNodeListener(final TreeNodeListener<Node> lsr)
    {
        syncrun( new Func0() {
            @Override
            public Object apply() { 
            SyncTreeNode.super.removeTreeNodeListener(lsr);
            return null;
        }}, "removeTreeNodeListener", lsr );
    }

    @Override
    public boolean hasTreeNodeListener(final TreeNodeListener<Node> lsr)
    {
        return (Boolean)syncrun( new Func0() {
            @Override
            public Object apply() { 
            return SyncTreeNode.super.hasTreeNodeListener(lsr);
            }}, "hasTreeNodeListener", lsr );
    }

    @Override
    public void fireTreeNodeEvent(final TreeNodeEvent<Node> ev)
    {
        syncrun( new Func0() {
            @Override
            public Object apply() { 
            SyncTreeNode.super.fireTreeNodeEvent(ev); 
            return null; 
        }}, "fireTreeNodeEvent", ev );
    }

    @Override
    public 
    <EventType extends TreeNodeEvent<Node>> 
    Closeable onTreeNodeEvent( final Class<EventType> cls, final Reciver<? super EventType> consumer)
    {
        return (Closeable)syncrun( new Func0() {
            @Override
            public Object apply() { 
                Reciver r = consumer;
                Class c = cls;
            return SyncTreeNode.super.onTreeNodeEvent(c, r);
        }}, "onTreeNodeEvent", cls, consumer );
    }

    @Override
    public 
    <EventType extends TreeNodeEvent<Node>> 
    Closeable onTreeNodeEvent( final Class<EventType> cls, final boolean weakLink, final Reciver<? super EventType> consumer)
    {
        return (Closeable)syncrun( new Func0() {
            @Override
            public Object apply() { 
            Class<EventType> c = cls;
            Reciver r = consumer;
            return SyncTreeNode.super.onTreeNodeEvent(c, weakLink, r);
            }}, "onTreeNodeEvent", cls, weakLink, consumer );
    }

    @Override
    public Closeable addTreeNodeListener(final TreeNodeListener<Node> lsr, final boolean weakLink)
    {
        return (Closeable)syncrun( 
            new Func0() {
            @Override
            public Object apply() { 
            return SyncTreeNode.super.addTreeNodeListener(lsr, weakLink);
                }}, "addTreeNodeListener", lsr, weakLink );
    }

    @Override
    public Closeable addTreeNodeListener(final TreeNodeListener<Node> lsr)
    {        
        return (Closeable)syncrun( new Func0() {
            @Override
            public Object apply() {  
            return SyncTreeNode.super.addTreeNodeListener(lsr);
        }}, "addTreeNodeListener", lsr );
    }

    /*@Override
    public ListenersHelper<TreeNodeListener, TreeNodeEvent> getListenersHelper()
    {
        return super.getListenersHelper();
    }*/
}
