/*
 * The MIT License
 *
 * Copyright 2017 Kamnev Georgiy (nt.gocha@gmail.com).
 *
 * Данная лицензия разрешает, безвозмездно, лицам, получившим копию данного программного 
 * обеспечения и сопутствующей документации (в дальнейшем именуемыми "Программное Обеспечение"), 
 * использовать Программное Обеспечение без ограничений, включая неограниченное право на 
 * использование, копирование, изменение, объединение, публикацию, распространение, сублицензирование 
 * и/или продажу копий Программного Обеспечения, также как и лицам, которым предоставляется 
 * данное Программное Обеспечение, при соблюдении следующих условий:
 *
 * Вышеупомянутый копирайт и данные условия должны быть включены во все копии 
 * или значимые части данного Программного Обеспечения.
 *
 * ДАННОЕ ПРОГРАММНОЕ ОБЕСПЕЧЕНИЕ ПРЕДОСТАВЛЯЕТСЯ «КАК ЕСТЬ», БЕЗ ЛЮБОГО ВИДА ГАРАНТИЙ, 
 * ЯВНО ВЫРАЖЕННЫХ ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ГАРАНТИЯМИ ТОВАРНОЙ ПРИГОДНОСТИ, 
 * СООТВЕТСТВИЯ ПО ЕГО КОНКРЕТНОМУ НАЗНАЧЕНИЮ И НЕНАРУШЕНИЯ ПРАВ. НИ В КАКОМ СЛУЧАЕ АВТОРЫ 
 * ИЛИ ПРАВООБЛАДАТЕЛИ НЕ НЕСУТ ОТВЕТСТВЕННОСТИ ПО ИСКАМ О ВОЗМЕЩЕНИИ УЩЕРБА, УБЫТКОВ 
 * ИЛИ ДРУГИХ ТРЕБОВАНИЙ ПО ДЕЙСТВУЮЩИМ КОНТРАКТАМ, ДЕЛИКТАМ ИЛИ ИНОМУ, ВОЗНИКШИМ ИЗ, ИМЕЮЩИМ 
 * ПРИЧИНОЙ ИЛИ СВЯЗАННЫМ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ ИЛИ ИСПОЛЬЗОВАНИЕМ ПРОГРАММНОГО ОБЕСПЕЧЕНИЯ 
 * ИЛИ ИНЫМИ ДЕЙСТВИЯМИ С ПРОГРАММНЫМ ОБЕСПЕЧЕНИЕМ.
 */

package xyz.cofe.collection.tree;


import java.util.LinkedHashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func1;

/**
 *
 * @author Kamnev Georgiy (nt.gocha@gmail.com)
 */
public class TreeNodeDeepCounterDef 
{
    //<editor-fold defaultstate="collapsed" desc="log Функции">
    private static final Logger logger = Logger.getLogger(TreeNodeDeepCounterDef.class.getName());

    private static Level logLevel(){ 
        return logger.getLevel() ;
    }
    
    private static boolean isLogSevere(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.SEVERE.intValue();
    }
    
    private static boolean isLogWarning(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.WARNING.intValue();
    }
    
    private static boolean isLogInfo(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.INFO.intValue();
    }
    
    private static boolean isLogFine(){
        Level level = logLevel();
        return level==null 
        ? true
        : level.intValue() <= Level.FINE.intValue();
    }
    
    private static boolean isLogFiner(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINER.intValue();
    }    
    
    private static boolean isLogFinest(){
        Level level = logLevel();
        return level==null 
        ? false
        : level.intValue() <= Level.FINEST.intValue();
    }    
    
    private static void logFine(String message,Object ... args){
        logger.log(Level.FINE, message, args);
    }
    
    private static void logFiner(String message,Object ... args){
        logger.log(Level.FINER, message, args);
    }
    
    private static void logFinest(String message,Object ... args){
        logger.log(Level.FINEST, message, args);
    }
    
    private static void logInfo(String message,Object ... args){
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message,Object ... args){
        logger.log(Level.WARNING, message, args);
    }
    
    private static void logSevere(String message,Object ... args){
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex){
        logger.log(Level.SEVERE, null, ex);
    }
    
    private static void logEntering(String method,Object ... params){
        logger.entering(TreeNodeDeepCounterDef.class.getName(),method,params);
    }

    private static void logExiting(String method,Object result){
        logger.exiting(TreeNodeDeepCounterDef.class.getName(),method,result);
    }

    private static void logExiting(String method){
        logger.exiting(TreeNodeDeepCounterDef.class.getName(),method);
    }
    //</editor-fold>

    public static final WeakHashMap<TreeNode,Integer> deepCounter = new WeakHashMap<TreeNode,Integer>();
    
    public static void onTreeNodeRemoved(TreeNode tn, Integer index, Object child){
        TreeNodeDeepCounterDef.setDeepCounterOf(tn, null);
    }
    
    public static void onTreeNodeAdded(TreeNode tn, Integer index, Object child){
        TreeNodeDeepCounterDef.setDeepCounterOf(tn, null);
    }
    
    public static Integer getDeepCounterOf( TreeNode tn ){
        if( tn==null )return null;
        synchronized(deepCounter){
            return deepCounter.get(tn);
        }
    }
    
    public static void setDeepCounterOf( TreeNode tn, Integer v ){
        if( tn==null )return;
        synchronized(deepCounter){
            if( v==null ){
                logFiner("reset deep counter for {0}", tn);
                deepCounter.remove(tn);                
            }else{
                logFiner("set deep counter for {0} = {1}", tn, v);
                deepCounter.put(tn, v);
            }
            
            LinkedHashSet<TreeNode> visited = new LinkedHashSet<TreeNode>();
            visited.add(tn);
            
            TreeNode ptn = tn.getParent();
            if( ptn!=null )resetDeepCounterOf(ptn, visited);
        }
    }
    
    protected static void resetDeepCounterOf( TreeNode tn, Set<TreeNode> visited ){
        if( tn==null )return;
        if( visited.contains(tn) )return;
        
        deepCounter.remove(tn);        
        visited.add(tn);
        
        resetDeepCounterOf(tn.getParent(), visited);
    }
    
    public static int getNodesCountOf( TreeNode tn ){
        if( tn==null )return -1;
        synchronized(tn){
            // cache
            Integer c = getDeepCounterOf(tn);
            if( c!=null )return c;
            
            int sum = 0;
            
            TreeNode[] children = tn.getChildren();
            for( TreeNode ctn : children ){
                if( ctn==null )continue;
                
                if( ctn instanceof TreeNodeDeepCounter ){
                    TreeNodeDeepCounter tndc = (TreeNodeDeepCounter)ctn;
                    int count = tndc.getNodesCount();
                    if( count<0 ){
                        logFiner( "can't eval deep counter of {0} - return {1}",tndc,count );
                        return -3;
                    }
                    sum += count;
                }else{
                    // can't eval
                    logFiner( "can't eval deep counter of {0} not instanceof TreeNodeDeepCounter",ctn );
                    return -2;
                }
            }
            
            // self
            sum += 1;
            
            // cache
            setDeepCounterOf(tn, sum);
            logFiner( "cache deep counter of {0} - sum={1}",tn, sum );
            
            return sum;
        }
    }
}
