/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import xyz.cofe.collection.Convertor;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.collection.Predicate;
import xyz.cofe.collection.Predicates;
import xyz.cofe.collection.iterators.AddIterable;
import xyz.cofe.collection.iterators.ArrayIterable;
import xyz.cofe.collection.iterators.BufferIterable;
import xyz.cofe.collection.iterators.CompareEqu;
import xyz.cofe.collection.iterators.ConvertIterable;
import xyz.cofe.collection.iterators.EmptyIterable;
import xyz.cofe.collection.iterators.MinMaxIterable;
import xyz.cofe.collection.iterators.PredicateIterable;
import xyz.cofe.collection.iterators.ReverseInterable;
import xyz.cofe.collection.iterators.SetIterable;
import xyz.cofe.collection.iterators.SingleIterable;
import xyz.cofe.collection.iterators.SubIterable;
import xyz.cofe.collection.iterators.TreeIterable;
import xyz.cofe.common.LazyValue;

public class Iterators {
    public static <T> Iterable<T> notNullFilter(Iterable<T> src) {
        return Iterators.predicate(src, Predicates.isNotNull());
    }

    public static <T> Iterable<T> array(T ... array) {
        return new ArrayIterable<T>(array);
    }

    public static boolean in(Object v, Object[] src) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        return Iterators.in(v, Iterators.array(src));
    }

    public static boolean in(Object v, Iterable src) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (v == null) {
            for (Object a : src) {
                if (a != null) continue;
                return true;
            }
            return false;
        }
        for (Object b : src) {
            if (!v.equals(b)) continue;
            return true;
        }
        return false;
    }

    public static <T> long count(Iterable<T> src) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        long co = 0L;
        for (T t : src) {
            ++co;
        }
        return co;
    }

    public static <T> void addTo(Iterable<T> src, Collection<T> collection) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (collection == null) {
            throw new IllegalArgumentException("collection == null");
        }
        for (T o : src) {
            collection.add(o);
        }
    }

    public static <T> List<T> asList(Iterable<T> src) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        ArrayList list = new ArrayList();
        Iterators.addTo(src, list);
        return list;
    }

    public static <T> Iterable<T> empty() {
        return new EmptyIterable();
    }

    public static <T> Iterable<T> single(T item) {
        return new SingleIterable<T>(item);
    }

    public static <T> Iterable<T> lazy(LazyValue<T> lazyValue) {
        return new SingleIterable<T>(lazyValue);
    }

    public static <T> Iterable<T> sequence(Iterable<T> ... src) {
        return new AddIterable<T>(src);
    }

    public static <T> Iterable<T> sequence(Iterable<Iterable<T>> src) {
        return new AddIterable(src);
    }

    public static <T> Iterable<T> sub(Iterable<T> src, Iterable<T> sub) {
        return new SubIterable<T>(src, sub);
    }

    public static <T> Iterable<T> sub(Iterable<T> src, Iterable<T> sub, CompareEqu<T> cmp) {
        return new SubIterable<T>(src, sub, cmp);
    }

    public static <T> Iterable<T> sub(Iterable<T> src, Iterable<T> sub, Comparator<T> cmp) {
        final Comparator<T> fcmp = cmp;
        return Iterators.sub(src, sub, new CompareEqu(){

            public boolean isEqu(Object a, Object b) {
                if (fcmp == null) {
                    return a == null ? b == null : a.equals(b);
                }
                return fcmp.compare(a, b) == 0;
            }
        });
    }

    public static <T> Iterable<T> buffer(Iterable<T> src) {
        return new BufferIterable<T>(src);
    }

    public static <T> Iterable<T> buffer(Iterable<T> src, List<T> buffer) {
        return new BufferIterable<T>(buffer, src);
    }

    public static <T> Iterable<T> predicate(Iterable<T> src, Predicate<T> predicate) {
        return new PredicateIterable<T>(predicate, src);
    }

    public static <T> Iterable<T> predicate(T[] src, Predicate<T> predicate) {
        return new PredicateIterable<T>(predicate, Iterators.array(src));
    }

    public static <From, To> Iterable<To> convert(Iterable<From> src, Convertor<From, To> convertor) {
        return new ConvertIterable<From, To>(src, convertor);
    }

    public static <From, To> Iterable<To> convert(From[] src, Convertor<From, To> convertor) {
        return Iterators.convert(Iterators.array(src), convertor);
    }

    public static <T> Iterable<T> min(Iterable<T> src, Comparator<T> cmp) {
        return new MinMaxIterable<T>(src, cmp, false);
    }

    public static <T> Iterable<T> max(Iterable<T> src, Comparator<T> cmp) {
        return new MinMaxIterable<T>(src, cmp, true);
    }

    public static <T> Iterable<T> reverse(Iterable<T> src) {
        return new ReverseInterable<T>(src);
    }

    public static <T> Iterable<T> set(Iterable<T> src) {
        return new SetIterable<T>(src);
    }

    public static <T> Iterable<T> set(Iterable<T> src, CompareEqu<T> comparer) {
        return new SetIterable<T>(src, comparer);
    }

    public static <T> Iterable<T> tree(T src, NodesExtracter<T, T> extracter) {
        return new TreeIterable<T>(src, extracter);
    }
}

