/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.iterators;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class MinMaxIterator<T>
implements Iterator<T> {
    private ArrayList<T> res = null;
    private Iterator<T> itr = null;

    public MinMaxIterator(Iterator<T> iterator, Comparator<T> comparator, boolean findMax) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator == null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator == null");
        }
        Object item = null;
        this.res = new ArrayList();
        while (iterator.hasNext()) {
            T i = iterator.next();
            if (i == null) continue;
            if (item == null) {
                item = i;
                this.res.add(item);
                continue;
            }
            int cres = comparator.compare(item, i);
            if (cres == 0) {
                this.res.add(i);
                continue;
            }
            if (findMax && cres < 0) {
                item = i;
                this.res.clear();
                this.res.add(item);
                continue;
            }
            if (findMax || cres <= 0) continue;
            item = i;
            this.res.clear();
            this.res.add(item);
        }
        this.itr = this.res.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.itr.hasNext();
    }

    @Override
    public T next() {
        return this.itr.next();
    }

    @Override
    public void remove() {
        this.itr.remove();
    }
}

