/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.list.BasicEventList;

public class LockEventList<E>
extends BasicEventList<E> {
    private static final Logger logger = Logger.getLogger(LockEventList.class.getName());
    protected final Lock lockWrite;
    protected final Lock lockRead;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = LockEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = LockEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = LockEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = LockEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = LockEventList.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = LockEventList.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(LockEventList.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LockEventList.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public LockEventList(List<E> wraplist) {
        super(wraplist);
        this.lockRead = this.lockWrite = new ReentrantLock();
    }

    public LockEventList(List<E> wraplist, Lock lock) {
        super(wraplist);
        this.lockRead = this.lockWrite = lock != null ? lock : new ReentrantLock();
    }

    public LockEventList(List<E> wraplist, Lock lockRead, Lock lockWrite) {
        super(wraplist);
        this.lockWrite = lockWrite != null ? lockWrite : new ReentrantLock();
        this.lockRead = lockRead != null ? lockRead : this.lockWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lockRun(Func0 run, LockMethod method) {
        if (this.lockWrite == this.lockRead) {
            return this.lockRun(run);
        }
        if (method != null) {
            boolean isWrite;
            boolean isRead = method.getWrite() == null || method.getWrite() == false;
            boolean bl = isWrite = !isRead;
            if (isWrite) {
                return this.lockRun(run);
            }
            try {
                this.lockRead.lock();
                Object RetType = run.apply();
                return RetType;
            }
            finally {
                this.lockRead.unlock();
            }
        }
        return this.lockRun(run);
    }

    @Override
    protected Object lockRun(Func0 run) {
        try {
            this.lockWrite.lock();
            Object RetType = run.apply();
            return RetType;
        }
        finally {
            this.lockWrite.unlock();
        }
    }
}

