/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.list.ListWrapper;

public class LockList<E>
extends ListWrapper<E> {
    private static final Logger logger = Logger.getLogger(LockList.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lock;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public LockList(List<E> wraplist) {
        super(wraplist);
        this.lock = new ReentrantLock();
    }

    public LockList(List<E> wraplist, Lock lock) {
        super(wraplist);
        this.lock = lock != null ? lock : new ReentrantLock();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        try {
            this.lock.lock();
            T[] TArray = super.toArray(a);
            return TArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        try {
            this.lock.lock();
            Object[] objectArray = super.toArray();
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        try {
            this.lock.lock();
            List list = super.subList(fromIndex, toIndex);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        try {
            this.lock.lock();
            int n = super.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        try {
            this.lock.lock();
            E e = super.set(index, element);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = super.retainAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = super.removeAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E remove(int index) {
        try {
            this.lock.lock();
            Object e = super.remove(index);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        try {
            this.lock.lock();
            boolean bl = super.remove(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        try {
            this.lock.lock();
            ListIterator listIterator = super.listIterator(index);
            return listIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ListIterator<E> listIterator() {
        try {
            this.lock.lock();
            ListIterator listIterator = super.listIterator();
            return listIterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            this.lock.lock();
            int n = super.lastIndexOf(o);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        try {
            this.lock.lock();
            Iterator iterator = super.iterator();
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            this.lock.lock();
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        try {
            this.lock.lock();
            int n = super.indexOf(o);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public E get(int index) {
        try {
            this.lock.lock();
            Object e = super.get(index);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        try {
            this.lock.lock();
            boolean bl = super.containsAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(Object o) {
        try {
            this.lock.lock();
            boolean bl = super.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        try {
            this.lock.lock();
            boolean bl = super.addAll(index, c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try {
            this.lock.lock();
            boolean bl = super.addAll(c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void add(int index, E element) {
        try {
            this.lock.lock();
            super.add(index, element);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        try {
            this.lock.lock();
            boolean bl = super.add(e);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected synchronized void setWrappedList(List<E> list) {
        super.setWrappedList(list);
    }

    @Override
    public synchronized List<E> getWrappedList() {
        return super.getWrappedList();
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

