/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.list;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.list.IndexEventList;

public class SyncEventList<E>
extends IndexEventList<E> {
    private static final Logger logger = Logger.getLogger(SyncEventList.class.getName());
    protected final Object syncWrite;
    protected final Object syncRead;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level ll = SyncEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level ll = SyncEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level ll = SyncEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level ll = SyncEventList.logLevel();
        return ll == null ? true : ll.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level ll = SyncEventList.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level ll = SyncEventList.logLevel();
        return ll == null ? false : ll.intValue() <= Level.FINEST.intValue();
    }

    private static void logEntering(String method, Object ... args) {
        logger.entering(SyncEventList.class.getName(), method, args);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(SyncEventList.class.getName(), method, result);
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public SyncEventList(List<E> wraplist, Object sync) {
        super(wraplist);
        this.syncRead = this.syncWrite = sync == null ? this : sync;
    }

    public SyncEventList(List<E> wraplist, Object syncRead, Object syncWrite) {
        super(wraplist);
        this.syncWrite = syncWrite == null ? this : syncWrite;
        this.syncRead = syncRead == null ? this.syncWrite : syncRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lockRun(Func0 run, LockMethod method) {
        if (this.syncWrite == this.syncRead) {
            return this.lockRun(run);
        }
        if (method != null) {
            boolean isWrite;
            boolean isRead = method.getWrite() == null || method.getWrite() == false;
            boolean bl = isWrite = !isRead;
            if (isWrite) {
                return this.lockRun(run);
            }
            Object object = this.syncRead;
            synchronized (object) {
                return run.apply();
            }
        }
        return this.lockRun(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lockRun(Func0 run) {
        Object object = this.syncWrite;
        synchronized (object) {
            return run.apply();
        }
    }
}

