/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.map;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.map.BasicEventMap;

public class LockEventMap<Key, Value>
extends BasicEventMap<Key, Value> {
    private static final Logger logger = Logger.getLogger(LockEventMap.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Lock lockWrite;
    protected final Lock lockRead;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(LockEventMap.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(LockEventMap.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(LockEventMap.class.getName(), method, result);
    }

    public LockEventMap() {
        this.lockRead = this.lockWrite = this.createLock();
    }

    public LockEventMap(Map<Key, Value> wrappedMap) {
        super(wrappedMap);
        this.lockRead = this.lockWrite = this.createLock();
    }

    public LockEventMap(Map<Key, Value> wrappedMap, Lock lock) {
        super(wrappedMap);
        this.lockRead = this.lockWrite = lock == null ? this.createLock() : lock;
    }

    public LockEventMap(Map<Key, Value> wrappedMap, Lock lockRead, Lock lockWrite) {
        super(wrappedMap);
        this.lockWrite = lockWrite != null ? lockWrite : this.createLock();
        this.lockRead = lockRead != null ? lockRead : this.lockWrite;
    }

    protected Lock createLock() {
        return new ReentrantLock();
    }

    public Lock getLockWrite() {
        return this.lockWrite;
    }

    public Lock getLockRead() {
        return this.lockRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lockRun(Func0 run, LockMethod method) {
        if (this.lockWrite == this.lockRead) {
            return this.lockRun(run);
        }
        if (method != null) {
            boolean isWrite;
            boolean isRead = method.getWrite() == null || method.getWrite() == false;
            boolean bl = isWrite = !isRead;
            if (isWrite) {
                return this.lockRun(run);
            }
            try {
                this.lockRead.lock();
                Object RetType = run.apply();
                return RetType;
            }
            finally {
                this.lockRead.unlock();
            }
        }
        return this.lockRun(run);
    }

    @Override
    protected Object lockRun(Func0 run) {
        try {
            this.lockWrite.lock();
            Object RetType = run.apply();
            return RetType;
        }
        finally {
            this.lockWrite.unlock();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

