/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.set;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import xyz.cofe.collection.set.BasicEventSet;

public class ClassSet
extends BasicEventSet<Class> {
    public ClassSet() {
        super(new TreeSet<Class>(new ClassHeirarchyComparer()));
    }

    public ClassSet(boolean inverse) {
        super(new TreeSet<Class>(new ClassHeirarchyComparer(inverse)));
    }

    public ClassSet(boolean inverse, Iterable<Class> itr) {
        super(new TreeSet<Class>(new ClassHeirarchyComparer(inverse)));
        if (itr != null) {
            for (Class cls : itr) {
                if (cls == null) continue;
                this.add(cls);
            }
        }
    }

    public Collection<Class> getAssignableFrom(Class cls, boolean parentClasses, boolean childrenClasses) {
        if (cls == null) {
            throw new IllegalArgumentException("cls == null");
        }
        Collection<Class> res = this.createAssignableCollection();
        for (Class c : this) {
            boolean _clsAssignRes;
            boolean cAssignable = c.isAssignableFrom(cls);
            boolean _resAssignCls = parentClasses && cAssignable;
            boolean clsAssignable = cls.isAssignableFrom(c);
            boolean bl = _clsAssignRes = childrenClasses && clsAssignable;
            if (!_resAssignCls && !_clsAssignRes) continue;
            res.add(c);
        }
        return res;
    }

    public Collection<Class> getParentClassesFrom(Class cls) {
        return this.getAssignableFrom(cls, true, false);
    }

    public Class getFirstParentClassesFrom(Class cls) {
        Collection<Class> col = this.getParentClassesFrom(cls);
        if (col.isEmpty()) {
            return null;
        }
        Iterator<Class> i = col.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    public Class getLastParentClassesFrom(Class cls) {
        Collection<Class> col = this.getParentClassesFrom(cls);
        if (col.isEmpty()) {
            return null;
        }
        Iterator<Class> i = col.iterator();
        Class c = null;
        while (i.hasNext()) {
            c = i.next();
        }
        return c;
    }

    public Collection<Class> getChildClassesFrom(Class cls) {
        return this.getAssignableFrom(cls, false, true);
    }

    public Class getFirstChildClassesFrom(Class cls) {
        Collection<Class> col = this.getChildClassesFrom(cls);
        if (col.isEmpty()) {
            return null;
        }
        Iterator<Class> i = col.iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    public Class getLastChildClassesFrom(Class cls) {
        Collection<Class> col = this.getChildClassesFrom(cls);
        if (col.isEmpty()) {
            return null;
        }
        Iterator<Class> i = col.iterator();
        Class c = null;
        while (i.hasNext()) {
            c = i.next();
        }
        return c;
    }

    protected Collection<Class> createAssignableCollection() {
        return new ClassSet();
    }

    public Class firstItem() {
        if (this.isEmpty()) {
            return null;
        }
        Set set = this.getWrappedSet();
        if (set instanceof TreeSet) {
            TreeSet tset = (TreeSet)set;
            return (Class)tset.first();
        }
        Class res = null;
        ClassSet itr = this;
        for (Class it : itr) {
            if (it == null) continue;
            res = it;
            break;
        }
        return res;
    }

    public Class lastItem() {
        if (this.isEmpty()) {
            return null;
        }
        Set set = this.getWrappedSet();
        if (set instanceof TreeSet) {
            TreeSet tset = (TreeSet)set;
            return (Class)tset.last();
        }
        Class res = null;
        ClassSet itr = this;
        for (Class it : itr) {
            if (it == null) continue;
            res = it;
        }
        return res;
    }

    public static class ClassHeirarchyComparer
    implements Comparator<Class> {
        public boolean inverse = false;

        public ClassHeirarchyComparer(boolean inverse) {
            this.inverse = inverse;
        }

        public ClassHeirarchyComparer() {
            this.inverse = false;
        }

        @Override
        public int compare(Class o1, Class o2) {
            boolean itf2;
            boolean assignO2O1;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 == null) {
                return this.inverse ? 1 : -1;
            }
            if (o1 == null && o2 != null) {
                return this.inverse ? -1 : 1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            boolean assignO1O2 = o1.isAssignableFrom(o2);
            if (assignO1O2 == (assignO2O1 = o2.isAssignableFrom(o1))) {
                int r = o1.getName().compareTo(o2.getName());
                if (r == 0) {
                    return this.inverse ? 1 : -1;
                }
                return this.inverse ? -r : r;
            }
            boolean itf1 = o1.isInterface();
            if (itf1 != (itf2 = o2.isInterface())) {
                if (this.inverse) {
                    return itf1 ? -1 : 1;
                }
                return itf1 ? 1 : -1;
            }
            if (assignO1O2) {
                return this.inverse ? 1 : -1;
            }
            if (assignO2O1) {
                return this.inverse ? -1 : 1;
            }
            return 0;
        }
    }
}

