/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.set;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.LockMethod;
import xyz.cofe.collection.set.BasicEventSet;

public class SyncEventSet<E>
extends BasicEventSet<E> {
    private static final Logger logger = Logger.getLogger(SyncEventSet.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected final Object syncWrite;
    protected final Object syncRead;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(SyncEventSet.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(SyncEventSet.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(SyncEventSet.class.getName(), method, result);
    }

    public SyncEventSet() {
        this.syncRead = this.syncWrite = this;
    }

    public SyncEventSet(Object lock) {
        this.syncRead = this.syncWrite = lock != null ? lock : this;
    }

    public SyncEventSet(Set<E> set) {
        super(set);
        this.syncRead = this.syncWrite = this;
    }

    public SyncEventSet(Set<E> set, Object lock) {
        super(set);
        this.syncRead = this.syncWrite = lock != null ? lock : this;
    }

    public SyncEventSet(Set<E> set, Object syncRead, Object syncWrite) {
        super(set);
        this.syncWrite = syncWrite != null ? syncWrite : this;
        this.syncRead = syncRead != null ? syncRead : this.syncWrite;
    }

    public Object getSyncWrite() {
        return this.syncWrite;
    }

    public Object getSyncRead() {
        return this.syncRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lockRun(Func0 run, LockMethod method) {
        if (this.syncWrite == this.syncRead) {
            return this.lockRun(run);
        }
        if (method != null) {
            boolean isWrite;
            boolean isRead = method.getWrite() == null || method.getWrite() == false;
            boolean bl = isWrite = !isRead;
            if (isWrite) {
                return this.lockRun(run);
            }
            Object object = this.syncRead;
            synchronized (object) {
                return run.apply();
            }
        }
        return this.lockRun(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lockRun(Func0 run) {
        Object object = this.syncWrite;
        synchronized (object) {
            return run.apply();
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

