/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.NodesExtracter;

public class ArrayExtracter
implements NodesExtracter {
    private static final Logger logger = Logger.getLogger(ArrayExtracter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public Iterable extract(final Object from) {
        if (from == null) {
            return null;
        }
        Class<?> c = from.getClass();
        if (!c.isArray()) {
            return null;
        }
        int len = Array.getLength(from);
        if (len < 1) {
            return null;
        }
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new ArrayIterator(from);
            }
        };
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    public static class ArrayIterator
    implements Iterator<Object> {
        private Object array;
        private int idx = 0;
        private int len = -1;

        public ArrayIterator(Object array) {
            if (array == null) {
                throw new IllegalArgumentException("array==null");
            }
            this.array = array;
            this.idx = 0;
            this.len = Array.getLength(array);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ArrayIterator arrayIterator = this;
            synchronized (arrayIterator) {
                if (this.array == null) {
                    return false;
                }
                if (this.idx >= this.len) {
                    return false;
                }
                return this.idx >= 0;
                {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object next() {
            ArrayIterator arrayIterator = this;
            synchronized (arrayIterator) {
                if (this.array == null) {
                    return null;
                }
                if (this.idx >= this.len) {
                    return false;
                }
                if (this.idx < 0) {
                    return false;
                }
                Object res = Array.get(this.array, this.idx);
                ++this.idx;
                if (this.idx >= this.len) {
                    this.array = null;
                }
                return res;
            }
        }

        @Override
        public void remove() {
        }
    }
}

