/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.collection.tree;

import java.io.Closeable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.tree.BasicTreeNode;
import xyz.cofe.collection.tree.TreeNode;
import xyz.cofe.collection.tree.TreeNodeAdded;
import xyz.cofe.collection.tree.TreeNodeAdding;
import xyz.cofe.collection.tree.TreeNodeAssignSelfParent;
import xyz.cofe.collection.tree.TreeNodeEvent;
import xyz.cofe.collection.tree.TreeNodeListener;
import xyz.cofe.collection.tree.TreeNodeListenersDef;
import xyz.cofe.collection.tree.TreeNodeNotifier;
import xyz.cofe.collection.tree.TreeNodePopupEvent;
import xyz.cofe.collection.tree.TreeNodeRemoved;
import xyz.cofe.collection.tree.TreeNodeRemoving;
import xyz.cofe.collection.tree.TreeNodeSetParent;
import xyz.cofe.collection.tree.TreeNodeUpdateParent;
import xyz.cofe.common.Reciver;

public abstract class PopupTreeNode<Node extends TreeNode>
extends BasicTreeNode<Node>
implements TreeNodeNotifier<Node>,
TreeNodeAssignSelfParent<Node> {
    private static final Logger logger = Logger.getLogger(PopupTreeNode.class.getName());

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level level = PopupTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level level = PopupTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level level = PopupTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level level = PopupTreeNode.logLevel();
        return level == null ? true : level.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level level = PopupTreeNode.logLevel();
        return level == null ? false : level.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level level = PopupTreeNode.logLevel();
        return level == null ? false : level.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(PopupTreeNode.class.getName(), method, params);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(PopupTreeNode.class.getName(), method, result);
    }

    private static void logExiting(String method) {
        logger.exiting(PopupTreeNode.class.getName(), method);
    }

    @Override
    public void popup(final TreeNodeEvent<Node> ev) {
        this.syncrun(new Func0(){

            public Object apply() {
                if (ev instanceof TreeNodePopupEvent) {
                    TreeNodePopupEvent tnpe = (TreeNodePopupEvent)ev;
                    List l = tnpe.getPopupPath();
                    if (l != null) {
                        int cycles = 0;
                        for (TreeNode o : l) {
                            if (this != o) continue;
                            ++cycles;
                        }
                        if (cycles > 1) {
                            throw new Error("cycle detected");
                        }
                    }
                    l.add(this);
                    PopupTreeNode.this.fireTreeNodeEvent(ev);
                    Object pnode = PopupTreeNode.this.getParent();
                    if (pnode instanceof TreeNodeNotifier) {
                        ((TreeNodeNotifier)pnode).popup(ev);
                    }
                }
                return null;
            }
        }, "popup", ev);
    }

    @Override
    public void onTreeNodeAdded(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                if (this.val$child instanceof TreeNodeSetParent) {
                    TreeNodeSetParent tn = (TreeNodeSetParent)((Object)this.val$child);
                    tn.setParent(PopupTreeNode.this);
                }
                TreeNodeAdded ev = new TreeNodeAdded(PopupTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                PopupTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeAdded", index, child);
    }

    @Override
    public void onTreeNodeAdding(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                TreeNodeAdding ev = new TreeNodeAdding(PopupTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                PopupTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeAdding", index, child);
    }

    @Override
    public void onTreeNodeRemoved(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                if (this.val$child instanceof TreeNodeUpdateParent) {
                    ((TreeNodeUpdateParent)((Object)this.val$child)).updateParent(PopupTreeNode.this, null);
                }
                TreeNodeRemoved ev = new TreeNodeRemoved(PopupTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                PopupTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeRemoved", index, child);
    }

    @Override
    public void onTreeNodeRemoving(Integer index, Node child) {
        this.syncrun(new Func0((TreeNode)child, index){
            final /* synthetic */ TreeNode val$child;
            final /* synthetic */ Integer val$index;
            {
                this.val$child = treeNode;
                this.val$index = n;
            }

            public Object apply() {
                TreeNodeRemoving ev = new TreeNodeRemoving(PopupTreeNode.this, this.val$child, this.val$index);
                ev.getPopupPath().add(this.val$child);
                PopupTreeNode.this.popup(ev);
                return null;
            }
        }, "onTreeNodeRemoving", index, child);
    }

    @Override
    public Closeable addTreeNodeListener(TreeNodeListener<Node> lsr) {
        return TreeNodeListenersDef.addTreeNodeListener(this, lsr);
    }

    @Override
    public Closeable addTreeNodeListener(TreeNodeListener<Node> lsr, boolean weakLink) {
        return TreeNodeListenersDef.addTreeNodeListener(this, lsr, weakLink);
    }

    @Override
    public <EventType extends TreeNodeEvent<Node>> Closeable onTreeNodeEvent(Class<EventType> cls, boolean weakLink, Reciver<? super EventType> consumer) {
        return TreeNodeListenersDef.onTreeNodeEvent(this, cls, weakLink, consumer);
    }

    @Override
    public <EventType extends TreeNodeEvent<Node>> Closeable onTreeNodeEvent(Class<EventType> cls, Reciver<? super EventType> consumer) {
        return TreeNodeListenersDef.onTreeNodeEvent(this, cls, consumer);
    }

    @Override
    public void fireTreeNodeEvent(TreeNodeEvent<Node> ev) {
        TreeNodeListenersDef.fireTreeNodeEvent(this, ev);
    }

    @Override
    public boolean hasTreeNodeListener(TreeNodeListener<Node> lsr) {
        return TreeNodeListenersDef.hasTreeNodeListener(this, lsr);
    }

    @Override
    public void removeTreeNodeListener(TreeNodeListener<Node> lsr) {
        TreeNodeListenersDef.removeTreeNodeListener(this, lsr);
    }

    @Override
    public Set<TreeNodeListener> getTreeNodeListeners() {
        return TreeNodeListenersDef.getTreeNodeListeners(this);
    }
}

