/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.fn.Fn0;

public class DataColumn {
    private static final Logger logger = Logger.getLogger(DataColumn.class.getName());
    protected String name;
    protected Class dataType;
    protected boolean allowNull = true;
    protected boolean allowSubTypes = true;
    public Fn0 generator;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataColumn.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataColumn.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataColumn.class.getName(), method, result);
    }

    public DataColumn(String name, Class dataType) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType == null");
        }
        this.name = name;
        this.dataType = dataType;
    }

    public DataColumn(DataColumn sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample == null");
        }
        this.name = sample.name;
        this.dataType = sample.dataType;
        this.generator = sample.generator;
        this.allowNull = sample.allowNull;
        this.allowSubTypes = sample.allowSubTypes;
    }

    public DataColumn clone() {
        return new DataColumn(this);
    }

    public String getName() {
        return this.name;
    }

    public DataColumn name(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        DataColumn mc = this.clone();
        mc.name = name;
        return mc;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public DataColumn dataType(Class dtype) {
        if (dtype == null) {
            throw new IllegalArgumentException("dtype == null");
        }
        DataColumn mc = this.clone();
        mc.dataType = dtype;
        return mc;
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public DataColumn allowNull(boolean allow) {
        DataColumn mc = this.clone();
        mc.allowNull = allow;
        return mc;
    }

    public boolean isAllowSubTypes() {
        return this.allowSubTypes;
    }

    public DataColumn allowSubTypes(boolean allow) {
        DataColumn mc = this.clone();
        mc.allowSubTypes = allow;
        return mc;
    }

    public Fn0 getGenerator() {
        return this.generator;
    }

    public DataColumn generator(Fn0 gen) {
        DataColumn mc = this.clone();
        mc.generator = gen;
        return mc;
    }
}

