/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.events.DataEvent;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataTable;

public class DataColumnEvent
implements DataEvent {
    private static final Logger logger = Logger.getLogger(DataColumnEvent.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    private DataTable table;
    private DataColumn column;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataColumnEvent.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataColumnEvent.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataColumnEvent.class.getName(), method, result);
    }

    public DataColumnEvent() {
    }

    public DataColumnEvent(DataTable tbl, DataColumn mr) {
        this.table = tbl;
        this.column = mr;
    }

    public synchronized DataTable getTable() {
        return this.table;
    }

    public synchronized void setTable(DataTable table) {
        this.table = table;
    }

    public synchronized DataColumn getColumn() {
        return this.column;
    }

    public synchronized void setColumn(DataColumn column) {
        this.column = column;
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

