/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.data.events.DataEvent;
import xyz.cofe.data.table.DataCellUpdated;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataRowChangesCanceled;
import xyz.cofe.data.table.DataRowChangesFixed;
import xyz.cofe.data.table.DataRowState;
import xyz.cofe.data.table.DataRowStateChanged;
import xyz.cofe.data.table.DataTable;
import xyz.cofe.fn.Fn0;

public class DataRow
implements Closeable,
Serializable {
    private static final transient Logger logger = Logger.getLogger(DataRow.class.getName());
    protected int changes = 0;
    protected final Set<Integer> changed = new LinkedHashSet<Integer>();
    protected Object[] data;
    protected Object[] origin;
    protected volatile transient DataTable table;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataRow.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataRow.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataRow.class.getName(), method, result);
    }

    public DataRow(DataTable table, Object ... data) {
        if (table == null) {
            throw new IllegalArgumentException("table == null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        this.table = table;
        boolean earlyConstraint = false;
        if (earlyConstraint) {
            this.data = new Object[0];
            int ccnt = table.getColumnsCount();
            for (int i = 0; i < ccnt; ++i) {
                this.set(i, data[i], false);
            }
        } else {
            int ccnt = table.getColumnsCount();
            this.data = Arrays.copyOf(data, ccnt);
        }
        this.fixChanges(false);
    }

    public DataRow(DataTable dataTable, Object[] data, Object[] origin, int changes) {
        if (dataTable == null) {
            throw new IllegalArgumentException("dataTable == null");
        }
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("origin == null");
        }
        if (changes < 0) {
            throw new IllegalArgumentException("changes<0");
        }
        this.table = dataTable;
        this.data = data;
        this.origin = origin;
        this.changes = changes;
        int cmax = Math.max(origin.length, data.length);
        for (int ci = 0; ci < cmax; ++ci) {
            Object v2;
            Object v1 = ci < data.length ? data[ci] : null;
            Object object = v2 = ci < origin.length ? origin[ci] : null;
            if (Objects.equals(v1, v2)) continue;
            this.changed.add(ci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRow(DataRow sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample == null");
        }
        DataRow dataRow = sample;
        synchronized (dataRow) {
            this.table = sample.table;
            this.data = sample.data != null ? Arrays.copyOf(sample.data, sample.data.length) : null;
            this.origin = sample.origin != null ? Arrays.copyOf(sample.origin, sample.origin.length) : null;
            this.changes = sample.changes;
            this.changed.clear();
            this.changed.addAll(sample.changed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getData() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.table != null) {
                DataTable dataTable = this.table;
                synchronized (dataTable) {
                    int ccnt = this.table.getColumnsCount();
                    Object[] res = this.data == null ? new Object[ccnt] : Arrays.copyOf(this.data, ccnt);
                    return res;
                }
            }
            return this.data != null ? Arrays.copyOf(this.data, this.data.length) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getOrigin() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.table != null) {
                DataTable dataTable = this.table;
                synchronized (dataTable) {
                    int ccnt = this.table.getColumnsCount();
                    Object[] res = this.origin == null ? new Object[ccnt] : Arrays.copyOf(this.origin, ccnt);
                    return res;
                }
            }
            return this.origin != null ? Arrays.copyOf(this.origin, this.origin.length) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] getChangedColumn() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            return this.changed.toArray(new Integer[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            return this.changes > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeCount() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            return this.changes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangedValue> getChangedValues() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            ArrayList<ChangedValue> res = new ArrayList<ChangedValue>(10);
            for (Integer col : this.changed) {
                if (col == null) {
                    throw new IllegalStateException("changed column is null");
                }
                Object from = this.origin == null || col < 0 || col >= this.origin.length ? null : this.origin[col];
                Object to = this.data == null || col < 0 || col >= this.data.length ? null : this.data[col];
                res.add(new ChangedValue(col, from, to));
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelChanges() {
        DataTable mtbl = null;
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.origin == null) {
                throw new IllegalStateException("origin == null");
            }
            this.cancelChanges(true);
        }
        if (mtbl != null) {
            mtbl.fireEventQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelChanges(boolean addEvents) {
        DataTable tbl = null;
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.origin == null) {
                throw new IllegalStateException("origin == null");
            }
            this.data = Arrays.copyOf(this.origin, this.origin.length);
            this.changed.clear();
            this.changes = 0;
            tbl = this.table;
        }
        if (tbl != null && addEvents) {
            tbl.addDataEvent(new DataRowChangesCanceled(tbl, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixChanges() {
        DataTable tbl = null;
        DataRow dataRow = this;
        synchronized (dataRow) {
            tbl = this.table;
            this.fixChanges(true);
        }
        if (tbl != null) {
            tbl.fireEventQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixChanges(boolean addEvents) {
        DataTable tbl = null;
        DataRow dataRow = this;
        synchronized (dataRow) {
            this.origin = this.data != null ? Arrays.copyOf(this.data, this.data.length) : null;
            this.changed.clear();
            this.changes = 0;
            tbl = this.table;
        }
        if (tbl != null && addEvents) {
            tbl.addDataEvent(new DataRowChangesFixed(tbl, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DataRow dataRow = this;
        synchronized (dataRow) {
            this.table = null;
            this.data = null;
            this.origin = null;
            this.changed.clear();
            this.changes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int column) {
        if (column < 0) {
            throw new IllegalArgumentException("column(" + column + ") < 0");
        }
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.table == null) {
                throw new IllegalStateException("row detached from table");
            }
            if (this.data == null) {
                return null;
            }
            if (column >= this.data.length) {
                return null;
            }
            return this.data[column];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int column, Object value) {
        DataTable dt = null;
        DataRow dataRow = this;
        synchronized (dataRow) {
            dt = this.table;
            this.set(column, value, true);
        }
        if (dt != null) {
            dt.fireEventQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int column, Object value, boolean addEvents) {
        if (column < 0) {
            throw new IllegalArgumentException("column(" + column + ") < 0");
        }
        ArrayList<Object> evs = new ArrayList<Object>();
        DataRowState s0 = null;
        DataRowState s1 = null;
        DataRow dataRow = this;
        synchronized (dataRow) {
            DataTable mtable;
            if (this.table == null) {
                throw new IllegalStateException("row detached from table");
            }
            DataTable dataTable = this.table;
            synchronized (dataTable) {
                mtable = this.table;
                s0 = this.getState();
                DataColumn dataColumn = this.table.getColumn(column);
                if (dataColumn == null) {
                    throw new IllegalStateException("column(" + column + ") is null");
                }
                boolean allowNull = true;
                boolean allowSubType = true;
                Fn0 fgen = null;
                Class dtype = dataColumn.getDataType();
                if (dataColumn instanceof DataColumn) {
                    DataColumn mc = dataColumn;
                    allowNull = mc.isAllowNull();
                    allowSubType = mc.isAllowSubTypes();
                    fgen = mc.getGenerator();
                }
                if (!allowNull && value == null) {
                    boolean except = false;
                    if (fgen != null) {
                        Object nval = fgen.apply();
                        if (nval == null) {
                            except = true;
                        } else {
                            value = nval;
                        }
                    } else {
                        except = true;
                    }
                    if (except) {
                        throw new IllegalArgumentException("null value not allowed");
                    }
                }
                if (value != null && dtype != null) {
                    if (allowSubType) {
                        boolean assignable = dtype.isAssignableFrom(value.getClass());
                        if (!assignable) {
                            throw new ClassCastException("value(" + value + ") not assignable from " + dtype);
                        }
                    } else {
                        boolean assignable = dtype.equals(value.getClass());
                        if (!assignable) {
                            throw new ClassCastException("value type(" + value.getClass() + ") not equals to " + dtype);
                        }
                    }
                }
                if (this.changes == 0) {
                    this.origin = Arrays.copyOf(this.data, this.data.length);
                }
                if (column >= this.data.length) {
                    this.data = Arrays.copyOf(this.data, column + 1);
                }
                Object oldVal = this.data[column];
                Object orgVal = this.origin != null && column >= 0 && column < this.origin.length ? this.origin[column] : null;
                this.data[column] = value;
                ++this.changes;
                this.changed.add(column);
                if (addEvents) {
                    DataCellUpdated dcUpdEv = new DataCellUpdated();
                    dcUpdEv.setTable(this.table);
                    dcUpdEv.setRow(this);
                    dcUpdEv.setColumn(column);
                    dcUpdEv.setOldValue(oldVal);
                    dcUpdEv.setCurrentValue(value);
                    dcUpdEv.setOriginValue(orgVal);
                    evs.add(dcUpdEv);
                }
            }
            s1 = this.getState();
            if (!Objects.equals((Object)s0, (Object)s1)) {
                evs.add(new DataRowStateChanged(mtable, this, s0, s1));
            }
            if (mtable != null && !evs.isEmpty() && addEvents) {
                for (DataEvent dataEvent : evs) {
                    if (dataEvent == null) continue;
                    mtable.addDataEvent(dataEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTable getTable() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            return this.table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(DataTable table) {
        DataRow dataRow = this;
        synchronized (dataRow) {
            this.table = table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDetached() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            return this.table == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeleted() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.table == null) {
                return false;
            }
            return this.table.isDeleted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInserted() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.table == null) {
                return false;
            }
            return this.table.isInserted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdated() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.table == null) {
                return false;
            }
            return this.table.isUpdated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRowState getState() {
        DataRow dataRow = this;
        synchronized (dataRow) {
            if (this.table == null) {
                return DataRowState.Detached;
            }
            return this.table.stateOf(this);
        }
    }

    public static class ChangedValue {
        private int column;
        private Object from;
        private Object to;

        public int getColumn() {
            return this.column;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }

        public ChangedValue(int column, Object from, Object to) {
            this.column = column;
            this.from = from;
            this.to = to;
        }
    }
}

