/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.data.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.BasicEventList;
import xyz.cofe.collection.BasicEventSet;
import xyz.cofe.collection.CollectionEvent;
import xyz.cofe.collection.CollectionListener;
import xyz.cofe.collection.EventList;
import xyz.cofe.collection.EventSet;
import xyz.cofe.collection.PreEventList;
import xyz.cofe.collection.StdEventList;
import xyz.cofe.data.events.DataEvent;
import xyz.cofe.data.events.DataEventListener;
import xyz.cofe.data.events.DataEventSupport;
import xyz.cofe.data.table.DataColumn;
import xyz.cofe.data.table.DataColumnAdded;
import xyz.cofe.data.table.DataColumnRemoved;
import xyz.cofe.data.table.DataRow;
import xyz.cofe.data.table.DataRowClosed;
import xyz.cofe.data.table.DataRowDeleted;
import xyz.cofe.data.table.DataRowErased;
import xyz.cofe.data.table.DataRowEvent;
import xyz.cofe.data.table.DataRowInserted;
import xyz.cofe.data.table.DataRowState;
import xyz.cofe.data.table.DataRowStateChanged;
import xyz.cofe.data.table.DataRowUndeleted;
import xyz.cofe.data.table.DataTableDropped;
import xyz.cofe.data.table.DataTableInserting;
import xyz.cofe.ecolls.Closeables;
import xyz.cofe.ecolls.ListenersHelper;
import xyz.cofe.ecolls.ReadWriteLockSupport;
import xyz.cofe.fn.Fn0;
import xyz.cofe.fn.Fn1;
import xyz.cofe.fn.TripleConsumer;
import xyz.cofe.iter.Eterable;

public class DataTable
implements ReadWriteLockSupport {
    private static final transient Logger logger = Logger.getLogger(DataTable.class.getName());
    private final ReentrantReadWriteLock sync = new ReentrantReadWriteLock();
    protected final transient DataEventSupport listeners = new DataEventSupport();
    protected final LinkedBlockingQueue<DataEvent> eventQueue = new LinkedBlockingQueue();
    protected final transient AtomicInteger eventLockLevel = new AtomicInteger(0);
    private final transient Closeables constraintsListeners = new Closeables();
    private final Closeables rowTrackingListeners = new Closeables();
    private final AtomicLong scn = new AtomicLong(0L);
    private volatile EventList<DataColumn> columns;
    private final WeakHashMap<DataRow, Integer> rowIndexCache = new WeakHashMap();
    private transient boolean indexOf_lastIsInDeleted = false;
    private EventList<DataRow> workedRows;
    private transient Eterable<DataRow> allRows;
    private EventSet<DataRow> deletedRows;
    private EventSet<DataRow> insertedRows;
    protected final transient AtomicInteger dropCallLevel = new AtomicInteger(0);

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DataTable.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DataTable.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DataTable.class.getName(), method, result);
    }

    public DataTable() {
        this.initConstraints();
        this.initRowChangeTracking();
    }

    public DataTable(DataColumn[] columns) {
        this(columns, null);
    }

    public DataTable(DataColumn[] columns, Iterable<Object[]> initialData) {
        if (columns == null) {
            throw new IllegalArgumentException("columns==null");
        }
        for (int ci = 0; ci < columns.length; ++ci) {
            DataColumn mc = columns[ci];
            if (mc == null) {
                throw new IllegalArgumentException("columns[" + ci + "]==null");
            }
            this.getColumnsEventList().add((Object)mc);
        }
        if (initialData != null) {
            int ri = -1;
            for (Object[] data : initialData) {
                ++ri;
                if (data == null) {
                    throw new IllegalArgumentException("initialData[" + ri + "]==null");
                }
                DataRow mrow = new DataRow(this, data);
                this.getWorkedRows().add((Object)mrow);
            }
        }
        this.initConstraints();
        this.initRowChangeTracking();
    }

    public DataTable(DataColumn[] columns, Iterable<DataRow> rows, Iterable<DataRow> inserted, Iterable<DataRow> deleted) {
        if (columns == null) {
            throw new IllegalArgumentException("columns==null");
        }
        for (int ci = 0; ci < columns.length; ++ci) {
            DataColumn mc = columns[ci];
            if (mc == null) {
                throw new IllegalArgumentException("columns[" + ci + "]==null");
            }
            this.getColumnsEventList().add((Object)mc);
        }
        if (rows != null) {
            for (DataRow mrow : rows) {
                if (mrow == null) continue;
                this.getWorkedRows().add((Object)mrow);
            }
        }
        if (inserted != null) {
            for (DataRow mrow : inserted) {
                if (mrow == null) continue;
                this.getInsertedRows().add((Object)mrow);
            }
        }
        if (deleted != null) {
            for (DataRow mrow : deleted) {
                if (mrow == null) continue;
                this.getDeletedRows().add((Object)mrow);
            }
        }
        this.initConstraints();
        this.initRowChangeTracking();
    }

    public ReentrantReadWriteLock getReadWriteLock() {
        return this.sync;
    }

    public Lock getReadLock() {
        return this.sync.readLock();
    }

    public Lock getWriteLock() {
        return this.sync.writeLock();
    }

    public AutoCloseable addDataEventListener(DataEventListener ls, boolean weak) {
        return this.listeners.addDataEventListener(ls, weak);
    }

    public AutoCloseable addDataEventListener(DataEventListener ls) {
        return this.listeners.addDataEventListener(ls);
    }

    public void removeDataEventListener(DataEventListener ls) {
        this.listeners.removeDataEventListener(ls);
    }

    public boolean hasDataEventListener(DataEventListener ls) {
        return this.listeners.hasDataEventListener(ls);
    }

    public DataEventListener[] getDataEventListeners() {
        return this.listeners.getDataEventListeners();
    }

    public void fireEvent(DataEvent event) {
        this.listeners.fireDataEvent(event);
        this.scn.incrementAndGet();
    }

    public void addDataEvent(DataEvent ev) {
        if (ev != null) {
            this.eventQueue.add(ev);
        }
        this.scn.incrementAndGet();
    }

    public void fireEventQueue() {
        DataEvent e;
        int ll = this.eventLockLevel.get();
        if (ll > 0) {
            return;
        }
        while ((e = this.eventQueue.poll()) != null) {
            this.listeners.fireDataEvent(e);
        }
    }

    protected InternalRun createInternalRun() {
        return new InternalRun(){

            @Override
            public List<DataRow> getWorkedRows() {
                return DataTable.this.getWorkedRows();
            }

            @Override
            public Set<DataRow> getInsertedRows() {
                return DataTable.this.getInsertedRows();
            }

            @Override
            public Set<DataRow> getDeletedRows() {
                return DataTable.this.getDeletedRows();
            }

            @Override
            public long nextScn() {
                return DataTable.this.nextScn();
            }
        };
    }

    protected Object lockRunInternal(Fn1<InternalRun, Object> run) {
        if (run == null) {
            throw new IllegalArgumentException("run == null");
        }
        return this.writeLock(() -> run.apply((Object)this.createInternalRun()));
    }

    public <T extends DataEvent> AutoCloseable listen(final Class<T> evnType, boolean weakRef, final Consumer<T> listener) {
        if (evnType == null) {
            throw new IllegalArgumentException("evnType == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        return this.addDataEventListener(new DataEventListener(){

            public void dataEvent(DataEvent ev) {
                if (ev == null) {
                    return;
                }
                if (evnType.isAssignableFrom(ev.getClass())) {
                    listener.accept(ev);
                }
            }
        }, weakRef);
    }

    public <T extends DataEvent> AutoCloseable listen(Class<T> evnType, Consumer<T> listener) {
        if (evnType == null) {
            throw new IllegalArgumentException("evnType == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        return this.listen(evnType, false, listener);
    }

    public AutoCloseable onColumnAdded(boolean weak, Consumer<DataColumnAdded> listener) {
        return this.listen(DataColumnAdded.class, weak, listener);
    }

    public AutoCloseable onColumnAdded(Consumer<DataColumnAdded> listener) {
        return this.listen(DataColumnAdded.class, listener);
    }

    public AutoCloseable onColumnRemoved(boolean weak, Consumer<DataColumnAdded> listener) {
        return this.listen(DataColumnAdded.class, weak, listener);
    }

    public AutoCloseable onColumnRemoved(Consumer<DataColumnRemoved> listener) {
        return this.listen(DataColumnRemoved.class, listener);
    }

    public AutoCloseable onRowDeleted(boolean weak, Consumer<DataRowDeleted> listener) {
        return this.listen(DataRowDeleted.class, weak, listener);
    }

    public AutoCloseable onRowDeleted(Consumer<DataRowDeleted> listener) {
        return this.listen(DataRowDeleted.class, listener);
    }

    public AutoCloseable onRowUndeleted(boolean weak, Consumer<DataRowUndeleted> listener) {
        return this.listen(DataRowUndeleted.class, weak, listener);
    }

    public AutoCloseable onRowUndeleted(Consumer<DataRowUndeleted> listener) {
        return this.listen(DataRowUndeleted.class, listener);
    }

    public AutoCloseable onRowErased(boolean weak, Consumer<DataRowErased> listener) {
        return this.listen(DataRowErased.class, weak, listener);
    }

    public AutoCloseable onRowErased(Consumer<DataRowErased> listener) {
        return this.listen(DataRowErased.class, listener);
    }

    public AutoCloseable onDataTableDropped(boolean weak, Consumer<DataTableDropped> listener) {
        return this.listen(DataTableDropped.class, listener);
    }

    public AutoCloseable onDataTableDropped(Consumer<DataTableDropped> listener) {
        return this.listen(DataTableDropped.class, listener);
    }

    private void initConstraints() {
        this.listenForNotNullValue(this.constraintsListeners, this.getWorkedRows());
        this.listenForValueType(this.constraintsListeners, this.getWorkedRows());
    }

    private void listenForNotNullValue(Closeables cset, EventList<DataRow> elist) {
        TripleConsumer ls = (idx, old, cur) -> {
            if (cur != null) {
                DataRow dataRow = cur;
                synchronized (dataRow) {
                    this.readLock(() -> {
                        RuntimeException err = this.checkNullableValue((DataRow)cur, true);
                        if (err != null) {
                            throw err;
                        }
                    });
                }
            }
        };
        if (elist instanceof PreEventList) {
            cset.add(((PreEventList)elist).onInserting(ls));
            cset.add(((PreEventList)elist).onUpdating(ls));
        } else {
            cset.add(elist.onInserted(ls));
            cset.add(elist.onUpdated(ls));
        }
    }

    private RuntimeException checkNullableValue(DataRow dr, boolean initNull) {
        int ci = -1;
        for (DataColumn dc : this.getColumnsEventList()) {
            ++ci;
            if (dc.isAllowNull()) continue;
            Object value = dr.get(ci);
            Fn0 fgen = dc.getGenerator();
            if (value != null) continue;
            if (fgen != null) {
                Object nval = fgen.apply();
                if (nval == null) {
                    return new NullPointerException("column (index=" + ci + " name=" + dc.getName() + ") not allow null value");
                }
                RuntimeException typeErr = this.checkValueType(nval, dc, ci);
                if (typeErr != null) {
                    return typeErr;
                }
                value = nval;
                dr.set(ci, value);
            }
            return new NullPointerException("column (index=" + ci + " name=" + dc.getName() + ") not allow null value");
        }
        return null;
    }

    private void listenForValueType(Closeables cset, EventList<DataRow> elist) {
        TripleConsumer ls = (idx, old, cur) -> {
            if (cur != null) {
                DataRow dataRow = cur;
                synchronized (dataRow) {
                    RuntimeException err = this.checkValueType((DataRow)cur);
                    if (err != null) {
                        throw err;
                    }
                }
            }
        };
        AutoCloseable cl1 = elist.onInserted(ls);
        AutoCloseable cl2 = elist.onUpdated(ls);
        if (cset != null) {
            cset.add(cl1);
        }
        if (cset != null) {
            cset.add(cl2);
        }
    }

    private RuntimeException checkValueType(DataRow dr) {
        int ci = -1;
        for (DataColumn dc : this.getColumnsEventList()) {
            RuntimeException err;
            Object value;
            if ((value = dr.get(++ci)) == null || (err = this.checkValueType(value, dc, ci)) == null) continue;
            return err;
        }
        return null;
    }

    private RuntimeException checkValueType(Object value, DataColumn dc, int ci) {
        Class dtype = dc.getDataType();
        boolean allowSubType = true;
        allowSubType = dc.isAllowSubTypes();
        if (value != null && dtype != null) {
            if (allowSubType) {
                boolean assignable = dtype.isAssignableFrom(value.getClass());
                if (!assignable) {
                    return new ClassCastException("column(ci=" + ci + " name=" + dc.getName() + ") value type(" + value.getClass() + ") not assignable from " + dtype);
                }
            } else {
                boolean assignable = dtype.equals(value.getClass());
                if (!assignable) {
                    return new ClassCastException("column(ci=" + ci + " name=" + dc.getName() + ") value type(" + value.getClass() + ") not equals to " + dtype);
                }
            }
        }
        return null;
    }

    private void initRowChangeTracking() {
        AutoCloseable cl = this.getWorkedRows().onDeleted((TripleConsumer)new WorkedRowsOnDeletedTacking());
        this.rowTrackingListeners.add(cl);
        WorkedRowsOnUpdateInsertTracking fUpdateInsertTracker = new WorkedRowsOnUpdateInsertTracking();
        cl = this.getWorkedRows().onInserted((TripleConsumer)fUpdateInsertTracker);
        this.rowTrackingListeners.add(cl);
        cl = this.getWorkedRows().onUpdated((TripleConsumer)fUpdateInsertTracker);
        this.rowTrackingListeners.add(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrackChanges() {
        Closeables closeables = this.rowTrackingListeners;
        synchronized (closeables) {
            Object[] clarr = this.rowTrackingListeners.getCloseables();
            return clarr != null && clarr.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackChanges(boolean track) {
        Closeables closeables = this.rowTrackingListeners;
        synchronized (closeables) {
            this.rowTrackingListeners.close();
            if (track) {
                this.initRowChangeTracking();
            }
        }
    }

    public long getScn() {
        return this.scn.get();
    }

    protected long nextScn() {
        return this.scn.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventList<DataColumn> getColumnsEventList() {
        if (this.columns != null) {
            return this.columns;
        }
        DataTable dataTable = this;
        synchronized (dataTable) {
            if (this.columns != null) {
                return this.columns;
            }
            this.columns = new BasicEventList(new ArrayList(), (ReadWriteLock)this.sync);
            this.initReadonlyColumns(null, this.columns);
            return this.columns;
        }
    }

    public DataColumn[] getColumns() {
        return (DataColumn[])this.readLock(() -> {
            ArrayList<DataColumn> l = new ArrayList<DataColumn>();
            for (DataColumn dc : this.getColumnsEventList()) {
                l.add(dc.clone());
            }
            return l.toArray(new DataColumn[0]);
        });
    }

    public int getColumnsCount() {
        return this.getColumnsEventList().size();
    }

    public DataColumn getColumn(int cidx) {
        if (cidx < 0) {
            throw new IllegalArgumentException("cidx<0");
        }
        EventList<DataColumn> dclist = this.getColumnsEventList();
        if (cidx >= dclist.size()) {
            throw new IllegalArgumentException("cidx>=" + dclist.size());
        }
        return (DataColumn)dclist.get(cidx);
    }

    public void addColumn(DataColumn dc) {
        if (dc == null) {
            throw new IllegalArgumentException("dc == null");
        }
        this.writeLock(() -> this.getColumnsEventList().add((Object)dc));
    }

    public void removeColumn(DataColumn dc) {
        if (dc == null) {
            throw new IllegalArgumentException("dc == null");
        }
        this.writeLock(() -> this.getColumnsEventList().remove((Object)dc));
    }

    public void removeColumnByIndex(int colIdx) {
        this.writeLock(() -> (DataColumn)this.getColumnsEventList().remove(colIdx));
    }

    public void dropColumns() {
        this.writeLock(() -> this.getColumnsEventList().clear());
    }

    private void initReadonlyColumns(Closeables cset, EventList<DataColumn> columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns == null");
        }
        ReadonlyColumnsConstraint readonlyColumnsConstraint = new ReadonlyColumnsConstraint();
        AutoCloseable cl = columns.onChanged((TripleConsumer)readonlyColumnsConstraint);
        if (cset != null) {
            cset.add(cl);
        }
    }

    public int getRowsCount() {
        return (Integer)this.readLock(() -> this.getWorkedRows().size());
    }

    public DataRow getRow(int row) {
        if (row < 0) {
            throw new IllegalArgumentException("row < 0");
        }
        return (DataRow)this.readLock(() -> {
            if (row >= this.getWorkedRows().size()) {
                throw new IllegalArgumentException("row(" + row + ") >= getRowsCount(" + this.getWorkedRows().size() + ")");
            }
            return (DataRow)this.getWorkedRows().get(row);
        });
    }

    public int indexOf(DataRow mrow) {
        return (Integer)this.readLock(() -> {
            this.indexOf_lastIsInDeleted = false;
            if (mrow == null) {
                return -1;
            }
            Integer cachedRI = this.rowIndexCache.get(mrow);
            if (cachedRI != null) {
                Object oRow;
                boolean cacheMiss = false;
                int wrSize = this.getWorkedRows().size();
                if (cachedRI < 0) {
                    DataTable.logWarning("cached rowIndex({0}) < 0", cachedRI);
                    this.rowIndexCache.remove(mrow);
                    cacheMiss = true;
                }
                if (!cacheMiss && cachedRI >= wrSize) {
                    DataTable.logFiner("cached rowIndex({0}) >= workedRows.size({1})", cachedRI, wrSize);
                    this.rowIndexCache.remove(mrow);
                    cacheMiss = true;
                }
                if (!cacheMiss && !Objects.equals(oRow = this.getWorkedRows().get(cachedRI.intValue()), mrow)) {
                    DataTable.logFiner("cached row({0}) miss", cachedRI);
                    cacheMiss = true;
                }
                if (!cacheMiss) {
                    DataTable.logFinest("return cached index={0} for {1}", cachedRI, mrow);
                    return cachedRI;
                }
            }
            if (this.getDeletedRows().contains((Object)mrow)) {
                DataTable.logFinest("return index={0} from deletedRows", -1);
                this.indexOf_lastIsInDeleted = true;
                return -2;
            }
            int idx = this.getWorkedRows().indexOf((Object)mrow);
            if (idx >= 0) {
                this.rowIndexCache.put(mrow, idx);
                DataTable.logFiner("cache rowIndex = {0}", idx);
                return idx;
            }
            return -1;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventList<DataRow> getWorkedRows() {
        DataTable sync;
        DataTable dataTable = sync = this;
        synchronized (dataTable) {
            if (this.workedRows != null) {
                return this.workedRows;
            }
            this.workedRows = new StdEventList(new ArrayList(), (ReadWriteLock)this.sync);
            this.listenForDisableNullRows(null, this.workedRows);
            return this.workedRows;
        }
    }

    public Iterator<DataRow> getRowsIterator() {
        return (Iterator)this.readLock(() -> this.getWorkedRows().iterator());
    }

    public Eterable<DataRow> getRowsIterable() {
        return this.getWorkedRows();
    }

    public Eterable<DataRow> getRowsIterable(DataRowState ... states) {
        return (Eterable)this.readLock(() -> {
            Predicate<DataRow> filter = dr -> {
                DataRowState st = dr.getState();
                for (DataRowState fst : states) {
                    if (!Objects.equals((Object)st, (Object)fst)) continue;
                    return true;
                }
                return false;
            };
            return this.getRowsIterableAll().filter(filter);
        });
    }

    public List<DataRow> rowsList(DataRowState ... states) {
        return (List)this.readLock(() -> {
            Predicate<DataRow> filter = dr -> {
                DataRowState st = dr.getState();
                for (DataRowState fst : states) {
                    if (!Objects.equals((Object)st, (Object)fst)) continue;
                    return true;
                }
                return false;
            };
            ArrayList<DataRow> list = new ArrayList<DataRow>();
            for (DataRow dr2 : this.getRowsIterableAll().filter(filter)) {
                list.add(dr2);
            }
            return list;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Eterable<DataRow> getRowsIterableAll() {
        DataTable dataTable = this;
        synchronized (dataTable) {
            if (this.allRows != null) {
                return this.allRows;
            }
            this.allRows = Eterable.of(this.getWorkedRows()).union(new Iterable[]{this.getDeletedRows()});
            return this.allRows;
        }
    }

    private void listenForDisableNullRows(Closeables cset, EventList<DataRow> elist) {
        NullRowsDisabler nldis = new NullRowsDisabler();
        if (elist instanceof PreEventList) {
            AutoCloseable cl = ((PreEventList)elist).onInserting((TripleConsumer)nldis);
            if (cset != null) {
                cset.add(cl);
            }
            cl = ((PreEventList)elist).onUpdating((TripleConsumer)nldis);
            if (cset != null) {
                cset.add(cl);
            }
        } else {
            AutoCloseable cl = elist.onInserted((TripleConsumer)nldis);
            if (cset != null) {
                cset.add(cl);
            }
            cl = elist.onUpdated((TripleConsumer)nldis);
            if (cset != null) {
                cset.add(cl);
            }
            System.err.println("workedRows must implement PreEventList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventSet<DataRow> getDeletedRows() {
        DataTable dataTable = this;
        synchronized (dataTable) {
            if (this.deletedRows != null) {
                return this.deletedRows;
            }
            final SkipableListeners<CollectionListener<EventSet<DataRow>, DataRow>, CollectionEvent<EventSet<DataRow>, DataRow>> sl = new SkipableListeners<CollectionListener<EventSet<DataRow>, DataRow>, CollectionEvent<EventSet<DataRow>, DataRow>>((ls, ev) -> {
                if (ls != null) {
                    if (this.dropCallLevel.get() > 0) {
                        return;
                    }
                    ls.collectionEvent(ev);
                }
            }){

                public void fireEvent(CollectionEvent<EventSet<DataRow>, DataRow> event) {
                    if (DataTable.this.dropCallLevel.get() > 0) {
                        return;
                    }
                    super.fireEvent(event);
                }

                public void addEvent(CollectionEvent<EventSet<DataRow>, DataRow> ev) {
                    if (DataTable.this.dropCallLevel.get() > 0) {
                        return;
                    }
                    super.addEvent(ev);
                }

                public void runEventQueue() {
                    if (DataTable.this.dropCallLevel.get() > 0) {
                        return;
                    }
                    super.runEventQueue();
                }
            };
            this.deletedRows = new BasicEventSet<DataRow>(new LinkedHashSet(), (ReadWriteLock)this.getReadWriteLock()){

                public ListenersHelper<CollectionListener<EventSet<DataRow>, DataRow>, CollectionEvent<EventSet<DataRow>, DataRow>> listenerHelper() {
                    return sl;
                }
            };
            return this.deletedRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventSet<DataRow> getInsertedRows() {
        DataTable dataTable = this;
        synchronized (dataTable) {
            if (this.insertedRows != null) {
                return this.insertedRows;
            }
            this.insertedRows = new BasicEventSet(new LinkedHashSet(), (ReadWriteLock)this.getReadWriteLock());
            return this.insertedRows;
        }
    }

    public void fixed() {
        this.writeLock(() -> {
            this.rowTrackingListeners.close();
            ArrayList<DataRow> allRowsList = new ArrayList<DataRow>();
            for (DataRow dr : this.getRowsIterableAll()) {
                if (dr == null) {
                    throw new Error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
                }
                allRowsList.add(dr);
            }
            for (DataRow dr : allRowsList) {
                this.fixed(dr, true);
            }
            this.initRowChangeTracking();
        });
        this.fireEventQueue();
    }

    public void fixed(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        this.fixed(row, true);
        this.fireEventQueue();
    }

    public void fixed(DataRow row, boolean addEvents) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        this.writeLock(() -> {
            int ri = this.indexOf(row);
            DataRowState state0 = null;
            DataRowState state1 = null;
            state0 = this.stateOf(row);
            row.fixChanges(addEvents);
            boolean rowErased = false;
            boolean rowFixed = false;
            if (this.getInsertedRows().remove((Object)row)) {
                if (this.getWorkedRows().contains((Object)row)) {
                    rowFixed = true;
                } else {
                    rowErased = true;
                }
            } else if (this.getDeletedRows().remove((Object)row)) {
                rowErased = true;
            } else if (!this.getWorkedRows().contains((Object)row)) {
                if (this.getInsertedRows().contains((Object)row)) {
                    this.getInsertedRows().remove((Object)row);
                    rowErased = true;
                } else if (this.getDeletedRows().contains((Object)row)) {
                    this.getDeletedRows().remove((Object)row);
                    rowErased = true;
                }
            }
            if (rowErased && rowFixed) {
                throw new Error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
            }
            if (rowErased) {
                DataRowEvent e;
                if (addEvents) {
                    e = new DataRowErased(this, row);
                    e.setRowIndex(ri);
                    this.addDataEvent(e);
                }
                try {
                    row.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (addEvents) {
                    e = new DataRowClosed(this, row);
                    this.addDataEvent(e);
                }
            }
            if (!Objects.equals((Object)state0, (Object)(state1 = this.stateOf(row))) && addEvents) {
                this.addDataEvent(new DataRowStateChanged(this, row, state0, state1));
            }
        });
    }

    public void rollback() {
        this.rollback(true);
        this.fireEventQueue();
    }

    public void rollback(boolean addEvents) {
        this.writeLock(() -> {
            this.rowTrackingListeners.close();
            ArrayList<DataRow> allRowsList = new ArrayList<DataRow>();
            for (DataRow dr : this.getRowsIterableAll()) {
                if (dr == null) {
                    throw new Error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
                }
                allRowsList.add(dr);
            }
            for (DataRow dr : allRowsList) {
                this.rollback(dr, addEvents);
            }
            this.initRowChangeTracking();
        });
    }

    public void rollback(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        this.rollback(row, true);
        this.fireEventQueue();
    }

    public void rollback(DataRow row, boolean addEvents) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        this.writeLock(() -> {
            DataRowState s0 = null;
            DataRowState s1 = null;
            s0 = row.getState();
            switch (this.stateOf(row)) {
                case Detached: {
                    row.cancelChanges(addEvents);
                    break;
                }
                case Inserted: {
                    DataRowEvent e;
                    this.rowTrackingListeners.close();
                    int ri = this.indexOf(row);
                    row.cancelChanges(addEvents);
                    boolean insRemoved = this.getInsertedRows().remove((Object)row);
                    boolean wsRemoved = this.getWorkedRows().remove((Object)row);
                    boolean delRemoved = this.getDeletedRows().remove((Object)row);
                    if (addEvents) {
                        e = new DataRowErased(this, row);
                        e.setRowIndex(ri);
                        this.addDataEvent(e);
                    }
                    try {
                        row.close();
                        if (addEvents) {
                            e = new DataRowClosed(this, row);
                            this.addDataEvent(e);
                        }
                    }
                    catch (IOException e2) {
                        DataTable.logException(e2);
                    }
                    DataTable.logFiner("row {0} rollbacked from inserted to null, ins={1} ws={2} del={3}", row, insRemoved, wsRemoved, delRemoved);
                    this.initRowChangeTracking();
                    break;
                }
                case Deleted: {
                    this.rowTrackingListeners.close();
                    boolean insRemoved = this.getInsertedRows().remove((Object)row);
                    boolean wsRemoved = this.getDeletedRows().remove((Object)row);
                    int eri = this.getWorkedRows().indexOf((Object)row);
                    boolean delRemoved = this.getWorkedRows().add((Object)row);
                    row.cancelChanges(addEvents);
                    int ri = -1;
                    if (eri < 0) {
                        ri = this.getWorkedRows().indexOf((Object)row);
                    } else {
                        DataTable.logWarning("deleted row exists({0}) in workedset", eri);
                    }
                    if (addEvents) {
                        DataRowUndeleted ev = new DataRowUndeleted(this, row, ri);
                        this.addDataEvent(ev);
                    }
                    DataTable.logFiner("row {0} rollbacked from deleted to fixed, ins={1} ws={2} del={3}", row, insRemoved, wsRemoved, delRemoved);
                    this.initRowChangeTracking();
                    break;
                }
                case Fixed: {
                    break;
                }
                case Updated: {
                    row.cancelChanges(addEvents);
                }
            }
            s1 = row.getState();
            if (!Objects.equals((Object)s0, (Object)s1) && addEvents) {
                this.addDataEvent(new DataRowStateChanged(this, row, s0, s1));
            }
        });
    }

    public void drop() {
        this.writeLock(() -> {
            this.dropCallLevel.incrementAndGet();
            this.rowTrackingListeners.close();
            try {
                for (DataRow mrow : this.getWorkedRows()) {
                    try {
                        mrow.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                for (DataRow mrow : this.getInsertedRows()) {
                    try {
                        mrow.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                for (DataRow mrow : this.getDeletedRows()) {
                    try {
                        mrow.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DataTable.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                this.getColumnsEventList().clear();
            }
            finally {
                this.dropCallLevel.decrementAndGet();
                this.initRowChangeTracking();
            }
        });
        this.fireEvent(new DataTableDropped(this));
    }

    public boolean isDeleted(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("mrow == null");
        }
        return (Boolean)this.readLock(() -> this.getDeletedRows().contains((Object)row));
    }

    public boolean isInserted(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("mrow == null");
        }
        return (Boolean)this.readLock(() -> this.getInsertedRows().contains((Object)row));
    }

    public boolean isUpdated(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        return (Boolean)this.readLock(() -> row.isChanged() && !this.isDeleted(row) && !this.isInserted(row));
    }

    public DataRowState stateOf(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        return (DataRowState)((Object)this.readLock(() -> {
            int ri = this.indexOf(row);
            if (this.indexOf_lastIsInDeleted) {
                return DataRowState.Deleted;
            }
            if (ri < 0) {
                return DataRowState.Detached;
            }
            boolean ins = this.getInsertedRows().contains((Object)row);
            if (ins) {
                return DataRowState.Inserted;
            }
            if (row.isChanged()) {
                return DataRowState.Updated;
            }
            return DataRowState.Fixed;
        }));
    }

    public DataTableInserting insert(Object ... values) {
        if (values == null || values.length == 0) {
            return new DataTableInserting(this);
        }
        return new DataTableInserting(this, values);
    }

    public void insert(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        this.writeLock(() -> {
            this.nextScn();
            this.getWorkedRows().add((Object)row);
        });
    }

    public void delete(DataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row == null");
        }
        this.writeLock(() -> {
            this.nextScn();
            this.getWorkedRows().remove((Object)row);
        });
    }

    public class WorkedRowsOnDeletedTacking
    implements TripleConsumer<Integer, DataRow, DataRow> {
        public void accept(Integer idx, DataRow oldrow, DataRow nullRow) {
            if (oldrow != null) {
                if (DataTable.this.getInsertedRows().contains((Object)oldrow)) {
                    DataTable.this.getInsertedRows().remove((Object)oldrow);
                    DataTable.this.addDataEvent(new DataRowErased(DataTable.this, oldrow, idx));
                } else {
                    DataTable.this.getDeletedRows().add((Object)oldrow);
                    DataTable.this.addDataEvent(new DataRowDeleted(DataTable.this, oldrow, idx));
                }
            }
            DataTable.this.addDataEvent(new DataRowDeleted(DataTable.this, oldrow, idx));
            DataTable.this.fireEventQueue();
        }
    }

    public class WorkedRowsOnUpdateInsertTracking
    implements TripleConsumer<Integer, DataRow, DataRow> {
        public void accept(Integer idx, DataRow oldrow, DataRow newrow) {
            if (oldrow != null) {
                if (DataTable.this.getInsertedRows().contains((Object)oldrow)) {
                    DataTable.this.getInsertedRows().remove((Object)oldrow);
                    DataTable.this.addDataEvent(new DataRowErased(DataTable.this, oldrow, idx));
                } else {
                    DataTable.this.getDeletedRows().add((Object)oldrow);
                    DataTable.this.addDataEvent(new DataRowDeleted(DataTable.this, oldrow, idx));
                }
            }
            if (newrow != null) {
                DataTable.this.getInsertedRows().add((Object)newrow);
                DataTable.this.addDataEvent(new DataRowInserted(DataTable.this, newrow, idx));
            }
            DataTable.this.fireEventQueue();
        }
    }

    public class ReadonlyColumnsConstraint
    implements TripleConsumer<Integer, DataColumn, DataColumn> {
        public void accept(Integer arg1, DataColumn arg2, DataColumn arg3) {
            boolean hasDelData;
            boolean hasData = DataTable.this.getWorkedRows().size() > 0;
            boolean hasInsData = DataTable.this.getInsertedRows().size() > 0;
            boolean bl = hasDelData = DataTable.this.getDeletedRows().size() > 0;
            if (hasData || hasDelData || hasInsData) {
                throw new IllegalStateException("can't modify columns< while table contains data");
            }
        }
    }

    public class NullRowsDisabler
    implements TripleConsumer<Integer, DataRow, DataRow> {
        public void accept(Integer idx, DataRow old, DataRow cur) {
            if (cur == null) {
                throw new IllegalArgumentException("can't insert null row");
            }
        }
    }

    private static class SkipableListeners<ListenerType, EventType>
    extends ListenersHelper<ListenerType, EventType> {
        public SkipableListeners(BiConsumer<ListenerType, EventType> callListFunc) {
            super(callListFunc);
        }
    }

    public static interface InternalRun {
        public List<DataRow> getWorkedRows();

        public Set<DataRow> getInsertedRows();

        public Set<DataRow> getDeletedRows();

        public long nextScn();
    }
}

